/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.validator;

import com.vaadin.flow.data.validator.EmailValidator;
import com.vaadin.flow.data.validator.ValidatorTestBase;
import org.junit.Test;

public class EmailValidatorTest
extends ValidatorTestBase {
    @Test
    public void testNullStringFails() {
        this.assertPasses(null, this.shouldNotFail());
    }

    @Test
    public void testEmptyStringFails() {
        this.assertFails("", this.validator("empty string not allowed"));
    }

    @Test
    public void testStringWithoutAtSignFails() {
        this.assertFails("johannesd.vaadin", this.validator("@ is required"));
    }

    @Test
    public void testMissingLocalPartFails() {
        EmailValidator v = this.validator("local part is required");
        this.assertFails("@localhost", v);
        this.assertFails(" @localhost", v);
    }

    @Test
    public void testNonAsciiEmailFails() {
        EmailValidator v = this.validator("accented letters not allowed");
        this.assertFails("j\u00f6h\u00e4nnes@vaadin.com", v);
        this.assertFails("johannes@v\u00e1\u00e1d\u00ecn.com", v);
        this.assertFails("johannes@vaadin.c\u00f5m", v);
    }

    @Test
    public void testLocalPartWithPunctuationPasses() {
        EmailValidator v = this.shouldNotFail();
        this.assertPasses("johannesd+test@vaadin.com", v);
        this.assertPasses("johannes.dahlstrom@vaadin.com", v);
        this.assertPasses("johannes_d@vaadin.com", v);
    }

    @Test
    public void testEmailWithoutDomainPartFails() {
        this.assertFails("johannesd@", this.validator("domain part is required"));
    }

    @Test
    public void testComplexDomainPasses() {
        this.assertPasses("johannesd@foo.bar.baz.vaadin.com", this.shouldNotFail());
    }

    @Test
    public void testDomainWithPunctuationPasses() {
        this.assertPasses("johannesd@vaadin-dev.com", this.shouldNotFail());
    }

    @Test
    public void testMissingTldFails() {
        this.assertFails("johannesd@localhost", this.validator("tld is required"));
    }

    @Test
    public void testOneLetterTldFails() {
        this.assertFails("johannesd@vaadin.f", this.validator("one-letter tld not allowed"));
    }

    @Test
    public void testLongTldPasses() {
        this.assertPasses("joonas@vaadin.management", this.shouldNotFail());
    }

    @Test
    public void testIdnTldPasses() {
        this.assertPasses("leif@vaadin.XN--VERMGENSBERATER-CTB", this.shouldNotFail());
    }

    @Test
    public void testYelledEmailPasses() {
        this.assertPasses("JOHANNESD@VAADIN.COM", this.shouldNotFail());
    }

    @Test
    public void testEmailWithDigitsPasses() {
        this.assertPasses("johannes84@v44d1n.com", this.shouldNotFail());
    }

    @Test
    public void emptyString_validatorAcceptsEmptyValue_passesValidation() {
        this.assertPasses("", new EmailValidator("this should not fail", true));
    }

    @Test
    public void emptyString_validatorDoesNotAcceptsEmptyValue_validationFails() {
        this.assertFails("", new EmailValidator("explcitily disallowed empty value should not be accepted", false));
    }

    @Test
    public void testDomainWithDotDotFails() {
        EmailValidator v = this.validator("domains containing dot dot should fail");
        this.assertFails("hello@sample..com", v);
        this.assertFails("hello@samp..le..com", v);
    }

    private EmailValidator validator(String errorMessage) {
        return new EmailValidator(errorMessage);
    }

    private EmailValidator shouldNotFail() {
        return this.validator("this should not fail");
    }
}

