/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.converter;

import com.vaadin.flow.data.binder.Result;
import com.vaadin.flow.data.converter.LocalDateTimeToInstantConverter;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.junit.Assert;
import org.junit.Test;

public class LocalDateTimeToInstantConverterTest {
    private static final Instant INSTANT_EXAMPLE = Instant.parse("2007-12-03T10:15:30.00Z");
    private static final LocalDateTime LOCAL_DATE_TIME_EXAMPLE = LocalDateTime.of(2007, 12, 3, 10, 15, 30);
    LocalDateTimeToInstantConverter converter = new LocalDateTimeToInstantConverter(ZoneId.of("UTC"));

    @Test
    public void testNullConversionToModel() {
        Assert.assertEquals((Object)this.converter.convertToModel(null, null), (Object)Result.ok(null));
    }

    @Test
    public void testNullConversionToPresentation() {
        Assert.assertNull((Object)this.converter.convertToPresentation(null, null));
    }

    @Test
    public void testConvertToModel() {
        Assert.assertEquals((Object)Result.ok((Object)INSTANT_EXAMPLE), (Object)this.converter.convertToModel(LOCAL_DATE_TIME_EXAMPLE, null));
    }

    @Test
    public void testConvertToPresentation() {
        Assert.assertEquals((Object)LOCAL_DATE_TIME_EXAMPLE, (Object)this.converter.convertToPresentation(INSTANT_EXAMPLE, null));
    }
}

