/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.vaadin.flow.data.provider.AbstractDataProvider;
import com.vaadin.flow.data.provider.DataChangeEvent;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.DataProviderListener;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.EventObject;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;

public class AbstractDataProviderTest {
    @Test
    public void refreshAll_notifyListeners() {
        TestDataProvider dataProvider = new TestDataProvider();
        AtomicReference event = new AtomicReference();
        dataProvider.addDataProviderListener((DataProviderListener & Serializable)ev -> {
            Assert.assertNull(event.get());
            event.set(ev);
        });
        dataProvider.refreshAll();
        Assert.assertNotNull(event.get());
        Assert.assertEquals((Object)((Object)dataProvider), (Object)((DataChangeEvent)event.get()).getSource());
    }

    @Test
    public void removeListener_listenerIsNotNotified() {
        TestDataProvider dataProvider = new TestDataProvider();
        AtomicReference event = new AtomicReference();
        Registration registration = dataProvider.addDataProviderListener(event::set);
        registration.remove();
        dataProvider.refreshAll();
        Assert.assertNull(event.get());
    }

    @Test
    public void eventUnregisterListener_insideListener() {
        TestDataProvider provider = new TestDataProvider();
        AtomicBoolean eventIsFired = new AtomicBoolean();
        provider.addListener(DataChangeEvent.class, (SerializableConsumer & Serializable)event -> {
            eventIsFired.set(true);
            event.unregisterListener();
        });
        AtomicBoolean anotherListener = new AtomicBoolean();
        provider.addListener(DataChangeEvent.class, (SerializableConsumer & Serializable)event -> anotherListener.set(true));
        provider.fireEvent((EventObject)new DataChangeEvent((DataProvider)provider));
        Assert.assertTrue((boolean)eventIsFired.get());
        Assert.assertTrue((boolean)anotherListener.get());
        eventIsFired.set(false);
        anotherListener.set(false);
        provider.fireEvent((EventObject)new DataChangeEvent((DataProvider)provider));
        Assert.assertFalse((boolean)eventIsFired.get());
        Assert.assertTrue((boolean)anotherListener.get());
    }

    @Test(expected=IllegalStateException.class)
    public void eventUnregisterListener_outsideListener() {
        TestDataProvider provider = new TestDataProvider();
        AtomicReference savedEvent = new AtomicReference();
        provider.addListener(DataChangeEvent.class, (SerializableConsumer & Serializable)event -> savedEvent.set(event));
        provider.fireEvent((EventObject)new DataChangeEvent((DataProvider)provider));
        ((DataChangeEvent)savedEvent.get()).unregisterListener();
    }

    @Test
    public void eventUnregisterListener_insideListener_listenerThrows_listenerIsUnregistered() {
        TestDataProvider provider = new TestDataProvider();
        AtomicBoolean eventIsFired = new AtomicBoolean();
        provider.addListener(DataChangeEvent.class, (SerializableConsumer & Serializable)event -> {
            eventIsFired.set(true);
            event.unregisterListener();
            throw new NullPointerException();
        });
        try {
            provider.fireEvent((EventObject)new DataChangeEvent((DataProvider)provider));
            Assert.fail();
        }
        catch (NullPointerException ignore) {
            eventIsFired.set(false);
            provider.fireEvent((EventObject)new DataChangeEvent((DataProvider)provider));
            Assert.assertFalse((boolean)eventIsFired.get());
        }
    }

    private static class TestDataProvider
    extends AbstractDataProvider<Object, Object> {
        private TestDataProvider() {
        }

        public Stream<Object> fetch(Query<Object, Object> t) {
            return null;
        }

        public int size(Query<Object, Object> t) {
            return 0;
        }

        public boolean isInMemory() {
            return false;
        }
    }
}

