/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider.hierarchy;

import com.vaadin.flow.data.provider.CompositeDataGenerator;
import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.data.provider.hierarchy.AbstractHierarchicalDataCommunicatorTest;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalDataCommunicator;
import com.vaadin.flow.data.provider.hierarchy.TreeData;
import com.vaadin.flow.data.provider.hierarchy.TreeDataProvider;
import com.vaadin.flow.function.SerializableSupplier;
import java.io.Serializable;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import tools.jackson.databind.node.ObjectNode;

public class HierarchicalDataCommunicatorDataGenerationTest
extends AbstractHierarchicalDataCommunicatorTest {
    private TreeData<AbstractHierarchicalDataCommunicatorTest.Item> treeData = new TreeData();
    private TreeDataProvider<AbstractHierarchicalDataCommunicatorTest.Item> treeDataProvider = new TreeDataProvider(this.treeData);
    private HierarchicalDataCommunicator<AbstractHierarchicalDataCommunicatorTest.Item> dataCommunicator;
    @Mock
    private DataGenerator<AbstractHierarchicalDataCommunicatorTest.Item> dataGenerator;

    @Override
    @Before
    public void init() {
        super.init();
        CompositeDataGenerator compositeDataGenerator = new CompositeDataGenerator();
        this.dataCommunicator = new HierarchicalDataCommunicator(compositeDataGenerator, this.arrayUpdater, this.ui.getElement().getNode(), (SerializableSupplier & Serializable)() -> null);
        this.dataCommunicator.setDataProvider(this.treeDataProvider, null);
        compositeDataGenerator.addDataGenerator(this.dataGenerator);
        ((DataGenerator)Mockito.doAnswer(invocation -> {
            AbstractHierarchicalDataCommunicatorTest.Item item = (AbstractHierarchicalDataCommunicatorTest.Item)invocation.getArgument(0);
            Assert.assertTrue((String)"Item should be in keyMapper when generateData is called", (boolean)this.dataCommunicator.getKeyMapper().has((Object)item));
            return null;
        }).when(this.dataGenerator)).destroyData((Object)((AbstractHierarchicalDataCommunicatorTest.Item)Mockito.any()));
    }

    @Test
    public void changeViewportRangeBackAndForth_generateDataCalledForVisibleItems() {
        this.populateTreeData(this.treeData, 100, 2);
        this.dataCommunicator.expand((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"));
        this.dataCommunicator.setViewportRange(0, 4);
        this.fakeClientCommunication();
        ((DataGenerator)Mockito.verify(this.dataGenerator)).generateData((Object)((AbstractHierarchicalDataCommunicatorTest.Item)Mockito.eq((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"))), (ObjectNode)Mockito.any());
        ((DataGenerator)Mockito.verify(this.dataGenerator)).generateData((Object)((AbstractHierarchicalDataCommunicatorTest.Item)Mockito.eq((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0"))), (ObjectNode)Mockito.any());
        ((DataGenerator)Mockito.verify(this.dataGenerator)).generateData((Object)((AbstractHierarchicalDataCommunicatorTest.Item)Mockito.eq((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-1"))), (ObjectNode)Mockito.any());
        ((DataGenerator)Mockito.verify(this.dataGenerator)).generateData((Object)((AbstractHierarchicalDataCommunicatorTest.Item)Mockito.eq((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 1"))), (ObjectNode)Mockito.any());
        ((DataGenerator)Mockito.verify(this.dataGenerator, (VerificationMode)Mockito.never())).generateData((Object)((AbstractHierarchicalDataCommunicatorTest.Item)Mockito.eq((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 2"))), (ObjectNode)Mockito.any());
        this.dataCommunicator.setViewportRange(98, 4);
        this.fakeClientCommunication();
        ((DataGenerator)Mockito.verify(this.dataGenerator, (VerificationMode)Mockito.never())).generateData((Object)((AbstractHierarchicalDataCommunicatorTest.Item)Mockito.eq((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 95"))), (ObjectNode)Mockito.any());
        ((DataGenerator)Mockito.verify(this.dataGenerator)).generateData((Object)((AbstractHierarchicalDataCommunicatorTest.Item)Mockito.eq((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 96"))), (ObjectNode)Mockito.any());
        ((DataGenerator)Mockito.verify(this.dataGenerator)).generateData((Object)((AbstractHierarchicalDataCommunicatorTest.Item)Mockito.eq((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 97"))), (ObjectNode)Mockito.any());
        ((DataGenerator)Mockito.verify(this.dataGenerator)).generateData((Object)((AbstractHierarchicalDataCommunicatorTest.Item)Mockito.eq((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 98"))), (ObjectNode)Mockito.any());
        ((DataGenerator)Mockito.verify(this.dataGenerator)).generateData((Object)((AbstractHierarchicalDataCommunicatorTest.Item)Mockito.eq((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 99"))), (ObjectNode)Mockito.any());
    }

    @Test
    public void changeViewportRangeBackAndForth_destroyDataCalledForNoLongerVisibleItemsAfterConfirmation() {
        this.populateTreeData(this.treeData, 100, 2);
        this.dataCommunicator.expand((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"));
        this.dataCommunicator.setViewportRange(0, 4);
        this.fakeClientCommunication();
        this.dataCommunicator.confirmUpdate(this.captureArrayUpdateId());
        ((DataGenerator)Mockito.verify(this.dataGenerator, (VerificationMode)Mockito.never())).destroyData((Object)((AbstractHierarchicalDataCommunicatorTest.Item)Mockito.any()));
        Mockito.clearInvocations((Object[])new Serializable[]{this.dataGenerator, this.arrayUpdater, this.arrayUpdate});
        this.dataCommunicator.setViewportRange(2, 4);
        this.fakeClientCommunication();
        ((DataGenerator)Mockito.verify(this.dataGenerator, (VerificationMode)Mockito.never())).destroyData((Object)((AbstractHierarchicalDataCommunicatorTest.Item)Mockito.any()));
        this.dataCommunicator.confirmUpdate(this.captureArrayUpdateId());
        ((DataGenerator)Mockito.verify(this.dataGenerator)).destroyData((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"));
        ((DataGenerator)Mockito.verify(this.dataGenerator)).destroyData((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0"));
        ((DataGenerator)Mockito.verify(this.dataGenerator, (VerificationMode)Mockito.never())).destroyData((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-1"));
        ((DataGenerator)Mockito.verify(this.dataGenerator, (VerificationMode)Mockito.never())).destroyData((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 1"));
        Mockito.clearInvocations((Object[])new Serializable[]{this.dataGenerator, this.arrayUpdater, this.arrayUpdate});
        this.dataCommunicator.setViewportRange(0, 4);
        this.fakeClientCommunication();
        ((DataGenerator)Mockito.verify(this.dataGenerator, (VerificationMode)Mockito.never())).destroyData((Object)((AbstractHierarchicalDataCommunicatorTest.Item)Mockito.any()));
        this.dataCommunicator.confirmUpdate(this.captureArrayUpdateId());
        ((DataGenerator)Mockito.verify(this.dataGenerator, (VerificationMode)Mockito.never())).destroyData((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"));
        ((DataGenerator)Mockito.verify(this.dataGenerator, (VerificationMode)Mockito.never())).destroyData((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0"));
        ((DataGenerator)Mockito.verify(this.dataGenerator, (VerificationMode)Mockito.never())).destroyData((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-1"));
        ((DataGenerator)Mockito.verify(this.dataGenerator, (VerificationMode)Mockito.never())).destroyData((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 1"));
        ((DataGenerator)Mockito.verify(this.dataGenerator)).destroyData((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 2"));
        ((DataGenerator)Mockito.verify(this.dataGenerator)).destroyData((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 3"));
    }

    @Test
    public void collapseItems_destroyDataCalledForCollapsedChildrenInKeyMapper() {
        this.populateTreeData(this.treeData, 4, 2, 2);
        this.dataCommunicator.expand(Arrays.asList(new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0")));
        this.dataCommunicator.setViewportRange(0, 4);
        this.fakeClientCommunication();
        this.dataCommunicator.collapse((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"));
        ((DataGenerator)Mockito.verify(this.dataGenerator, (VerificationMode)Mockito.never())).destroyData((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"));
        ((DataGenerator)Mockito.verify(this.dataGenerator)).destroyData((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0"));
        ((DataGenerator)Mockito.verify(this.dataGenerator)).destroyData((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0-0"));
        ((DataGenerator)Mockito.verify(this.dataGenerator)).destroyData((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0-1"));
        ((DataGenerator)Mockito.verify(this.dataGenerator, (VerificationMode)Mockito.never())).destroyData((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-1"));
        ((DataGenerator)Mockito.verify(this.dataGenerator, (VerificationMode)Mockito.never())).destroyData((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 1"));
    }
}

