/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.binder;

import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.data.binder.DefaultBinderValidationErrorHandler;
import com.vaadin.flow.data.binder.ErrorLevel;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.testcomponents.TestTextField;
import com.vaadin.flow.dom.ThemeList;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class DefaultBinderValidationErrorHandlerTest {
    private DefaultBinderValidationErrorHandler handler = new DefaultBinderValidationErrorHandler();
    private TestTextField field = new TestTextField();
    private ThemeList themes = (ThemeList)Mockito.mock(ThemeList.class);

    @Test
    public void handleError_setValidationStatus_setErrorTheme() {
        this.handler.handleError((HasValue)this.field, ValidationResult.error((String)""));
        Assert.assertTrue((boolean)this.field.isInvalid());
        Assert.assertTrue((boolean)this.field.getElement().getThemeList().contains((Object)ErrorLevel.ERROR.name().toLowerCase(Locale.ENGLISH)));
    }

    @Test
    public void handleError_fieldHasTheme_setErrorTheme() {
        TestHasTheme field = new TestHasTheme();
        this.handler.handleError((HasValue)field, ValidationResult.error((String)""));
        ((ThemeList)Mockito.verify((Object)this.themes)).add((Object)ErrorLevel.ERROR.name().toLowerCase(Locale.ENGLISH));
    }

    @Test
    public void clearError_setValidationStatus_clearErrorTheme() {
        this.field.setInvalid(true);
        this.field.getElement().getThemeList().add((Object)ErrorLevel.CRITICAL.name().toLowerCase(Locale.ENGLISH));
        this.handler.clearError((HasValue)this.field);
        Assert.assertFalse((boolean)this.field.isInvalid());
        Assert.assertFalse((boolean)this.field.getElement().getThemeList().contains((Object)ErrorLevel.CRITICAL.name().toLowerCase(Locale.ENGLISH)));
    }

    @Test
    public void clearError_fieldHasTheme_clearErrorTheme() {
        TestHasTheme field = new TestHasTheme();
        this.handler.clearError((HasValue)field);
        ((ThemeList)Mockito.verify((Object)this.themes)).remove((Object)ErrorLevel.ERROR.name().toLowerCase(Locale.ENGLISH));
    }

    private class TestHasTheme
    extends TestTextField
    implements HasTheme {
        private TestHasTheme() {
        }

        public ThemeList getThemeNames() {
            return DefaultBinderValidationErrorHandlerTest.this.themes;
        }
    }
}

