/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.binder;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEffect;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.BinderValidationStatus;
import com.vaadin.flow.data.binder.BindingValidationStatus;
import com.vaadin.flow.data.binder.Result;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.data.binder.testcomponents.TestTextField;
import com.vaadin.flow.data.converter.Converter;
import com.vaadin.flow.data.converter.StringToIntegerConverter;
import com.vaadin.flow.dom.SignalsUnitTest;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.SerializableRunnable;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.WritableSignal;
import com.vaadin.flow.signals.local.ValueSignal;
import com.vaadin.flow.tests.data.bean.Person;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BinderSignalTest
extends SignalsUnitTest {
    private TestTextField firstNameField;
    private TestTextField lastNameField;
    private Binder<Person> binder;
    private Person item;

    @Before
    public void setup() {
        this.binder = new Binder(Person.class);
        this.item = new Person();
        this.firstNameField = new TestTextField();
        this.lastNameField = new TestTextField();
    }

    private SerializablePredicate<String> hasTextValuesValidator(Binder.Binding<?, String> otherFieldBinding) {
        return (SerializablePredicate & Serializable)value -> !value.isEmpty() && !((String)otherFieldBinding.value()).isEmpty();
    }

    @Test
    public void bindingValue_withBinderBindPropertyName() {
        this.item.setFirstName("Alice");
        TestTextField field = new TestTextField();
        Binder.Binding binding = this.binder.bind((HasValue)field, "firstName");
        Assert.assertEquals((Object)"", (Object)binding.value());
        Assert.assertEquals((Object)"", (Object)field.getValue());
        this.binder.setBean((Object)this.item);
        Assert.assertEquals((Object)"Alice", (Object)binding.value());
        Assert.assertEquals((Object)"Alice", (Object)field.getValue());
    }

    @Test
    public void bindingValue_withBinderBindGetterSetter() {
        this.binder = new Binder();
        this.item.setFirstName("Alice");
        TestTextField field = new TestTextField();
        Binder.Binding binding = this.binder.bind((HasValue)field, Person::getFirstName, Person::setFirstName);
        Assert.assertEquals((Object)"", (Object)binding.value());
        Assert.assertEquals((Object)"", (Object)field.getValue());
        this.binder.setBean((Object)this.item);
        Assert.assertEquals((Object)"Alice", (Object)binding.value());
        Assert.assertEquals((Object)"Alice", (Object)field.getValue());
    }

    @Test
    public void bindingValue_withSignal() {
        this.binder = new Binder();
        this.item.setFirstName("Alice");
        ValueSignal signal = new ValueSignal((Object)"");
        TestTextField field = new TestTextField();
        field.bindValue((WritableSignal)signal);
        Binder.Binding binding = this.binder.bind((HasValue)field, Person::getFirstName, Person::setFirstName);
        this.binder.setBean((Object)this.item);
        signal.value((Object)"foo");
        Assert.assertEquals((Object)"Alice", (Object)binding.value());
        UI.getCurrent().add(new Component[]{field});
        Assert.assertEquals((Object)"foo", (Object)binding.value());
        signal.value((Object)"bar");
        Assert.assertEquals((Object)"bar", (Object)binding.value());
        field.bindValue(null);
        signal.value((Object)"baz");
        Assert.assertEquals((Object)"bar", (Object)binding.value());
    }

    @Test
    public void bindingValue_crossFieldValidation_withSignal() {
        this.item.setFirstName("Alice");
        this.item.setLastName("Smith");
        ValueSignal firstNameSignal = new ValueSignal((Object)"");
        ValueSignal lastNameSignal = new ValueSignal((Object)"");
        this.firstNameField.bindValue((WritableSignal)firstNameSignal);
        this.lastNameField.bindValue((WritableSignal)lastNameSignal);
        UI.getCurrent().add(new Component[]{this.firstNameField, this.lastNameField});
        Binder.Binding lastNameBinding = this.binder.forField((HasValue)this.lastNameField).bind("lastName");
        this.binder.forField((HasValue)this.firstNameField).withValidator(this.hasTextValuesValidator(lastNameBinding), "First and last name are required").bind("firstName");
        this.binder.setBean((Object)this.item);
        Assert.assertTrue((boolean)this.binder.isValid());
        lastNameSignal.value((Object)"");
        Assert.assertTrue((boolean)this.firstNameField.isInvalid());
        Assert.assertEquals((Object)"First and last name are required", (Object)((ValidationResult)this.binder.validate().getValidationErrors().getFirst()).getErrorMessage());
    }

    @Test
    public void bindingValue_crossFieldValidation_withoutSignal() {
        this.item.setFirstName("Alice");
        this.item.setLastName("Smith");
        UI.getCurrent().add(new Component[]{this.firstNameField, this.lastNameField});
        Binder.Binding lastNameBinding = this.binder.forField((HasValue)this.lastNameField).bind("lastName");
        this.binder.forField((HasValue)this.firstNameField).withValidator(this.hasTextValuesValidator(lastNameBinding), "First and last name are required").bind("firstName");
        this.binder.setBean((Object)this.item);
        Assert.assertTrue((boolean)this.binder.isValid());
        this.lastNameField.setValue("");
        Assert.assertTrue((boolean)this.firstNameField.isInvalid());
        Assert.assertEquals((Object)"First and last name are required", (Object)((ValidationResult)this.binder.validate().getValidationErrors().getFirst()).getErrorMessage());
    }

    @Test
    public void bindingValue_crossFieldValidation_withMixedFields() {
        this.item.setFirstName("Alice");
        this.item.setLastName("Smith");
        this.item.setAge(30);
        this.item.setEmail("email");
        ValueSignal firstNameSignal = new ValueSignal((Object)"");
        ValueSignal lastNameSignal = new ValueSignal((Object)"");
        ValueSignal ageSignal = new ValueSignal((Object)"0");
        this.firstNameField.bindValue((WritableSignal)firstNameSignal);
        this.lastNameField.bindValue((WritableSignal)lastNameSignal);
        TestTextField ageField = new TestTextField();
        ageField.bindValue((WritableSignal)ageSignal);
        TestTextField emailField = new TestTextField();
        UI.getCurrent().add(new Component[]{this.firstNameField, this.lastNameField, emailField, ageField});
        this.binder.forField((HasValue)this.firstNameField).bind("firstName");
        Binder.Binding lastNameBinding = this.binder.forField((HasValue)this.lastNameField).bind("lastName");
        Binder.Binding emailBinding = this.binder.forField((HasValue)emailField).bind("email");
        String ageValidationError = "First name, last name and age are required";
        this.binder.forField((HasValue)ageField).withConverter((Converter)new StringToIntegerConverter("Value must be an integer")).withValidator((SerializablePredicate & Serializable)value -> value > 0 && !((String)lastNameBinding.value()).isEmpty() && !((String)firstNameSignal.value()).isEmpty() && !((String)emailBinding.value()).isEmpty(), ageValidationError).bind("age");
        this.binder.setBean((Object)this.item);
        Assert.assertTrue((boolean)this.binder.isValid());
        emailField.setValue("");
        Assert.assertTrue((boolean)ageField.isInvalid());
        Assert.assertEquals((Object)ageValidationError, (Object)ageField.getErrorMessage());
        emailField.setValue("email");
        Assert.assertFalse((boolean)ageField.isInvalid());
        this.firstNameField.setValue("");
        Assert.assertTrue((boolean)ageField.isInvalid());
        Assert.assertEquals((Object)ageValidationError, (Object)ageField.getErrorMessage());
        this.firstNameField.setValue("John");
        this.lastNameField.setValue("");
        Assert.assertTrue((boolean)ageField.isInvalid());
        Assert.assertEquals((Object)ageValidationError, (Object)ageField.getErrorMessage());
        this.lastNameField.setValue("Smith");
        ageField.setValue("0");
        Assert.assertTrue((boolean)ageField.isInvalid());
        Assert.assertEquals((Object)ageValidationError, (Object)ageField.getErrorMessage());
        ageField.setValue("10");
        Assert.assertFalse((boolean)ageField.isInvalid());
        Assert.assertEquals((long)0L, (long)this.binder.validate().getValidationErrors().size());
    }

    @Test
    public void crossFieldValidation_setBean_validationTriggeredOnFieldChange() {
        this.item.setFirstName("Alice");
        this.item.setLastName("Smith");
        UI.getCurrent().add(new Component[]{this.firstNameField, this.lastNameField});
        Binder.Binding lastNameBinding = this.binder.forField((HasValue)this.lastNameField).bind("lastName");
        this.binder.forField((HasValue)this.firstNameField).withValidator(this.hasTextValuesValidator(lastNameBinding), "First and last name are required").bind("firstName");
        Assert.assertEquals((Object)"", (Object)this.firstNameField.getValue());
        Assert.assertEquals((Object)"", (Object)this.lastNameField.getValue());
        this.binder.setBean((Object)this.item);
        Assert.assertEquals((Object)"Alice", (Object)this.firstNameField.getValue());
        Assert.assertEquals((Object)"Smith", (Object)this.lastNameField.getValue());
        Assert.assertTrue((boolean)this.binder.isValid());
        this.lastNameField.setValue("");
        Assert.assertTrue((boolean)this.firstNameField.isInvalid());
        Assert.assertEquals((Object)"First and last name are required", (Object)this.firstNameField.getErrorMessage());
        Assert.assertEquals((Object)"", (Object)this.item.getLastName());
    }

    @Test
    public void crossFieldValidation_readBean_validationTriggeredOnFieldChange() {
        this.item.setFirstName("Alice");
        this.item.setLastName("Smith");
        UI.getCurrent().add(new Component[]{this.firstNameField, this.lastNameField});
        Binder.Binding lastNameBinding = this.binder.forField((HasValue)this.lastNameField).bind("lastName");
        this.binder.forField((HasValue)this.firstNameField).withValidator(this.hasTextValuesValidator(lastNameBinding), "First and last name are required").bind("firstName");
        Assert.assertEquals((Object)"", (Object)this.firstNameField.getValue());
        Assert.assertEquals((Object)"", (Object)this.lastNameField.getValue());
        this.binder.readBean((Object)this.item);
        Assert.assertEquals((Object)"Alice", (Object)this.firstNameField.getValue());
        Assert.assertEquals((Object)"Smith", (Object)this.lastNameField.getValue());
        Assert.assertTrue((boolean)this.binder.isValid());
        this.lastNameField.setValue("");
        Assert.assertTrue((boolean)this.firstNameField.isInvalid());
        Assert.assertEquals((Object)"First and last name are required", (Object)this.firstNameField.getErrorMessage());
        Assert.assertEquals((Object)"Smith", (Object)this.item.getLastName());
    }

    @Test
    public void crossFieldValidation_readBean_withSignals() {
        this.item.setFirstName("Alice");
        this.item.setLastName("Smith");
        ValueSignal firstNameSignal = new ValueSignal((Object)"");
        ValueSignal lastNameSignal = new ValueSignal((Object)"");
        this.firstNameField.bindValue((WritableSignal)firstNameSignal);
        this.lastNameField.bindValue((WritableSignal)lastNameSignal);
        UI.getCurrent().add(new Component[]{this.firstNameField, this.lastNameField});
        Binder.Binding lastNameBinding = this.binder.forField((HasValue)this.lastNameField).bind("lastName");
        this.binder.forField((HasValue)this.firstNameField).withValidator(this.hasTextValuesValidator(lastNameBinding), "First and last name are required").bind("firstName");
        this.binder.readBean((Object)this.item);
        Assert.assertEquals((Object)"Alice", (Object)this.firstNameField.getValue());
        Assert.assertEquals((Object)"Smith", (Object)this.lastNameField.getValue());
        Assert.assertTrue((boolean)this.binder.isValid());
        lastNameSignal.value((Object)"");
        Assert.assertTrue((boolean)this.firstNameField.isInvalid());
        Assert.assertEquals((Object)"First and last name are required", (Object)this.firstNameField.getErrorMessage());
        Assert.assertEquals((Object)"Smith", (Object)this.item.getLastName());
    }

    @Test
    public void crossFieldValidation_switchFromSetBeanToReadBean() {
        Person item1 = new Person();
        item1.setFirstName("Alice");
        item1.setLastName("Smith");
        Person item2 = new Person();
        item2.setFirstName("Bob");
        item2.setLastName("Jones");
        UI.getCurrent().add(new Component[]{this.firstNameField, this.lastNameField});
        Binder.Binding lastNameBinding = this.binder.forField((HasValue)this.lastNameField).bind("lastName");
        this.binder.forField((HasValue)this.firstNameField).withValidator(this.hasTextValuesValidator(lastNameBinding), "First and last name are required").bind("firstName");
        this.binder.setBean((Object)item1);
        Assert.assertEquals((Object)"Alice", (Object)this.firstNameField.getValue());
        Assert.assertEquals((Object)"Smith", (Object)this.lastNameField.getValue());
        this.firstNameField.setValue("Charlie");
        Assert.assertEquals((Object)"Charlie", (Object)item1.getFirstName());
        this.binder.readBean((Object)item2);
        Assert.assertEquals((Object)"Bob", (Object)this.firstNameField.getValue());
        Assert.assertEquals((Object)"Jones", (Object)this.lastNameField.getValue());
        this.firstNameField.setValue("David");
        Assert.assertEquals((Object)"Bob", (Object)item2.getFirstName());
        this.lastNameField.setValue("");
        Assert.assertTrue((boolean)this.firstNameField.isInvalid());
    }

    @Test
    public void crossFieldValidation_record_readRecord() {
        record TestRecord(String firstName, String lastName) {
        }
        Binder binder = new Binder(TestRecord.class);
        TestRecord record = new TestRecord("Alice", "Smith");
        UI.getCurrent().add(new Component[]{this.firstNameField, this.lastNameField});
        Binder.Binding lastNameBinding = binder.forField((HasValue)this.lastNameField).bind("lastName");
        binder.forField((HasValue)this.firstNameField).withValidator(this.hasTextValuesValidator(lastNameBinding), "First and last name are required").bind("firstName");
        binder.readRecord((Object)record);
        Assert.assertEquals((Object)"Alice", (Object)this.firstNameField.getValue());
        Assert.assertEquals((Object)"Smith", (Object)this.lastNameField.getValue());
        Assert.assertTrue((boolean)binder.isValid());
        this.lastNameField.setValue("");
        Assert.assertTrue((boolean)this.firstNameField.isInvalid());
        Assert.assertEquals((Object)"First and last name are required", (Object)this.firstNameField.getErrorMessage());
    }

    @Test
    public void crossFieldValidation_record_readRecord_withSignals() {
        record TestRecord(String firstName, String lastName) {
        }
        Binder binder = new Binder(TestRecord.class);
        TestRecord record = new TestRecord("Alice", "Smith");
        ValueSignal firstNameSignal = new ValueSignal((Object)"");
        ValueSignal lastNameSignal = new ValueSignal((Object)"");
        this.firstNameField.bindValue((WritableSignal)firstNameSignal);
        this.lastNameField.bindValue((WritableSignal)lastNameSignal);
        UI.getCurrent().add(new Component[]{this.firstNameField, this.lastNameField});
        Binder.Binding lastNameBinding = binder.forField((HasValue)this.lastNameField).bind("lastName");
        binder.forField((HasValue)this.firstNameField).withValidator(this.hasTextValuesValidator(lastNameBinding), "First and last name are required").bind("firstName");
        binder.readRecord((Object)record);
        Assert.assertEquals((Object)"Alice", (Object)this.firstNameField.getValue());
        Assert.assertEquals((Object)"Smith", (Object)this.lastNameField.getValue());
        Assert.assertTrue((boolean)binder.isValid());
        lastNameSignal.value((Object)"");
        Assert.assertTrue((boolean)this.firstNameField.isInvalid());
        Assert.assertEquals((Object)"First and last name are required", (Object)this.firstNameField.getErrorMessage());
    }

    @Test
    public void crossFieldValidation_multipleBeanChanges() {
        Person item1 = new Person();
        item1.setFirstName("Alice");
        item1.setLastName("Smith");
        Person item2 = new Person();
        item2.setFirstName("Bob");
        item2.setLastName("");
        Person item3 = new Person();
        item3.setFirstName("Charlie");
        item3.setLastName("Brown");
        UI.getCurrent().add(new Component[]{this.firstNameField, this.lastNameField});
        Binder.Binding lastNameBinding = this.binder.forField((HasValue)this.lastNameField).bind("lastName");
        this.binder.forField((HasValue)this.firstNameField).withValidator(this.hasTextValuesValidator(lastNameBinding), "First and last name are required").bind("firstName");
        this.binder.setBean((Object)item1);
        Assert.assertTrue((boolean)this.binder.isValid());
        Assert.assertFalse((boolean)this.firstNameField.isInvalid());
        this.binder.setBean((Object)item2);
        Assert.assertEquals((Object)"Bob", (Object)this.firstNameField.getValue());
        Assert.assertEquals((Object)"", (Object)this.lastNameField.getValue());
        Assert.assertFalse((boolean)this.binder.isValid());
        this.binder.validate();
        Assert.assertTrue((boolean)this.firstNameField.isInvalid());
        this.binder.setBean((Object)item3);
        Assert.assertEquals((Object)"Charlie", (Object)this.firstNameField.getValue());
        Assert.assertEquals((Object)"Brown", (Object)this.lastNameField.getValue());
        Assert.assertTrue((boolean)this.binder.isValid());
    }

    @Test
    public void crossFieldValidation_validationStatePreservedOnBeanChange() {
        Person item1 = new Person();
        item1.setFirstName("Alice");
        item1.setLastName("Smith");
        Person item2 = new Person();
        item2.setFirstName("");
        item2.setLastName("");
        UI.getCurrent().add(new Component[]{this.firstNameField, this.lastNameField});
        Binder.Binding lastNameBinding = this.binder.forField((HasValue)this.lastNameField).bind("lastName");
        this.binder.forField((HasValue)this.firstNameField).withValidator(this.hasTextValuesValidator(lastNameBinding), "First and last name are required").bind("firstName");
        this.binder.setBean((Object)item1);
        this.lastNameField.setValue("");
        Assert.assertTrue((boolean)this.firstNameField.isInvalid());
        this.binder.setBean((Object)item2);
        Assert.assertEquals((Object)"", (Object)this.firstNameField.getValue());
        Assert.assertEquals((Object)"", (Object)this.lastNameField.getValue());
        this.binder.validate();
        Assert.assertTrue((boolean)this.firstNameField.isInvalid());
        Assert.assertEquals((Object)"First and last name are required", (Object)this.firstNameField.getErrorMessage());
    }

    @Test
    public void crossFieldValidation_onlyWorksWithAttachedFields() {
        this.item.setFirstName("Alice");
        this.item.setLastName("Smith");
        ValueSignal firstNameSignal = new ValueSignal((Object)"");
        ValueSignal lastNameSignal = new ValueSignal((Object)"");
        this.firstNameField.bindValue((WritableSignal)firstNameSignal);
        this.lastNameField.bindValue((WritableSignal)lastNameSignal);
        Binder.Binding lastNameBinding = this.binder.forField((HasValue)this.lastNameField).bind("lastName");
        this.binder.forField((HasValue)this.firstNameField).withValidator(this.hasTextValuesValidator(lastNameBinding), "First and last name are required").bind("firstName");
        this.binder.setBean((Object)this.item);
        Assert.assertTrue((boolean)this.binder.isValid());
        lastNameSignal.value((Object)"");
        Assert.assertFalse((boolean)this.firstNameField.isInvalid());
        this.lastNameField.setValue("");
        Assert.assertFalse((boolean)this.firstNameField.isInvalid());
        Assert.assertEquals((Object)"", (Object)this.firstNameField.getErrorMessage());
        this.lastNameField.setValue("Smith");
        this.binder.validate();
        Assert.assertFalse((boolean)this.firstNameField.isInvalid());
        Assert.assertTrue((boolean)this.binder.isValid());
        UI.getCurrent().add(new Component[]{this.firstNameField, this.lastNameField});
        lastNameSignal.value((Object)"");
        Assert.assertTrue((boolean)this.firstNameField.isInvalid());
        Assert.assertEquals((Object)"First and last name are required", (Object)this.firstNameField.getErrorMessage());
    }

    @Test
    public void unbind_removesSignalRegistration() {
        this.item.setFirstName("Alice");
        this.item.setLastName("Smith");
        ValueSignal firstNameSignal = new ValueSignal((Object)"");
        ValueSignal lastNameSignal = new ValueSignal((Object)"");
        this.firstNameField.bindValue((WritableSignal)firstNameSignal);
        this.lastNameField.bindValue((WritableSignal)lastNameSignal);
        UI.getCurrent().add(new Component[]{this.firstNameField, this.lastNameField});
        Binder.Binding firstNameBinding = this.binder.forField((HasValue)this.firstNameField).bind("firstName");
        this.binder.forField((HasValue)this.lastNameField).withValidator((SerializablePredicate & Serializable)value -> !value.isEmpty() && !((String)firstNameBinding.value()).isEmpty(), "Both names required").bind("lastName");
        this.binder.setBean((Object)this.item);
        firstNameSignal.value((Object)"");
        Assert.assertTrue((boolean)this.lastNameField.isInvalid());
        firstNameSignal.value((Object)"Alice");
        this.binder.validate();
        Assert.assertFalse((boolean)this.lastNameField.isInvalid());
        firstNameBinding.unbind();
        firstNameSignal.value((Object)"");
        Assert.assertFalse((boolean)this.lastNameField.isInvalid());
    }

    @Test
    public void beanLevelValidator_throwWhenSignalIsUsed() {
        this.item.setFirstName("Alice");
        ValueSignal firstNameSignal = new ValueSignal((Object)"");
        UI.getCurrent().add(new Component[]{this.firstNameField});
        this.binder.forField((HasValue)this.firstNameField).bind("firstName");
        this.binder.setBean((Object)this.item);
        this.binder.withValidator((SerializablePredicate & Serializable)bean -> {
            firstNameSignal.peek();
            return true;
        }, "Bean level validation failed");
        Assert.assertTrue((boolean)this.binder.isValid());
        this.binder.withValidator((SerializablePredicate & Serializable)bean -> {
            firstNameSignal.value();
            return true;
        }, "Bean level validation with a signal failed");
        Assert.assertThrows(Binder.InvalidSignalUsageError.class, () -> this.binder.validate());
        Assert.assertThrows(Binder.InvalidSignalUsageError.class, () -> this.binder.isValid());
    }

    @Test
    public void getValidationStatus_signalInitialized() {
        Signal statusSignal = this.binder.getValidationStatus();
        Assert.assertNotNull((String)"getValidationStatus() should setup validation status signal", (Object)statusSignal);
        Assert.assertNotNull((String)"validation status signal value should not be null initially", (Object)statusSignal.value());
    }

    @Test
    public void getValidationStatus_signalIsReadOnly() {
        Signal statusSignal = this.binder.getValidationStatus();
        Assert.assertThrows(ClassCastException.class, () -> ((WritableSignal)statusSignal).value(null));
    }

    @Test
    public void getValidationStatus_statusChangeUpdatesSignal() {
        this.item.setFirstName("Alice");
        this.item.setLastName("Smith");
        UI.getCurrent().add(new Component[]{this.firstNameField, this.lastNameField});
        this.binder.forField((HasValue)this.firstNameField).withValidator((SerializablePredicate & Serializable)value -> !value.isEmpty(), "").bind("firstName");
        this.binder.forField((HasValue)this.lastNameField).withValidator((SerializablePredicate & Serializable)value -> !value.isEmpty(), "").bind("lastName");
        this.binder.setBean((Object)this.item);
        Assert.assertTrue((boolean)((BinderValidationStatus)this.binder.getValidationStatus().value()).isOk());
        this.firstNameField.setValue("");
        Assert.assertFalse((boolean)((BinderValidationStatus)this.binder.getValidationStatus().value()).isOk());
        this.firstNameField.setValue("foo");
        Assert.assertTrue((boolean)((BinderValidationStatus)this.binder.getValidationStatus().value()).isOk());
        this.lastNameField.setValue("");
        Assert.assertFalse((boolean)((BinderValidationStatus)this.binder.getValidationStatus().value()).isOk());
        this.firstNameField.setValue("");
        Assert.assertFalse((boolean)((BinderValidationStatus)this.binder.getValidationStatus().value()).isOk());
        this.firstNameField.setValue("foo");
        Assert.assertFalse((boolean)((BinderValidationStatus)this.binder.getValidationStatus().value()).isOk());
    }

    @Test
    public void getValidationStatus_fieldChanged_validationStatusSignalUpdated() {
        this.item.setFirstName("Alice");
        this.item.setLastName("Smith");
        UI.getCurrent().add(new Component[]{this.firstNameField, this.lastNameField});
        Binder.Binding lastNameBinding = this.binder.forField((HasValue)this.lastNameField).bind("lastName");
        Binder.Binding firstNameBinding = this.binder.forField((HasValue)this.firstNameField).withValidator(this.hasTextValuesValidator(lastNameBinding), "First and last name are required").bind("firstName");
        this.binder.setBean((Object)this.item);
        Assert.assertTrue((boolean)((BinderValidationStatus)this.binder.getValidationStatus().value()).getFieldValidationStatuses().stream().noneMatch(BindingValidationStatus::isError));
        Assert.assertTrue((boolean)((BinderValidationStatus)this.binder.getValidationStatus().value()).isOk());
        this.lastNameField.setValue("");
        Assert.assertFalse((boolean)((BinderValidationStatus)this.binder.getValidationStatus().value()).isOk());
        List<BindingValidationStatus> firstNameValidationStatuses = ((BinderValidationStatus)this.binder.getValidationStatus().value()).getFieldValidationStatuses().stream().filter(status -> status.getBinding() == firstNameBinding).toList();
        List<BindingValidationStatus> otherValidationStatuses = ((BinderValidationStatus)this.binder.getValidationStatus().value()).getFieldValidationStatuses().stream().filter(status -> status.getBinding() != firstNameBinding).toList();
        Assert.assertEquals((String)"Expected one BindingValidationStatus for first name field", (long)1L, (long)firstNameValidationStatuses.size());
        Assert.assertEquals((String)"Expected one BindingValidationStatus for last name field", (long)1L, (long)otherValidationStatuses.size());
        Assert.assertFalse((String)"Expected last name field to NOT have an error", (boolean)otherValidationStatuses.get(0).isError());
        Assert.assertTrue((String)"Expected first name field to have an error", (boolean)firstNameValidationStatuses.get(0).isError());
        this.lastNameField.setValue("Smith");
        Assert.assertTrue((boolean)((BinderValidationStatus)this.binder.getValidationStatus().value()).isOk());
    }

    @Test
    public void bindingValue_converterNotTracking() {
        this.item.setLastName("Smith");
        this.item.setAge(30);
        TestTextField ageField = new TestTextField();
        UI.getCurrent().add(new Component[]{this.lastNameField, ageField});
        final Binder.Binding lastNameBinding = this.binder.forField((HasValue)this.lastNameField).bind("lastName");
        final AtomicInteger converterCalls = new AtomicInteger(0);
        String ageValidationError = "Last name and age are required";
        this.binder.forField((HasValue)ageField).withConverter((Converter)new StringToIntegerConverter("Value must be an integer"){

            public Result<Integer> convertToModel(String value, ValueContext context) {
                lastNameBinding.value();
                converterCalls.incrementAndGet();
                return super.convertToModel(value, context);
            }
        }).withValidator((SerializablePredicate & Serializable)value -> value > 0 && !((String)this.lastNameField.getValue()).isEmpty(), ageValidationError).bind("age");
        this.binder.setBean((Object)this.item);
        Assert.assertTrue((boolean)this.binder.isValid());
        this.lastNameField.setValue("");
        Assert.assertFalse((boolean)ageField.isInvalid());
        Assert.assertEquals((Object)"", (Object)ageField.getErrorMessage());
        Assert.assertTrue((String)"Converter should be called at least once", (converterCalls.get() > 0 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)this.binder.isValid());
    }

    @Test
    public void getValidationStatus_setBean_statusChangeRunEffects() {
        this.testStatusChangeRunEffects(() -> this.binder.setBean((Object)this.item));
    }

    @Test
    public void getValidationStatus_readBean_statusChangeRunEffects() {
        this.testStatusChangeRunEffects(() -> this.binder.readBean((Object)this.item));
    }

    private void testStatusChangeRunEffects(Runnable binderSetup) {
        this.item.setFirstName("Alice");
        this.item.setLastName("Smith");
        UI.getCurrent().add(new Component[]{this.firstNameField, this.lastNameField});
        this.binder.forField((HasValue)this.firstNameField).withValidator((SerializablePredicate & Serializable)value -> !value.isEmpty(), "").bind("firstName");
        this.binder.forField((HasValue)this.lastNameField).withValidator((SerializablePredicate & Serializable)value -> !value.isEmpty(), "").bind("lastName");
        binderSetup.run();
        AtomicInteger effectCalled = new AtomicInteger(0);
        AtomicBoolean prevStatus = new AtomicBoolean(true);
        ComponentEffect.effect((Component)this.firstNameField, (SerializableRunnable & Serializable)() -> {
            prevStatus.set(((BinderValidationStatus)this.binder.getValidationStatus().value()).isOk());
            effectCalled.incrementAndGet();
        });
        this.firstNameField.setValue("");
        Assert.assertFalse((boolean)prevStatus.get());
        Assert.assertEquals((long)2L, (long)effectCalled.get());
        this.firstNameField.setValue("foo");
        Assert.assertEquals((long)3L, (long)effectCalled.get());
        Assert.assertTrue((boolean)prevStatus.get());
        this.lastNameField.setValue("");
        Assert.assertEquals((long)4L, (long)effectCalled.get());
        Assert.assertFalse((boolean)prevStatus.get());
        this.firstNameField.setValue("");
        Assert.assertFalse((boolean)prevStatus.get());
        Assert.assertEquals((long)5L, (long)effectCalled.get());
        this.firstNameField.setValue("foo");
        Assert.assertEquals((long)6L, (long)effectCalled.get());
        Assert.assertFalse((String)"Binder status change signal should be invalid when other field is still invalid.", (boolean)prevStatus.get());
    }

    @Test
    public void getValidationStatus_setBean_initialStatus() {
        this.testInitialStatusChangeRunEffects(item -> this.binder.setBean(item));
    }

    @Test
    public void getValidationStatus_readBean_initialStatus() {
        this.testInitialStatusChangeRunEffects(item -> this.binder.readBean(item));
    }

    private void testInitialStatusChangeRunEffects(Consumer<Person> binderSetup) {
        this.item.setFirstName("");
        UI.getCurrent().add(new Component[]{this.firstNameField});
        this.binder.forField((HasValue)this.firstNameField).withValidator((SerializablePredicate & Serializable)value -> !value.isEmpty(), "").bind("firstName");
        binderSetup.accept(this.item);
        AtomicBoolean prevStatus = new AtomicBoolean(true);
        ComponentEffect.effect((Component)this.firstNameField, (SerializableRunnable & Serializable)() -> prevStatus.set(((BinderValidationStatus)this.binder.getValidationStatus().value()).isOk()));
        Assert.assertFalse((boolean)prevStatus.get());
        this.firstNameField.setValue("foo");
        Assert.assertTrue((boolean)prevStatus.get());
        Person person = new Person();
        person.setFirstName("");
        binderSetup.accept(person);
        Assert.assertFalse((boolean)prevStatus.get());
    }
}

