/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider.hierarchy;

import com.vaadin.flow.data.provider.DataProviderTestBase;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.provider.QuerySortOrder;
import com.vaadin.flow.data.provider.StrBean;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalConfigurableFilterDataProvider;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalDataProvider;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalQuery;
import com.vaadin.flow.data.provider.hierarchy.TreeData;
import com.vaadin.flow.data.provider.hierarchy.TreeDataProvider;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;

public class TreeDataProviderTest
extends DataProviderTestBase<TreeDataProvider<StrBean>> {
    private TreeData<StrBean> data;
    private List<StrBean> flattenedData;
    private List<StrBean> rootData;

    @Override
    public void setUp() {
        List<StrBean> randomBeans = StrBean.generateRandomBeans(20);
        this.flattenedData = new ArrayList<StrBean>();
        this.rootData = new ArrayList<StrBean>();
        this.data = new TreeData();
        this.data.addItems(null, randomBeans.subList(0, 5));
        this.data.addItems((Object)randomBeans.get(0), randomBeans.subList(5, 10));
        this.data.addItems((Object)randomBeans.get(5), randomBeans.subList(10, 15));
        this.data.addItems(null, randomBeans.subList(15, 20));
        this.flattenedData.add(randomBeans.get(0));
        this.flattenedData.add(randomBeans.get(5));
        this.flattenedData.addAll(randomBeans.subList(10, 15));
        this.flattenedData.addAll(randomBeans.subList(6, 10));
        this.flattenedData.addAll(randomBeans.subList(1, 5));
        this.flattenedData.addAll(randomBeans.subList(15, 20));
        this.rootData.addAll(randomBeans.subList(0, 5));
        this.rootData.addAll(randomBeans.subList(15, 20));
        super.setUp();
    }

    @Test(expected=IllegalArgumentException.class)
    public void treeData_add_item_parent_not_in_hierarchy_throws() {
        new TreeData().addItem((Object)new StrBean("", 0, 0), (Object)new StrBean("", 0, 0));
    }

    @Test(expected=NullPointerException.class)
    public void treeData_add_null_item_throws() {
        new TreeData().addItem(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void treeData_add_item_already_in_hierarchy_throws() {
        StrBean bean = new StrBean("", 0, 0);
        new TreeData().addItem(null, (Object)bean).addItem(null, (Object)bean);
    }

    @Test
    public void treeData_remove_root_item() {
        this.data.removeItem(null);
        Assert.assertTrue((boolean)this.data.getChildren(null).isEmpty());
    }

    @Test
    public void treeData_clear() {
        this.data.clear();
        Assert.assertTrue((boolean)this.data.getChildren(null).isEmpty());
    }

    @Test
    public void treeData_re_add_removed_item() {
        StrBean item = this.rootData.get(0);
        this.data.removeItem((Object)item).addItem(null, (Object)item);
        Assert.assertTrue((boolean)this.data.getChildren(null).contains(item));
    }

    @Test
    public void treeData_get_parent() {
        StrBean root = this.rootData.get(0);
        StrBean firstChild = (StrBean)this.data.getChildren((Object)root).get(0);
        Assert.assertNull((Object)this.data.getParent((Object)root));
        Assert.assertEquals((Object)root, (Object)this.data.getParent((Object)firstChild));
    }

    @Test
    public void treeData_set_parent() {
        StrBean item1 = this.rootData.get(0);
        StrBean item2 = this.rootData.get(1);
        Assert.assertEquals((long)0L, (long)this.data.getChildren((Object)item2).size());
        Assert.assertEquals((long)10L, (long)this.data.getRootItems().size());
        this.data.setParent((Object)item1, (Object)item2);
        Assert.assertEquals((long)1L, (long)this.data.getChildren((Object)item2).size());
        Assert.assertEquals((long)9L, (long)this.data.getRootItems().size());
        Assert.assertEquals((Object)item1, this.data.getChildren((Object)item2).get(0));
        this.data.setParent((Object)item1, null);
        Assert.assertEquals((long)0L, (long)this.data.getChildren((Object)item2).size());
        Assert.assertEquals((long)10L, (long)this.data.getRootItems().size());
    }

    @Test
    public void treeData_move_after_sibling() {
        StrBean root0 = this.rootData.get(0);
        StrBean root9 = this.rootData.get(9);
        Assert.assertEquals((Object)root0, this.data.getRootItems().get(0));
        Assert.assertEquals((Object)root9, this.data.getRootItems().get(9));
        this.data.moveAfterSibling((Object)root0, (Object)root9);
        Assert.assertEquals((Object)root0, this.data.getRootItems().get(9));
        Assert.assertEquals((Object)root9, this.data.getRootItems().get(8));
        this.data.moveAfterSibling((Object)root0, null);
        Assert.assertEquals((Object)root0, this.data.getRootItems().get(0));
        Assert.assertEquals((Object)root9, this.data.getRootItems().get(9));
        StrBean child0 = (StrBean)this.data.getChildren((Object)root0).get(0);
        StrBean child2 = (StrBean)this.data.getChildren((Object)root0).get(2);
        this.data.moveAfterSibling((Object)child0, (Object)child2);
        Assert.assertEquals((long)2L, (long)this.data.getChildren((Object)root0).indexOf(child0));
        Assert.assertEquals((long)1L, (long)this.data.getChildren((Object)root0).indexOf(child2));
        this.data.moveAfterSibling((Object)child0, null);
        Assert.assertEquals((long)0L, (long)this.data.getChildren((Object)root0).indexOf(child0));
        Assert.assertEquals((long)2L, (long)this.data.getChildren((Object)root0).indexOf(child2));
    }

    @Test(expected=IllegalArgumentException.class)
    public void treeData_move_after_sibling_different_parents() {
        StrBean root0 = this.rootData.get(0);
        StrBean wrongSibling = (StrBean)this.data.getChildren((Object)root0).get(0);
        this.data.moveAfterSibling((Object)root0, (Object)wrongSibling);
    }

    @Test
    public void treeData_setParent_direct_cycle_throws() {
        StrBean parent = this.rootData.get(0);
        StrBean child = (StrBean)this.data.getChildren((Object)parent).get(0);
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> this.data.setParent((Object)parent, (Object)child));
        Assert.assertTrue((boolean)exception.getMessage().contains("would create a cycle"));
        Assert.assertTrue((boolean)exception.getMessage().contains(parent.toString()));
        Assert.assertTrue((boolean)exception.getMessage().contains(child.toString()));
    }

    @Test
    public void treeData_setParent_multi_level_cycle_throws() {
        StrBean itemA = this.rootData.get(0);
        StrBean itemB = (StrBean)this.data.getChildren((Object)itemA).get(0);
        StrBean itemC = (StrBean)this.data.getChildren((Object)itemB).get(0);
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> this.data.setParent((Object)itemA, (Object)itemC));
        Assert.assertTrue((boolean)exception.getMessage().contains("would create a cycle"));
        Assert.assertTrue((boolean)exception.getMessage().contains(itemA.toString()));
        Assert.assertTrue((boolean)exception.getMessage().contains(itemC.toString()));
    }

    @Test
    public void treeData_root_items() {
        TreeData data = new TreeData();
        TreeData dataVarargs = new TreeData();
        TreeData dataCollection = new TreeData();
        TreeData dataStream = new TreeData();
        data.addItems(null, (Object[])new String[]{"a", "b", "c"});
        dataVarargs.addRootItems((Object[])new String[]{"a", "b", "c"});
        dataCollection.addRootItems(Arrays.asList("a", "b", "c"));
        dataStream.addRootItems(Arrays.asList("a", "b", "c").stream());
        Assert.assertEquals((Object)data.getRootItems(), (Object)dataVarargs.getRootItems());
        Assert.assertEquals((Object)data.getRootItems(), (Object)dataCollection.getRootItems());
        Assert.assertEquals((Object)data.getRootItems(), (Object)dataStream.getRootItems());
    }

    @Test
    public void populate_treeData_with_child_item_provider() {
        TreeData stringData = new TreeData();
        List<String> rootItems = Arrays.asList("a", "b", "c");
        stringData.addItems(rootItems, (ValueProvider & Serializable)item -> {
            if (item.length() >= 3 || item.startsWith("c")) {
                return Arrays.asList(new String[0]);
            }
            return Arrays.asList(item + "/a", item + "/b", item + "/c");
        });
        Assert.assertEquals((Object)stringData.getChildren((Object)"a"), Arrays.asList("a/a", "a/b", "a/c"));
        Assert.assertEquals((Object)stringData.getChildren((Object)"b"), Arrays.asList("b/a", "b/b", "b/c"));
        Assert.assertEquals((Object)stringData.getChildren((Object)"c"), Arrays.asList(new Object[0]));
        Assert.assertEquals((Object)stringData.getChildren((Object)"a/b"), Arrays.asList(new Object[0]));
    }

    @Test
    public void populate_treeData_with_stream_child_item_provider() {
        TreeData stringData = new TreeData();
        Stream<String> rootItems = Stream.of("a", "b", "c");
        stringData.addItems(rootItems, (ValueProvider & Serializable)item -> {
            if (item.length() >= 3 || item.startsWith("c")) {
                return Stream.empty();
            }
            return Stream.of(item + "/a", item + "/b", item + "/c");
        });
        Assert.assertEquals((Object)stringData.getChildren((Object)"a"), Arrays.asList("a/a", "a/b", "a/c"));
        Assert.assertEquals((Object)stringData.getChildren((Object)"b"), Arrays.asList("b/a", "b/b", "b/c"));
        Assert.assertEquals((Object)stringData.getChildren((Object)"c"), Arrays.asList(new Object[0]));
        Assert.assertEquals((Object)stringData.getChildren((Object)"a/b"), Arrays.asList(new Object[0]));
    }

    @Test
    public void filter_is_applied_to_children_provider_filter() {
        SerializablePredicate & Serializable dataProviderFilter = (SerializablePredicate & Serializable)item -> item.contains("Sub");
        HierarchicalQuery query = new HierarchicalQuery(null, null);
        this.filter_is_applied_to_children((SerializablePredicate<String>)dataProviderFilter, (HierarchicalQuery<String, SerializablePredicate<String>>)query);
    }

    @Test
    public void filter_is_applied_to_children_query_filter() {
        SerializablePredicate<String> dataProviderFilter = null;
        HierarchicalQuery query = new HierarchicalQuery((SerializablePredicate & Serializable)item -> item.contains("Sub"), null);
        this.filter_is_applied_to_children(dataProviderFilter, (HierarchicalQuery<String, SerializablePredicate<String>>)query);
    }

    @Test
    public void filter_is_applied_to_children_both_filters() {
        SerializablePredicate & Serializable dataProviderFilter = (SerializablePredicate & Serializable)item -> item.contains("Sub");
        HierarchicalQuery query = new HierarchicalQuery((Object)dataProviderFilter, null);
        this.filter_is_applied_to_children((SerializablePredicate<String>)dataProviderFilter, (HierarchicalQuery<String, SerializablePredicate<String>>)query);
    }

    private void filter_is_applied_to_children(SerializablePredicate<String> dataProviderFilter, HierarchicalQuery<String, SerializablePredicate<String>> query) {
        TreeData stringData = new TreeData();
        String root = "Main";
        List<String> children = Arrays.asList("Sub1", "Sub2");
        stringData.addRootItems((Object[])new String[]{"Main"});
        stringData.addItems((Object)"Main", children);
        TreeDataProvider provider = new TreeDataProvider(stringData);
        provider.setFilter(dataProviderFilter);
        Assert.assertEquals((long)1L, (long)provider.getChildCount(query));
        Assert.assertTrue((boolean)provider.fetchChildren(query).allMatch("Main"::equals));
    }

    @Test
    public void setFilter() {
        ((TreeDataProvider)this.getDataProvider()).setFilter((SerializablePredicate & Serializable)item -> item.getValue().equals("Xyz") || item.getValue().equals("Baz"));
        Assert.assertEquals((long)10L, (long)this.sizeWithUnfilteredQuery());
        ((TreeDataProvider)this.getDataProvider()).setFilter((SerializablePredicate & Serializable)item -> !item.getValue().equals("Foo") && !item.getValue().equals("Xyz"));
        Assert.assertEquals((String)"Previous filter should be replaced when setting a new one", (long)14L, (long)this.sizeWithUnfilteredQuery());
        ((TreeDataProvider)this.getDataProvider()).setFilter(null);
        Assert.assertEquals((String)"Setting filter to null should remove all filters", (long)20L, (long)this.sizeWithUnfilteredQuery());
    }

    @Test
    public void addFilter() {
        ((TreeDataProvider)this.getDataProvider()).addFilter((SerializablePredicate & Serializable)item -> item.getId() <= 10);
        ((TreeDataProvider)this.getDataProvider()).addFilter((SerializablePredicate & Serializable)item -> item.getId() >= 5);
        Assert.assertEquals((long)8L, (long)this.sizeWithUnfilteredQuery());
    }

    @Test
    public void rootItem_getParent_returnsNull() {
        StrBean rootItem = this.rootData.get(0);
        Assert.assertNull((Object)((TreeDataProvider)this.getDataProvider()).getParent((Object)rootItem));
    }

    @Test
    public void childItem_getParent_returnsParent() {
        StrBean rootItem = this.rootData.get(0);
        StrBean childItem = (StrBean)this.data.getChildren((Object)rootItem).get(0);
        Assert.assertEquals((Object)rootItem, (Object)this.data.getParent((Object)childItem));
    }

    @Test
    public void notPresentItem_getParent_returnsNull() {
        StrBean itemNotPresentInProvider = new StrBean("Not present", -1, 0);
        Assert.assertNull((Object)((TreeDataProvider)this.getDataProvider()).getParent((Object)itemNotPresentInProvider));
    }

    @Test
    public void flattenedFormat_filterMatchesNestedDescendant_nothingExpanded_showsOnlyAncestorRoot() {
        TreeData treeData = new TreeData();
        treeData.addRootItems((Object[])new String[]{"Item 0", "Item 1"});
        treeData.addItem((Object)"Item 0", (Object)"Item 0-0");
        treeData.addItem((Object)"Item 0-0", (Object)"Item 0-0-0");
        TreeDataProvider treeDataProvider = new TreeDataProvider(treeData, HierarchicalDataProvider.HierarchyFormat.FLATTENED);
        treeDataProvider.setFilter((SerializablePredicate & Serializable)folder -> folder.equals("Item 0-0-0"));
        Assert.assertEquals(List.of("Item 0"), treeDataProvider.fetchChildren(new HierarchicalQuery(null, Set.of(), null)).toList());
    }

    @Test
    public void flattenedFormat_filterMatchesNestedDescendant_allAncestorsExpanded_showsFullPathToMatch() {
        TreeData treeData = new TreeData();
        treeData.addRootItems((Object[])new String[]{"Item 0", "Item 1"});
        treeData.addItem((Object)"Item 0", (Object)"Item 0-0");
        treeData.addItem((Object)"Item 0-0", (Object)"Item 0-0-0");
        TreeDataProvider treeDataProvider = new TreeDataProvider(treeData, HierarchicalDataProvider.HierarchyFormat.FLATTENED);
        treeDataProvider.setFilter((SerializablePredicate & Serializable)folder -> folder.equals("Item 0-0-0"));
        Assert.assertEquals(List.of("Item 0", "Item 0-0", "Item 0-0-0"), treeDataProvider.fetchChildren(new HierarchicalQuery(null, Set.of("Item 0", "Item 0-0"), null)).toList());
    }

    @Override
    public void filteringListDataProvider_convertFilter() {
        HierarchicalDataProvider strFilterDataProvider = ((TreeDataProvider)this.getDataProvider()).withConvertedFilter((SerializableFunction & Serializable)text -> (SerializablePredicate & Serializable)strBean -> strBean.getValue().contains((CharSequence)text));
        Assert.assertEquals((String)"Only one item should match 'Xyz'", (long)1L, (long)strFilterDataProvider.size((Query)new HierarchicalQuery((Object)"Xyz", null)));
        Assert.assertEquals((String)"No item should match 'Zyx'", (long)0L, (long)strFilterDataProvider.size((Query)new HierarchicalQuery((Object)"Zyx", null)));
        Assert.assertEquals((String)"Unexpected number of matches for 'Foo'", (long)4L, (long)strFilterDataProvider.size((Query)new HierarchicalQuery((Object)"Foo", null)));
        Assert.assertEquals((String)"No items should've been filtered out", (long)this.rootData.size(), (long)strFilterDataProvider.size((Query)new HierarchicalQuery(null, null)));
    }

    @Override
    public void filteringListDataProvider_configurableFilter() {
        HierarchicalConfigurableFilterDataProvider configurableFilterDataProvider = ((TreeDataProvider)this.getDataProvider()).withConfigurableFilter();
        configurableFilterDataProvider.setFilter((SerializablePredicate & Serializable)bean -> bean.getValue().contains("Xyz"));
        Assert.assertEquals((String)"Only one item should match 'Xyz'", (long)1L, (long)configurableFilterDataProvider.size((Query)new HierarchicalQuery(null, null)));
        configurableFilterDataProvider.setFilter((SerializablePredicate & Serializable)bean -> bean.getValue().contains("Zyx"));
        Assert.assertEquals((String)"No item should match 'Zyx'", (long)0L, (long)configurableFilterDataProvider.size((Query)new HierarchicalQuery(null, null)));
        configurableFilterDataProvider.setFilter((SerializablePredicate & Serializable)bean -> bean.getValue().contains("Foo"));
        Assert.assertEquals((String)"Unexpected number of matches for 'Foo'", (long)4L, (long)configurableFilterDataProvider.size((Query)new HierarchicalQuery(null, null)));
        configurableFilterDataProvider.setFilter((SerializablePredicate & Serializable)bean -> bean.getValue() == null);
        Assert.assertEquals((String)"No items should've been filtered out", (long)0L, (long)configurableFilterDataProvider.size((Query)new HierarchicalQuery(null, null)));
    }

    @Override
    public void filteringListDataProvider_defaultFilterType() {
        Assert.assertEquals((String)"Only one item should match 'Xyz'", (long)1L, (long)((TreeDataProvider)this.getDataProvider()).size((Query)new HierarchicalQuery((SerializablePredicate & Serializable)strBean -> strBean.getValue().contains("Xyz"), null)));
        Assert.assertEquals((String)"No item should match 'Zyx'", (long)0L, (long)((TreeDataProvider)this.dataProvider).size((Query)new HierarchicalQuery((SerializablePredicate & Serializable)strBean -> strBean.getValue().contains("Zyx"), null)));
        Assert.assertEquals((String)"Unexpected number of matches for 'Foo'", (long)4L, (long)((TreeDataProvider)this.getDataProvider()).size((Query)new HierarchicalQuery((Object)this.fooFilter, null)));
    }

    @Override
    public void testDefaultSortWithSpecifiedPostSort() {
        Comparator<StrBean> comp = Comparator.comparing(StrBean::getValue).thenComparing(Comparator.comparing(StrBean::getId).reversed());
        this.setSortOrder(QuerySortOrder.asc((String)"value").thenDesc("id").build(), comp);
        List list = ((TreeDataProvider)this.getDataProvider()).fetch(this.createQuery(QuerySortOrder.asc((String)"randomNumber").build(), Comparator.comparing(StrBean::getRandomNumber), null, null)).collect(Collectors.toList());
        Assert.assertEquals((String)"Sorted data and original data sizes don't match", (long)((TreeDataProvider)this.getDataProvider()).fetch((Query)new HierarchicalQuery(null, null)).count(), (long)list.size());
        for (int i = 1; i < list.size(); ++i) {
            StrBean prev = (StrBean)list.get(i - 1);
            StrBean cur = (StrBean)list.get(i);
            Assert.assertTrue((String)("Failure: " + prev.getRandomNumber() + " > " + cur.getRandomNumber()), (prev.getRandomNumber() <= cur.getRandomNumber() ? 1 : 0) != 0);
            if (prev.getRandomNumber() != cur.getRandomNumber()) continue;
            Assert.assertTrue((prev.getValue().compareTo(cur.getValue()) <= 0 ? 1 : 0) != 0);
            if (!prev.getValue().equals(cur.getValue())) continue;
            Assert.assertTrue((prev.getId() > cur.getId() ? 1 : 0) != 0);
        }
    }

    @Override
    public void testDefaultSortWithFunction() {
        this.setSortOrder(QuerySortOrder.asc((String)"value").build(), Comparator.comparing(StrBean::getValue));
        List list = ((TreeDataProvider)this.getDataProvider()).fetch((Query)new HierarchicalQuery(null, null)).collect(Collectors.toList());
        Assert.assertEquals((String)"Sorted data and original data sizes don't match", (long)this.rootData.size(), (long)list.size());
        for (int i = 1; i < list.size(); ++i) {
            StrBean prev = (StrBean)list.get(i - 1);
            StrBean cur = (StrBean)list.get(i);
            Assert.assertTrue((prev.getValue().compareTo(cur.getValue()) <= 0 ? 1 : 0) != 0);
        }
    }

    @Override
    public void testListContainsAllData() {
        this.assertHierarchyCorrect();
    }

    @Override
    public void testSortByComparatorListsDiffer() {
        Comparator<StrBean> comp = Comparator.comparing(StrBean::getValue).thenComparing(StrBean::getRandomNumber).thenComparing(StrBean::getId);
        List list = ((TreeDataProvider)this.getDataProvider()).fetch(this.createQuery(QuerySortOrder.asc((String)"value").thenAsc("randomNumber").thenAsc("id").build(), comp, null, null)).collect(Collectors.toList());
        Assert.assertNotEquals((String)"First value should not match", (Object)this.rootData.get(0), list.get(0));
        Assert.assertEquals((String)"Sorted data and original data sizes don't match", (long)this.rootData.size(), (long)list.size());
        this.rootData.sort(comp);
        for (int i = 0; i < this.rootData.size(); ++i) {
            Assert.assertEquals((String)"Sorting result differed", (Object)this.rootData.get(i), list.get(i));
        }
    }

    @Override
    protected TreeDataProvider<StrBean> createDataProvider() {
        return new TreeDataProvider(this.data);
    }

    @Override
    protected void setSortOrder(List<QuerySortOrder> sortOrder, Comparator<StrBean> comp) {
        ((TreeDataProvider)this.getDataProvider()).setSortComparator(comp::compare);
    }

    @Override
    protected long sizeWithUnfilteredQuery() {
        return this.getFlattenedDataFromProvider(new ArrayList<StrBean>(), null).size();
    }

    private void assertHierarchyCorrect() {
        Assert.assertEquals(this.flattenedData, this.getFlattenedData(new ArrayList<StrBean>(), null));
        Assert.assertEquals(this.flattenedData, this.getFlattenedDataFromProvider(new ArrayList<StrBean>(), null));
    }

    private List<StrBean> getFlattenedData(List<StrBean> flattened, StrBean item) {
        if (item != null) {
            flattened.add(item);
        }
        this.data.getChildren((Object)item).forEach(child -> this.getFlattenedData(flattened, (StrBean)child));
        return flattened;
    }

    private List<StrBean> getFlattenedDataFromProvider(List<StrBean> flattened, StrBean item) {
        if (item != null) {
            flattened.add(item);
        }
        ((TreeDataProvider)this.getDataProvider()).fetchChildren(new HierarchicalQuery(null, (Object)item)).forEach(child -> this.getFlattenedDataFromProvider(flattened, (StrBean)child));
        return flattened;
    }

    private HierarchicalQuery<StrBean, SerializablePredicate<StrBean>> createQuery(List<QuerySortOrder> sortOrder, Comparator<StrBean> comp, SerializablePredicate<StrBean> filter, StrBean parent) {
        return new HierarchicalQuery(0, Integer.MAX_VALUE, sortOrder, comp, filter, (Object)parent);
    }
}

