/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.data.provider.AbstractDataView;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.HasDataView;
import com.vaadin.flow.data.provider.InMemoryDataProvider;
import com.vaadin.flow.dom.SignalsUnitTest;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.signals.BindingActiveException;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.local.ListSignal;
import com.vaadin.flow.signals.local.ValueSignal;
import com.vaadin.flow.signals.shared.SharedListSignal;
import com.vaadin.flow.signals.shared.SharedValueSignal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HasDataViewBindItemsTest
extends SignalsUnitTest {
    @Test
    public void bindItems_listSignal_insertsItems() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ListSignal itemsSignal = new ListSignal();
        itemsSignal.insertLast((Object)"Item 1");
        itemsSignal.insertLast((Object)"Item 2");
        itemsSignal.insertLast((Object)"Item 3");
        component.bindItems((Signal)itemsSignal);
        TestDataView dataView = component.getGenericDataView();
        Assertions.assertEquals((int)3, (int)dataView.getItemCount());
        Assertions.assertEquals((Object)"Item 1", (Object)dataView.getItem(0));
        Assertions.assertEquals((Object)"Item 2", (Object)dataView.getItem(1));
        Assertions.assertEquals((Object)"Item 3", (Object)dataView.getItem(2));
    }

    @Test
    public void bindItems_outerSignalChange_triggersRefreshAll() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ListSignal itemsSignal = new ListSignal();
        itemsSignal.insertLast((Object)"Item 1");
        itemsSignal.insertLast((Object)"Item 2");
        component.bindItems((Signal)itemsSignal);
        TestDataView dataView = component.getGenericDataView();
        Assertions.assertEquals((int)1, (int)dataView.getRefreshAllCount());
        itemsSignal.insertLast((Object)"Item 3");
        Assertions.assertEquals((int)2, (int)dataView.getRefreshAllCount());
        Assertions.assertEquals((int)3, (int)dataView.getItemCount());
        Assertions.assertEquals((Object)"Item 3", (Object)dataView.getItem(2));
    }

    @Test
    public void bindItems_innerSignalChange_triggersRefreshItem() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ListSignal itemsSignal = new ListSignal();
        itemsSignal.insertLast((Object)"Item 1");
        itemsSignal.insertLast((Object)"Item 2");
        component.bindItems((Signal)itemsSignal);
        TestDataView dataView = component.getGenericDataView();
        ValueSignal item1Signal = (ValueSignal)itemsSignal.peek().getFirst();
        dataView.resetCounters();
        item1Signal.set((Object)"Updated Item 1");
        Assertions.assertEquals((int)0, (int)dataView.getRefreshAllCount());
        Assertions.assertEquals((int)1, (int)dataView.getRefreshedItems().size());
        Assertions.assertEquals((Object)"Updated Item 1", (Object)dataView.getRefreshedItems().getFirst());
        Assertions.assertEquals((Object)"Updated Item 1", (Object)dataView.getItem(0));
    }

    @Test
    public void bindItems_multipleInnerSignalChanges_triggersMultipleRefreshItems() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ListSignal itemsSignal = new ListSignal();
        itemsSignal.insertLast((Object)"Item 1");
        itemsSignal.insertLast((Object)"Item 2");
        itemsSignal.insertLast((Object)"Item 3");
        component.bindItems((Signal)itemsSignal);
        TestDataView dataView = component.getGenericDataView();
        ValueSignal item1Signal = (ValueSignal)itemsSignal.peek().get(0);
        ValueSignal item3Signal = (ValueSignal)itemsSignal.peek().get(2);
        dataView.resetCounters();
        item1Signal.set((Object)"Updated Item 1");
        item3Signal.set((Object)"Updated Item 3");
        Assertions.assertEquals((int)0, (int)dataView.getRefreshAllCount());
        Assertions.assertEquals((int)2, (int)dataView.getRefreshedItems().size());
        Assertions.assertTrue((boolean)dataView.getRefreshedItems().contains("Updated Item 1"));
        Assertions.assertTrue((boolean)dataView.getRefreshedItems().contains("Updated Item 3"));
    }

    @Test
    public void bindItems_mixedChanges_correctRefreshCalls() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ListSignal itemsSignal = new ListSignal();
        itemsSignal.insertLast((Object)"Item 1");
        component.bindItems((Signal)itemsSignal);
        TestDataView dataView = component.getGenericDataView();
        ValueSignal item1Signal = (ValueSignal)itemsSignal.peek().getFirst();
        dataView.resetCounters();
        item1Signal.set((Object)"Updated Item 1");
        Assertions.assertEquals((int)0, (int)dataView.getRefreshAllCount());
        Assertions.assertEquals((int)1, (int)dataView.getRefreshedItems().size());
        itemsSignal.insertLast((Object)"Item 2");
        Assertions.assertEquals((int)1, (int)dataView.getRefreshAllCount());
        Assertions.assertEquals((int)1, (int)dataView.getRefreshedItems().size());
        item1Signal = (ValueSignal)itemsSignal.peek().getFirst();
        item1Signal.set((Object)"Updated Again");
        Assertions.assertEquals((int)1, (int)dataView.getRefreshAllCount());
        Assertions.assertEquals((int)2, (int)dataView.getRefreshedItems().size());
    }

    @Test
    public void bindItems_emptyList_handledCorrectly() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ListSignal itemsSignal = new ListSignal();
        component.bindItems((Signal)itemsSignal);
        TestDataView dataView = component.getGenericDataView();
        Assertions.assertEquals((int)0, (int)dataView.getItemCount());
        itemsSignal.insertLast((Object)"First Item");
        Assertions.assertEquals((int)1, (int)dataView.getItemCount());
    }

    @Test
    public void bindItems_removeItems_triggersRefreshAll() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ListSignal itemsSignal = new ListSignal();
        itemsSignal.insertLast((Object)"Item 1");
        itemsSignal.insertLast((Object)"Item 2");
        component.bindItems((Signal)itemsSignal);
        TestDataView dataView = component.getGenericDataView();
        ValueSignal item1Signal = (ValueSignal)itemsSignal.peek().getFirst();
        dataView.resetCounters();
        itemsSignal.remove(item1Signal);
        Assertions.assertEquals((int)1, (int)dataView.getRefreshAllCount());
        Assertions.assertEquals((int)1, (int)dataView.getItemCount());
        Assertions.assertEquals((Object)"Item 2", (Object)dataView.getItem(0));
    }

    @Test
    public void bindItems_nullSignal_throwsException() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        Assertions.assertThrows(NullPointerException.class, () -> component.bindItems(null));
    }

    @Test
    public void bindItems_alreadyBound_throwsBindingActiveException() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ListSignal itemsSignal = new ListSignal();
        itemsSignal.insertLast((Object)"Item 1");
        component.bindItems((Signal)itemsSignal);
        ListSignal secondSignal = new ListSignal();
        secondSignal.insertLast((Object)"Item 2");
        Assertions.assertThrows(BindingActiveException.class, () -> component.bindItems((Signal)secondSignal));
    }

    @Test
    public void bindItems_componentDetached_effectsStopWorking() {
        TestComponent component = new TestComponent();
        UI ui = UI.getCurrent();
        ui.add(new Component[]{component});
        ListSignal itemsSignal = new ListSignal();
        itemsSignal.insertLast((Object)"Item 1");
        component.bindItems((Signal)itemsSignal);
        TestDataView dataView = component.getGenericDataView();
        ValueSignal item1Signal = (ValueSignal)itemsSignal.peek().getFirst();
        ui.remove(new Component[]{component});
        dataView.resetCounters();
        item1Signal.set((Object)"Updated while detached");
        Assertions.assertEquals((int)0, (int)dataView.getRefreshAllCount());
        Assertions.assertEquals((int)0, (int)dataView.getRefreshedItems().size());
    }

    @Test
    public void bindItems_componentReattached_effectsResumeWorking() {
        TestComponent component = new TestComponent();
        UI ui = UI.getCurrent();
        ui.add(new Component[]{component});
        ListSignal itemsSignal = new ListSignal();
        itemsSignal.insertLast((Object)"Item 1");
        component.bindItems((Signal)itemsSignal);
        TestDataView dataView = component.getGenericDataView();
        ValueSignal item1Signal = (ValueSignal)itemsSignal.peek().getFirst();
        ui.remove(new Component[]{component});
        ui.add(new Component[]{component});
        dataView.resetCounters();
        item1Signal.set((Object)"Updated after reattach");
        Assertions.assertFalse((boolean)dataView.getRefreshedItems().isEmpty());
    }

    @Test
    public void bindItems_sharedListSignal_itemsInsertedAndUpdated() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        SharedListSignal itemsSignal = new SharedListSignal(String.class);
        itemsSignal.insertLast((Object)"Item 1");
        itemsSignal.insertLast((Object)"Item 2");
        component.bindItems((Signal)itemsSignal);
        TestDataView dataView = component.getGenericDataView();
        Assertions.assertEquals((int)2, (int)dataView.getItemCount());
        Assertions.assertEquals((Object)"Item 1", (Object)dataView.getItem(0));
        Assertions.assertEquals((Object)"Item 2", (Object)dataView.getItem(1));
        dataView.resetCounters();
        SharedValueSignal item1Signal = (SharedValueSignal)itemsSignal.peek().getFirst();
        item1Signal.set((Object)"Updated Item 1");
        Assertions.assertEquals((int)0, (int)dataView.getRefreshAllCount());
        Assertions.assertEquals((int)1, (int)dataView.getRefreshedItems().size());
        Assertions.assertEquals((Object)"Updated Item 1", (Object)dataView.getRefreshedItems().getFirst());
        dataView.resetCounters();
        itemsSignal.insertLast((Object)"Item 3");
        Assertions.assertEquals((int)1, (int)dataView.getRefreshAllCount());
        Assertions.assertEquals((int)3, (int)dataView.getItemCount());
    }

    @Test
    public void bindItems_genericSignal_worksCorrectly() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ArrayList<ValueSignal> signalList = new ArrayList<ValueSignal>();
        signalList.add(new ValueSignal((Object)"Item 1"));
        signalList.add(new ValueSignal((Object)"Item 2"));
        ValueSignal itemsSignal = new ValueSignal(signalList);
        component.bindItems((Signal)itemsSignal);
        TestDataView dataView = component.getGenericDataView();
        Assertions.assertEquals((int)2, (int)dataView.getItemCount());
        Assertions.assertEquals((Object)"Item 1", (Object)dataView.getItem(0));
        Assertions.assertEquals((Object)"Item 2", (Object)dataView.getItem(1));
        dataView.resetCounters();
        ((ValueSignal)signalList.getFirst()).set((Object)"Updated Item 1");
        Assertions.assertEquals((int)0, (int)dataView.getRefreshAllCount());
        Assertions.assertEquals((int)1, (int)dataView.getRefreshedItems().size());
        Assertions.assertEquals((Object)"Updated Item 1", (Object)dataView.getRefreshedItems().getFirst());
        Assertions.assertEquals((Object)"Updated Item 1", (Object)dataView.getItem(0));
    }

    @Tag(value="test-component")
    private static class TestComponent
    extends Component
    implements HasDataView<String, Void, TestDataView> {
        private InMemoryDataProvider<String> dataProvider;
        private TestDataView dataView;

        private TestComponent() {
        }

        public TestDataView setItems(DataProvider<String, Void> dataProvider) {
            if (dataProvider instanceof InMemoryDataProvider) {
                this.dataProvider = (InMemoryDataProvider)dataProvider;
            }
            this.dataView = new TestDataView((SerializableSupplier & Serializable)() -> dataProvider, this);
            return this.dataView;
        }

        public TestDataView setItems(InMemoryDataProvider<String> dataProvider) {
            this.dataProvider = dataProvider;
            this.dataView = new TestDataView((SerializableSupplier & Serializable)() -> dataProvider, this);
            return this.dataView;
        }

        public TestDataView getGenericDataView() {
            if (this.dataView == null) {
                throw new IllegalStateException("No data provider has been set");
            }
            return this.dataView;
        }

        public InMemoryDataProvider<String> getDataProvider() {
            return this.dataProvider;
        }
    }

    private static class TestDataView
    extends AbstractDataView<String> {
        private int refreshAllCount = 0;
        private final List<String> refreshedItems = new ArrayList<String>();

        public TestDataView(SerializableSupplier<? extends DataProvider<String, ?>> dataProviderSupplier, Component component) {
            super(dataProviderSupplier, component);
        }

        protected Class<?> getSupportedDataProviderType() {
            return InMemoryDataProvider.class;
        }

        public void refreshAll() {
            ++this.refreshAllCount;
            super.refreshAll();
        }

        public void refreshItem(String item) {
            this.refreshedItems.add(item);
            super.refreshItem((Object)item);
        }

        public int getItemCount() {
            return (int)this.getItems().count();
        }

        public String getItem(int index) {
            return this.getItems().skip(index).findFirst().orElse(null);
        }

        public int getRefreshAllCount() {
            return this.refreshAllCount;
        }

        public List<String> getRefreshedItems() {
            return this.refreshedItems;
        }

        public void resetCounters() {
            this.refreshAllCount = 0;
            this.refreshedItems.clear();
        }
    }
}

