/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.binder;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.data.binder.Binder;
import java.io.Serializable;
import java.util.Locale;
import java.util.Optional;

public class ValueContext
implements Serializable {
    private final Binder<?> binder;
    private final Component component;
    private final HasValue<?, ?> hasValue;
    private final Locale locale;

    public ValueContext() {
        this.binder = null;
        this.component = null;
        this.hasValue = null;
        this.locale = this.findLocale(this.component);
    }

    public ValueContext(Binder<?> binder) {
        this.binder = binder;
        this.component = null;
        this.hasValue = null;
        this.locale = this.findLocale(this.component);
    }

    public ValueContext(Locale locale) {
        this.binder = null;
        this.component = null;
        this.locale = locale;
        this.hasValue = null;
    }

    public ValueContext(Binder binder, Locale locale) {
        this.binder = binder;
        this.component = null;
        this.locale = locale;
        this.hasValue = null;
    }

    public ValueContext(Component component) {
        this.binder = null;
        this.component = component;
        this.hasValue = component instanceof HasValue ? (HasValue)component : null;
        this.locale = this.findLocale(component);
    }

    public ValueContext(Binder binder, Component component) {
        this.binder = binder;
        this.component = component;
        this.hasValue = component instanceof HasValue ? (HasValue)component : null;
        this.locale = this.findLocale(component);
    }

    public ValueContext(Component component, HasValue<?, ?> hasValue) {
        this.binder = null;
        this.component = component;
        this.hasValue = hasValue;
        this.locale = this.findLocale(component);
    }

    public ValueContext(Binder binder, Component component, HasValue<?, ?> hasValue) {
        this.binder = binder;
        this.component = component;
        this.hasValue = hasValue;
        this.locale = this.findLocale(component);
    }

    public ValueContext(Component component, HasValue<?, ?> hasValue, Locale locale) {
        this.binder = null;
        this.component = component;
        this.hasValue = hasValue;
        this.locale = locale;
    }

    public ValueContext(Binder binder, Component component, HasValue<?, ?> hasValue, Locale locale) {
        this.binder = binder;
        this.component = component;
        this.hasValue = hasValue;
        this.locale = locale;
    }

    private Locale findLocale(Component component) {
        UI ui = null;
        ui = component != null ? component.getUI().orElseGet(UI::getCurrent) : UI.getCurrent();
        if (ui != null) {
            return ui.getLocale();
        }
        return Locale.getDefault();
    }

    public Optional<Component> getComponent() {
        return Optional.ofNullable(this.component);
    }

    public Optional<Locale> getLocale() {
        return Optional.ofNullable(this.locale);
    }

    public Optional<HasValue<?, ?>> getHasValue() {
        return Optional.ofNullable(this.hasValue);
    }

    public Optional<Binder<?>> getBinder() {
        return Optional.ofNullable(this.binder);
    }
}

