/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.data.provider.DataView;
import com.vaadin.flow.data.provider.HasDataView;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.function.SerializableComparator;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.internal.nodefeature.SignalBindingFeature;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.signals.BindingActiveException;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.function.EffectAction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;

public final class DataViewUtils {
    private static final String COMPONENT_IN_MEMORY_FILTER_KEY = "component-in-memory-filter-key";
    private static final String COMPONENT_IN_MEMORY_SORTING_KEY = "component-in-memory-sorting-key";

    private DataViewUtils() {
    }

    public static <T> Optional<SerializablePredicate<T>> getComponentFilter(Component component) {
        return Optional.ofNullable((SerializablePredicate)ComponentUtil.getData((Component)component, (String)COMPONENT_IN_MEMORY_FILTER_KEY));
    }

    public static <T> Optional<SerializableComparator<T>> getComponentSortComparator(Component component) {
        return Optional.ofNullable((SerializableComparator)ComponentUtil.getData((Component)component, (String)COMPONENT_IN_MEMORY_SORTING_KEY));
    }

    public static <T> void setComponentFilter(Component component, SerializablePredicate<T> filter) {
        ComponentUtil.setData((Component)component, (String)COMPONENT_IN_MEMORY_FILTER_KEY, filter);
    }

    public static <T> void setComponentSortComparator(Component component, SerializableComparator<T> sortComparator) {
        ComponentUtil.setData((Component)component, (String)COMPONENT_IN_MEMORY_SORTING_KEY, sortComparator);
    }

    public static void removeComponentFilterAndSortComparator(Component component) {
        DataViewUtils.setComponentFilter(component, null);
        DataViewUtils.setComponentSortComparator(component, null);
    }

    public static Query getQuery(Component component) {
        return DataViewUtils.getQuery(component, true);
    }

    public static Query getQuery(Component component, boolean withSorting) {
        Optional<SerializablePredicate<Object>> filter = DataViewUtils.getComponentFilter(component);
        Optional<Object> sorting = withSorting ? DataViewUtils.getComponentSortComparator(component) : Optional.empty();
        return new Query(0, Integer.MAX_VALUE, null, sorting.orElse(null), filter.orElse(null));
    }

    public static <T, V extends DataView<T>> V bindItems(HasDataView<T, ?, V> hasDataView, Signal<? extends List<? extends Signal<T>>> itemsSignal, SerializableFunction<List<T>, V> dataProviderSetter) {
        Objects.requireNonNull(hasDataView, "HasDataView cannot be null");
        Objects.requireNonNull(itemsSignal, "Items signal cannot be null");
        Objects.requireNonNull(dataProviderSetter, "Data provider setter cannot be null");
        if (!(hasDataView instanceof Component)) {
            throw new IllegalArgumentException("bindItems can only be used with Component instances");
        }
        Component component = (Component)hasDataView;
        SignalBindingFeature bindingFeature = (SignalBindingFeature)component.getElement().getNode().getFeature(SignalBindingFeature.class);
        if (bindingFeature.hasBinding("items")) {
            throw new BindingActiveException("Cannot bind items: a binding is already active");
        }
        ArrayList backingList = new ArrayList(Objects.requireNonNull((List)itemsSignal.peek()).size());
        DataView dataView = (DataView)dataProviderSetter.apply(backingList);
        ArrayList innerEffectRegistrations = new ArrayList();
        Registration outerEffect = Signal.effect((Component)component, (EffectAction & Serializable)() -> {
            List currentSignals = Objects.requireNonNull((List)itemsSignal.get());
            innerEffectRegistrations.forEach(Registration::remove);
            innerEffectRegistrations.clear();
            DataViewUtils.updateBackingList(currentSignals, backingList);
            dataView.refreshAll();
            DataViewUtils.createInnerEffects(component, currentSignals, backingList, dataView, innerEffectRegistrations);
        });
        bindingFeature.setBinding("items", outerEffect, itemsSignal);
        return (V)dataView;
    }

    private static <T> void updateBackingList(List<? extends Signal<T>> currentSignals, List<T> backingList) {
        backingList.clear();
        for (Signal<T> signal : currentSignals) {
            Object value = signal.peek();
            backingList.add(value);
        }
    }

    private static <T, V extends DataView<T>> void createInnerEffects(Component component, List<? extends Signal<T>> currentSignals, List<T> backingList, V dataView, List<Registration> innerEffectRegistrations) {
        for (int i = 0; i < currentSignals.size(); ++i) {
            Signal<T> itemSignal = currentSignals.get(i);
            Registration innerEffect = DataViewUtils.createItemEffect(component, itemSignal, i, backingList, dataView);
            innerEffectRegistrations.add(innerEffect);
        }
    }

    private static <T, V extends DataView<T>> Registration createItemEffect(Component component, Signal<T> itemSignal, int index, List<T> backingList, V dataView) {
        AtomicBoolean isFirstRun = new AtomicBoolean(true);
        return Signal.effect((Component)component, (EffectAction & Serializable)() -> {
            Object newValue = itemSignal.get();
            if (!isFirstRun.get()) {
                backingList.set(index, newValue);
                dataView.refreshItem(newValue);
            }
            isFirstRun.set(false);
        });
    }
}

