/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.tests.data;

import com.vaadin.flow.data.binder.HasDataProvider;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.DataProviderListener;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.testutil.ClassesSerializableTest;
import java.io.Serializable;
import java.util.Collections;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class DataSerializableTest
extends ClassesSerializableTest {
    DataSerializableTest() {
    }

    @Test
    public void selfReferenceSerialization() throws Throwable {
        Outer outer = new Outer();
        Outer out = (Outer)this.serializeAndDeserialize(outer);
        Assertions.assertNotNull((Object)out);
    }

    static class Outer
    implements Serializable {
        private final ListDataProvider<Object> dataProvider = new ListDataProvider(Collections.emptyList());
        private final Inner inner = new Inner();

        public Outer() {
            this.inner.setDataProvider((DataProvider<Object, ?>)this.dataProvider);
        }
    }

    static class Inner
    implements HasDataProvider<Object>,
    Serializable {
        private Registration registration;

        Inner() {
        }

        public void setDataProvider(DataProvider<Object, ?> dataProvider) {
            if (this.registration != null) {
                this.registration.remove();
            }
            this.registration = dataProvider.addDataProviderListener((DataProviderListener & Serializable)event -> this.onDataProviderChange());
        }

        void onDataProviderChange() {
        }
    }
}

