/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.DataView;
import com.vaadin.flow.data.provider.InMemoryDataProvider;
import com.vaadin.flow.internal.nodefeature.SignalBindingFeature;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.signals.BindingActiveException;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.function.EffectAction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public interface HasDataView<T, F, V extends DataView<T>>
extends Serializable {
    public V setItems(DataProvider<T, F> var1);

    public V setItems(InMemoryDataProvider<T> var1);

    public V getGenericDataView();

    default public V bindItems(Signal<? extends List<? extends Signal<T>>> itemsSignal) {
        Objects.requireNonNull(itemsSignal, "Items signal cannot be null");
        HasDataView hasDataView = this;
        if (!(hasDataView instanceof Component)) {
            throw new IllegalArgumentException("bindItems can only be used with Component instances");
        }
        Component component = (Component)hasDataView;
        SignalBindingFeature bindingFeature = (SignalBindingFeature)component.getElement().getNode().getFeature(SignalBindingFeature.class);
        if (bindingFeature.hasBinding("items")) {
            throw new BindingActiveException("Cannot bind items: a binding is already active");
        }
        ArrayList backingList = new ArrayList(Objects.requireNonNull((List)itemsSignal.peek()).size());
        Object dataView = this.setItems(DataProvider.ofCollection(backingList));
        ArrayList innerEffectRegistrations = new ArrayList();
        Registration outerEffect = Signal.effect((Component)component, (EffectAction & Serializable)() -> {
            List currentSignals = Objects.requireNonNull((List)itemsSignal.get());
            innerEffectRegistrations.forEach(Registration::remove);
            innerEffectRegistrations.clear();
            HasDataView.updateBackingList(currentSignals, backingList);
            dataView.refreshAll();
            HasDataView.createInnerEffects(component, currentSignals, backingList, dataView, innerEffectRegistrations);
        });
        bindingFeature.setBinding("items", outerEffect, itemsSignal);
        return dataView;
    }

    private static <T> void updateBackingList(List<? extends Signal<T>> currentSignals, List<T> backingList) {
        backingList.clear();
        for (Signal<T> signal : currentSignals) {
            Object value = signal.peek();
            backingList.add(value);
        }
    }

    private static <T, V extends DataView<T>> void createInnerEffects(Component component, List<? extends Signal<T>> currentSignals, List<T> backingList, V dataView, List<Registration> innerEffectRegistrations) {
        for (int i = 0; i < currentSignals.size(); ++i) {
            Signal<T> itemSignal = currentSignals.get(i);
            Registration innerEffect = HasDataView.createItemEffect(component, itemSignal, i, backingList, dataView);
            innerEffectRegistrations.add(innerEffect);
        }
    }

    private static <T, V extends DataView<T>> Registration createItemEffect(Component component, Signal<T> itemSignal, int index, List<T> backingList, V dataView) {
        AtomicBoolean isFirstRun = new AtomicBoolean(true);
        return Signal.effect((Component)component, (EffectAction & Serializable)() -> {
            Object newValue = itemSignal.get();
            if (!isFirstRun.get()) {
                backingList.set(index, newValue);
                dataView.refreshItem(newValue);
            }
            isFirstRun.set(false);
        });
    }
}

