/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.binder;

import com.vaadin.flow.data.binder.Result;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import java.util.Objects;
import java.util.Optional;

class SimpleResult<R>
implements Result<R> {
    private final R value;
    private final String message;

    SimpleResult(R value, String message) {
        assert (value == null || message == null) : "Message must be null if value is provided";
        this.value = value;
        this.message = message;
    }

    @Override
    public <S> Result<S> flatMap(SerializableFunction<R, Result<S>> mapper) {
        Objects.requireNonNull(mapper, "mapper cannot be null");
        if (this.isError()) {
            return this;
        }
        return (Result)mapper.apply(this.value);
    }

    @Override
    public void handle(SerializableConsumer<R> ifOk, SerializableConsumer<String> ifError) {
        Objects.requireNonNull(ifOk, "ifOk cannot be null");
        Objects.requireNonNull(ifError, "ifError cannot be null");
        if (this.isError()) {
            ifError.accept((Object)this.message);
        } else {
            ifOk.accept(this.value);
        }
    }

    @Override
    public Optional<String> getMessage() {
        return Optional.ofNullable(this.message);
    }

    @Override
    public boolean isError() {
        return this.message != null;
    }

    public String toString() {
        if (this.isError()) {
            return "error(" + this.message + ")";
        }
        return "ok(" + String.valueOf(this.value) + ")";
    }

    @Override
    public <X extends Throwable> R getOrThrow(SerializableFunction<String, ? extends X> exceptionSupplier) throws X {
        Objects.requireNonNull(exceptionSupplier, "Exception supplier cannot be null");
        if (this.isError()) {
            throw (Throwable)exceptionSupplier.apply((Object)this.message);
        }
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        SimpleResult that = (SimpleResult)obj;
        return Objects.equals(that.value, this.value) && Objects.equals(that.message, this.message);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.message);
    }
}

