/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.converter;

import com.vaadin.flow.data.binder.Result;
import com.vaadin.flow.data.converter.FloatToDoubleConverter;
import org.junit.Assert;
import org.junit.Test;

public class FloatToDoubleConverterTest {
    FloatToDoubleConverter converter = new FloatToDoubleConverter();

    @Test
    public void testNullConversionToModel() {
        Assert.assertEquals((Object)Result.ok(null), (Object)this.converter.convertToModel(null, null));
    }

    @Test
    public void testNullConversionToPresentation() {
        Assert.assertNull((Object)this.converter.convertToPresentation(null, null));
    }

    @Test
    public void testConvertToModel() {
        Assert.assertEquals((Object)Result.ok((Object)42.0), (Object)this.converter.convertToModel(Float.valueOf(42.0f), null));
    }

    @Test
    public void testConvertToPresentation() {
        Assert.assertEquals((Object)Float.valueOf(42.0f), (Object)this.converter.convertToPresentation(Double.valueOf(42.0), null));
    }

    @Test
    public void testConvertToModelMaxFloat() {
        Assert.assertEquals((Object)Result.ok((Object)3.4028234663852886E38), (Object)this.converter.convertToModel(Float.valueOf(Float.MAX_VALUE), null));
    }

    @Test
    public void testConvertToPresentationMaxFloat() {
        Assert.assertEquals((Object)Float.valueOf(Float.MAX_VALUE), (Object)this.converter.convertToPresentation(Double.valueOf(3.4028234663852886E38), null));
    }

    @Test
    public void testConvertToModelMinFloat() {
        Assert.assertEquals((Object)Result.ok((Object)1.4E-45f), (Object)this.converter.convertToModel(Float.valueOf(Float.MIN_VALUE), null));
    }

    @Test
    public void testConvertToPresentationMinFloat() {
        Assert.assertEquals((Object)Float.valueOf(Float.MIN_VALUE), (Object)this.converter.convertToPresentation(Double.valueOf(1.4E-45f), null));
    }

    @Test
    public void testConvertToModelPositiveInfinity() {
        Assert.assertEquals((Object)Result.ok((Object)Double.POSITIVE_INFINITY), (Object)this.converter.convertToModel(Float.valueOf(Float.POSITIVE_INFINITY), null));
    }

    @Test
    public void testConvertToPresentationPositiveInfinity() {
        Assert.assertEquals((Object)Float.valueOf(Float.POSITIVE_INFINITY), (Object)this.converter.convertToPresentation(Double.valueOf(Double.POSITIVE_INFINITY), null));
    }

    @Test
    public void testConvertToModelNegativeInfinity() {
        Assert.assertEquals((Object)Result.ok((Object)Double.NEGATIVE_INFINITY), (Object)this.converter.convertToModel(Float.valueOf(Float.NEGATIVE_INFINITY), null));
    }

    @Test
    public void testConvertToPresentationNegativeInfinity() {
        Assert.assertEquals((Object)Float.valueOf(Float.NEGATIVE_INFINITY), (Object)this.converter.convertToPresentation(Double.valueOf(Double.NEGATIVE_INFINITY), null));
    }
}

