/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider.hierarchy;

import com.vaadin.flow.data.provider.CompositeDataGenerator;
import com.vaadin.flow.data.provider.DataCommunicator;
import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.data.provider.hierarchy.AbstractHierarchicalDataCommunicatorTest;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalDataCommunicator;
import com.vaadin.flow.data.provider.hierarchy.TreeData;
import com.vaadin.flow.data.provider.hierarchy.TreeDataProvider;
import com.vaadin.flow.function.SerializableSupplier;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.junit.Before;
import org.junit.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HierarchicalDataCommunicatorViewportTest
extends AbstractHierarchicalDataCommunicatorTest {
    private TreeData<AbstractHierarchicalDataCommunicatorTest.Item> treeData = new TreeData();
    private TreeDataProvider<AbstractHierarchicalDataCommunicatorTest.Item> treeDataProvider = new TreeDataProvider(this.treeData);
    private HierarchicalDataCommunicator<AbstractHierarchicalDataCommunicatorTest.Item> dataCommunicator;

    @Override
    @Before
    public void init() {
        super.init();
        CompositeDataGenerator compositeDataGenerator = new CompositeDataGenerator();
        compositeDataGenerator.addDataGenerator((DataGenerator & Serializable)(item, json) -> json.put("name", item.getName()));
        this.dataCommunicator = new HierarchicalDataCommunicator(compositeDataGenerator, this.arrayUpdater, this.ui.getElement().getNode(), (SerializableSupplier & Serializable)() -> null);
        this.dataCommunicator.setDataProvider(this.treeDataProvider, null);
    }

    @Test
    public void setViewportRange_flush_requestedRangeSent() {
        this.populateTreeData(this.treeData, 100, 2, 2);
        this.dataCommunicator.setViewportRange(0, 5);
        this.fakeClientCommunication();
        this.assertArrayUpdateSize(100);
        this.assertArrayUpdateRange(0, 5);
        this.assertArrayUpdateItems("name", Map.of(0, "Item 0", 1, "Item 1", 2, "Item 2", 3, "Item 3", 4, "Item 4"));
        Mockito.clearInvocations((Object[])new Serializable[]{this.arrayUpdater, this.arrayUpdate});
        this.dataCommunicator.setViewportRange(95, 5);
        this.fakeClientCommunication();
        this.assertArrayUpdateSize(100);
        this.assertArrayUpdateRange(95, 5);
        this.assertArrayUpdateItems("name", Map.of(95, "Item 95", 96, "Item 96", 97, "Item 97", 98, "Item 98", 99, "Item 99"));
    }

    @Test
    public void setViewportRange_flush_setOverlappingRange_partialRangeSent() {
        this.populateTreeData(this.treeData, 100, 2, 2);
        this.dataCommunicator.setViewportRange(0, 5);
        this.fakeClientCommunication();
        Mockito.clearInvocations((Object[])new Serializable[]{this.arrayUpdater, this.arrayUpdate});
        this.dataCommunicator.setViewportRange(3, 5);
        this.fakeClientCommunication();
        this.assertArrayUpdateSize(100);
        this.assertArrayUpdateRange(3, 5);
        this.assertArrayUpdateItems("name", Map.of(5, "Item 5", 6, "Item 6", 7, "Item 7"));
        Mockito.clearInvocations((Object[])new Serializable[]{this.arrayUpdater, this.arrayUpdate});
        this.dataCommunicator.setViewportRange(0, 10);
        this.fakeClientCommunication();
        this.assertArrayUpdateSize(100);
        this.assertArrayUpdateRange(0, 10);
        this.assertArrayUpdateItems("name", Map.of(0, "Item 0", 1, "Item 1", 2, "Item 2", 8, "Item 8", 9, "Item 9"));
        Mockito.clearInvocations((Object[])new Serializable[]{this.arrayUpdater, this.arrayUpdate});
        this.dataCommunicator.setViewportRange(3, 5);
        this.fakeClientCommunication();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.arrayUpdater, this.arrayUpdate});
        this.dataCommunicator.setViewportRange(0, 5);
        this.fakeClientCommunication();
        this.assertArrayUpdateSize(100);
        this.assertArrayUpdateRange(0, 5);
        this.assertArrayUpdateItems("name", Map.of(0, "Item 0", 1, "Item 1", 2, "Item 2"));
    }

    @Test
    public void setViewportRangeMultipleTimes_flush_onlyLastRangeSent() {
        this.populateTreeData(this.treeData, 100, 2, 2);
        this.dataCommunicator.setViewportRange(0, 10);
        this.dataCommunicator.setViewportRange(50, 2);
        this.fakeClientCommunication();
        this.assertArrayUpdateSize(100);
        this.assertArrayUpdateRange(50, 2);
        this.assertArrayUpdateItems("name", Map.of(50, "Item 50", 51, "Item 51"));
    }

    @Test
    public void setViewportRange_toggleItems_rangeItemsUpdated() {
        this.populateTreeData(this.treeData, 100, 2, 2);
        this.dataCommunicator.setViewportRange(0, 6);
        this.dataCommunicator.expand((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"));
        this.fakeClientCommunication();
        this.assertArrayUpdateSize(102);
        this.assertArrayUpdateRange(0, 6);
        this.assertArrayUpdateItems("name", Map.of(0, "Item 0", 1, "Item 0-0", 2, "Item 0-1", 3, "Item 1", 4, "Item 2", 5, "Item 3"));
        Mockito.clearInvocations((Object[])new Serializable[]{this.arrayUpdater, this.arrayUpdate});
        this.dataCommunicator.expand((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0"));
        this.fakeClientCommunication();
        this.assertArrayUpdateSize(104);
        this.assertArrayUpdateRange(0, 6);
        this.assertArrayUpdateItems("name", Map.of(0, "Item 0", 1, "Item 0-0", 2, "Item 0-0-0", 3, "Item 0-0-1", 4, "Item 0-1", 5, "Item 1"));
        Mockito.clearInvocations((Object[])new Serializable[]{this.arrayUpdater, this.arrayUpdate});
        this.dataCommunicator.collapse((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0"));
        this.fakeClientCommunication();
        this.assertArrayUpdateSize(102);
        this.assertArrayUpdateRange(0, 6);
        this.assertArrayUpdateItems("name", Map.of(0, "Item 0", 1, "Item 0-0", 2, "Item 0-1", 3, "Item 1", 4, "Item 2", 5, "Item 3"));
        Mockito.clearInvocations((Object[])new Serializable[]{this.arrayUpdater, this.arrayUpdate});
        this.dataCommunicator.collapse((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"));
        this.fakeClientCommunication();
        this.assertArrayUpdateSize(100);
        this.assertArrayUpdateRange(0, 6);
        this.assertArrayUpdateItems("name", Map.of(0, "Item 0", 1, "Item 1", 2, "Item 2", 3, "Item 3", 4, "Item 4", 5, "Item 5"));
    }

    @Test
    public void setViewportRange_toggleItemWithPreExpandedChildren_rangeItemsUpdated() {
        this.populateTreeData(this.treeData, 100, 2, 2);
        this.dataCommunicator.setViewportRange(0, 6);
        this.dataCommunicator.expand((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0"));
        this.fakeClientCommunication();
        this.assertArrayUpdateSize(100);
        this.assertArrayUpdateRange(0, 6);
        this.assertArrayUpdateItems("name", Map.of(0, "Item 0", 1, "Item 1", 2, "Item 2", 3, "Item 3", 4, "Item 4", 5, "Item 5"));
        Mockito.clearInvocations((Object[])new Serializable[]{this.arrayUpdater, this.arrayUpdate});
        this.dataCommunicator.expand((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"));
        this.fakeClientCommunication();
        this.assertArrayUpdateSize(104);
        this.assertArrayUpdateRange(0, 6);
        this.assertArrayUpdateItems("name", Map.of(0, "Item 0", 1, "Item 0-0", 2, "Item 0-0-0", 3, "Item 0-0-1", 4, "Item 0-1", 5, "Item 1"));
        Mockito.clearInvocations((Object[])new Serializable[]{this.arrayUpdater, this.arrayUpdate});
        this.dataCommunicator.collapse((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"));
        this.fakeClientCommunication();
        this.assertArrayUpdateSize(100);
        this.assertArrayUpdateRange(0, 6);
        this.assertArrayUpdateItems("name", Map.of(0, "Item 0", 1, "Item 1", 2, "Item 2", 3, "Item 3", 4, "Item 4", 5, "Item 5"));
    }

    @Test
    public void setViewportRange_toggleItemOutsideViewport_flatSizeNotUpdated() {
        this.populateTreeData(this.treeData, 100, 2, 2);
        this.dataCommunicator.setViewportRange(0, 10);
        this.fakeClientCommunication();
        Mockito.clearInvocations((Object[])new Serializable[]{this.arrayUpdater, this.arrayUpdate});
        this.dataCommunicator.expand((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 99"));
        this.fakeClientCommunication();
        this.assertArrayUpdateSize(100);
        Mockito.clearInvocations((Object[])new Serializable[]{this.arrayUpdater, this.arrayUpdate});
        this.dataCommunicator.collapse((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 99"));
        this.fakeClientCommunication();
        this.assertArrayUpdateSize(100);
    }

    @Test
    public void setViewportRange_expandItemOutsideViewport_moveItemIntoViewport_flatSizeUpdated() {
        this.populateTreeData(this.treeData, 100, 2, 2);
        this.dataCommunicator.setViewportRange(0, 6);
        this.fakeClientCommunication();
        Mockito.clearInvocations((Object[])new Serializable[]{this.arrayUpdater, this.arrayUpdate});
        this.dataCommunicator.expand((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 99"));
        this.fakeClientCommunication();
        this.assertArrayUpdateSize(100);
        Mockito.clearInvocations((Object[])new Serializable[]{this.arrayUpdater, this.arrayUpdate});
        this.dataCommunicator.setViewportRange(94, 6);
        this.fakeClientCommunication();
        this.assertArrayUpdateSize(102);
    }

    @Test
    public void setViewportRange_expandItem_moveItemOutOfViewport_collapseItem_flatSizeUpdated() {
        this.populateTreeData(this.treeData, 100, 2, 2);
        this.dataCommunicator.expand((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"));
        this.dataCommunicator.setViewportRange(0, 6);
        this.fakeClientCommunication();
        this.assertArrayUpdateSize(102);
        Mockito.clearInvocations((Object[])new Serializable[]{this.arrayUpdater, this.arrayUpdate});
        this.dataCommunicator.setViewportRange(101, 1);
        this.fakeClientCommunication();
        this.dataCommunicator.confirmUpdate(this.captureArrayUpdateId());
        this.fakeClientCommunication();
        Mockito.clearInvocations((Object[])new Serializable[]{this.arrayUpdater, this.arrayUpdate});
        this.dataCommunicator.collapse((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"));
        this.fakeClientCommunication();
        this.assertArrayUpdateSize(100);
    }

    @Test
    public void setViewportRangeWithStartBeyondFlatSize_rangeReset() {
        this.populateTreeData(this.treeData, 100, 10);
        this.dataCommunicator.expand((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 99"));
        this.dataCommunicator.setViewportRange(200, 10);
        this.fakeClientCommunication();
        this.assertArrayUpdateSize(100);
        this.assertArrayUpdateRange(0, 10);
    }

    @Test
    public void setViewportRangeWithEndBeyondFlatSize_rangeAdjusted() {
        this.populateTreeData(this.treeData, 100, 10);
        this.dataCommunicator.expand((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 99"));
        this.dataCommunicator.setViewportRange(0, 200);
        this.fakeClientCommunication();
        this.assertArrayUpdateSize(110);
        this.assertArrayUpdateRange(0, 110);
    }

    @Test
    public void setTooLargeViewportRange_warningLogged() {
        this.populateTreeData(this.treeData, 100, 100);
        this.dataCommunicator.expand((Collection)this.treeData.getRootItems());
        try (MockedStatic mockedFactory = Mockito.mockStatic(LoggerFactory.class);){
            Logger mockedLogger = (Logger)Mockito.mock(Logger.class);
            mockedFactory.when(() -> LoggerFactory.getLogger(DataCommunicator.class)).thenReturn((Object)mockedLogger);
            this.dataCommunicator.setViewportRange(0, 1000);
            ((Logger)Mockito.verify((Object)mockedLogger)).warn(Mockito.contains((String)"number of items requested '1000', maximum items allowed '500'"));
            Mockito.clearInvocations((Object[])new Logger[]{mockedLogger});
            this.dataCommunicator.setPageSize(20);
            this.dataCommunicator.setViewportRange(0, 1000);
            ((Logger)Mockito.verify((Object)mockedLogger)).warn(Mockito.contains((String)"number of items requested '1000', maximum items allowed '500'"));
            Mockito.clearInvocations((Object[])new Logger[]{mockedLogger});
            this.dataCommunicator.setPageSize(80);
            this.dataCommunicator.setViewportRange(0, 1000);
            ((Logger)Mockito.verify((Object)mockedLogger)).warn(Mockito.contains((String)"number of items requested '1000', maximum items allowed '800'"));
        }
    }

    @Test
    public void setTooLargeViewportRange_onlyMaxAllowedRangeSent() {
        this.populateTreeData(this.treeData, 100, 100);
        this.dataCommunicator.expand((Collection)this.treeData.getRootItems());
        this.dataCommunicator.setViewportRange(0, 1000);
        this.fakeClientCommunication();
        this.assertArrayUpdateSize(600);
        this.assertArrayUpdateRange(0, 500);
        Mockito.clearInvocations((Object[])new Serializable[]{this.arrayUpdater, this.arrayUpdate});
        this.dataCommunicator.reset();
        this.dataCommunicator.setPageSize(20);
        this.dataCommunicator.setViewportRange(0, 1000);
        this.fakeClientCommunication();
        this.assertArrayUpdateSize(600);
        this.assertArrayUpdateRange(0, 500);
        Mockito.clearInvocations((Object[])new Serializable[]{this.arrayUpdater, this.arrayUpdate});
        this.dataCommunicator.reset();
        this.dataCommunicator.setPageSize(80);
        this.dataCommunicator.setViewportRange(0, 1000);
        this.fakeClientCommunication();
        this.assertArrayUpdateSize(900);
        this.assertArrayUpdateRange(0, 800);
    }
}

