/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.provider.ReplaceListDataProvider;
import com.vaadin.flow.data.provider.StrBean;
import java.util.ArrayList;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class ReplaceListDataProviderTest {
    private static final StrBean TEST_OBJECT = new StrBean("Foo", 10, -1);
    private ReplaceListDataProvider dataProvider = new ReplaceListDataProvider(new ArrayList<StrBean>(Arrays.asList(TEST_OBJECT)));

    @Test
    public void testGetIdOfItem() {
        Object id = this.dataProvider.fetch((Query<StrBean, Void>)new Query()).findFirst().map(this.dataProvider::getId).get();
        Assert.assertEquals((String)"DataProvider not using correct identifier getter", (Object)TEST_OBJECT.getId(), (Object)id);
    }

    @Test
    public void testGetIdOfReplacementItem() {
        Assert.assertFalse((String)"Test object was stale before making any changes.", (boolean)this.dataProvider.isStale(TEST_OBJECT));
        this.dataProvider.refreshItem(new StrBean("Replacement TestObject", 10, -2));
        StrBean fromDataProvider = this.dataProvider.fetch((Query<StrBean, Void>)new Query()).findFirst().get();
        Object id = this.dataProvider.getId(fromDataProvider);
        Assert.assertNotEquals((String)"DataProvider did not return the replacement", (Object)TEST_OBJECT, (Object)fromDataProvider);
        Assert.assertEquals((String)"DataProvider not using correct identifier getter", (Object)TEST_OBJECT.getId(), (Object)id);
        Assert.assertTrue((String)"Old test object should be stale", (boolean)this.dataProvider.isStale(TEST_OBJECT));
    }
}

