/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.data.provider.AbstractLazyDataView;
import com.vaadin.flow.data.provider.ArrayUpdater;
import com.vaadin.flow.data.provider.BackEndDataProvider;
import com.vaadin.flow.data.provider.CallbackDataProvider;
import com.vaadin.flow.data.provider.DataCommunicator;
import com.vaadin.flow.data.provider.DataCommunicatorTest;
import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.ItemIndexProvider;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.tests.data.bean.Item;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import tools.jackson.databind.JsonNode;

public class AbstractLazyDataViewTest {
    private static final String ITEM1 = "foo";
    private ListDataProvider<String> badProvider;
    private DataProvider<String, Void> dataProvider;
    private DataCommunicator<String> dataCommunicator;
    private AbstractLazyDataView<String> dataView;
    private Component component;
    private DataCommunicatorTest.MockUI ui;
    @Mock
    private ArrayUpdater arrayUpdater;
    @Rule
    public ExpectedException exceptionRule = ExpectedException.none();

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        this.component = new TestComponent();
        this.ui = new DataCommunicatorTest.MockUI();
        this.ui.add(new Component[]{this.component});
        ArrayUpdater.Update update = new ArrayUpdater.Update(){

            public void clear(int start, int length) {
            }

            public void set(int start, List<JsonNode> items) {
            }

            public void commit(int updateId) {
            }
        };
        Mockito.when((Object)this.arrayUpdater.startUpdate(Mockito.anyInt())).thenReturn((Object)update);
        this.badProvider = DataProvider.ofItems((Object[])new String[]{ITEM1, "bar"});
        this.dataProvider = DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> {
            query.getOffset();
            query.getLimit();
            return Stream.of(ITEM1, "bar", "baz");
        }, (CallbackDataProvider.CountCallback & Serializable)query -> 3);
        this.dataCommunicator = new DataCommunicator((DataGenerator & Serializable)(item, jsonObject) -> {}, this.arrayUpdater, null, this.component.getElement().getNode());
        this.dataCommunicator.setDataProvider(this.dataProvider, null);
        this.dataView = new AbstractLazyDataView<String>(this.dataCommunicator, this.component){};
    }

    @Test
    public void defaults_withCorrectDataProvider_noErrors() {
        this.dataCommunicator.setDataProvider(this.dataProvider, null);
        Assert.assertTrue((boolean)this.dataView.getDataCommunicator().isDefinedSize());
        Assert.assertEquals(BackEndDataProvider.class, (Object)this.dataView.getSupportedDataProviderType());
        Assert.assertEquals((long)3L, (long)this.dataView.getDataCommunicator().getItemCount());
        Assert.assertEquals((long)200L, (long)this.dataView.getItemCountEstimate());
        Assert.assertEquals((long)200L, (long)this.dataView.getItemCountEstimateIncrease());
        this.dataView.setItemCountUnknown();
        Assert.assertFalse((boolean)this.dataView.getDataCommunicator().isDefinedSize());
        this.dataView.setItemCountFromDataProvider();
        Assert.assertTrue((boolean)this.dataView.getDataCommunicator().isDefinedSize());
        this.dataView.setItemCountEstimate(500);
        Assert.assertFalse((boolean)this.dataView.getDataCommunicator().isDefinedSize());
        this.dataView.setItemCountFromDataProvider();
        Assert.assertTrue((boolean)this.dataView.getDataCommunicator().isDefinedSize());
        this.dataView.setItemCountEstimateIncrease(200);
        Assert.assertFalse((boolean)this.dataView.getDataCommunicator().isDefinedSize());
    }

    @Test
    public void dataViewCreated_beforeSettingDataProvider_verificationPassed() {
        new AbstractLazyDataView<String>(new DataCommunicator((DataGenerator & Serializable)(item, jsonObject) -> {}, null, null, this.component.getElement().getNode()), this.component){};
    }

    @Test
    public void addItemCountListener_beforeSettingDataProvider_verificationPassed() {
        AbstractLazyDataView<String> dataView = new AbstractLazyDataView<String>(new DataCommunicator((DataGenerator & Serializable)(item, jsonObject) -> {}, null, null, this.component.getElement().getNode()), this.component){};
        dataView.addItemCountChangeListener((ComponentEventListener & Serializable)event -> {});
    }

    @Test(expected=IllegalStateException.class)
    public void dataViewAPIUsed_beforeSettingDataProvider_throws() {
        AbstractLazyDataView<String> dataView = new AbstractLazyDataView<String>(new DataCommunicator((DataGenerator & Serializable)(item, jsonObject) -> {}, null, null, this.component.getElement().getNode()), this.component){};
        dataView.setItemCountUnknown();
    }

    @Test(expected=IllegalStateException.class)
    public void existingDataView_dataProviderIsChangedToInMemory_throws() {
        this.dataCommunicator.setDataProvider(this.badProvider, null);
        this.dataView.setItemCountUnknown();
    }

    @Test
    public void itemCount_definedItemCount() {
        AtomicInteger itemCount = new AtomicInteger(0);
        this.dataView.addItemCountChangeListener((ComponentEventListener & Serializable)event -> itemCount.set(event.getItemCount()));
        this.dataCommunicator.setViewportRange(0, 50);
        Assert.assertEquals((String)"Invalid item count reported", (long)0L, (long)itemCount.get());
        this.fakeClientCommunication();
        Assert.assertEquals((String)"Invalid item count reported", (long)3L, (long)itemCount.get());
    }

    @Test
    public void itemCount_undefinedItemCount() {
        AtomicInteger itemCount = new AtomicInteger(0);
        this.dataView.addItemCountChangeListener((ComponentEventListener & Serializable)event -> itemCount.set(event.getItemCount()));
        this.dataCommunicator.setViewportRange(0, 50);
        this.dataView.setItemCountUnknown();
        Assert.assertEquals((String)"Invalid item count reported", (long)0L, (long)itemCount.get());
        this.fakeClientCommunication();
        Assert.assertEquals((String)"Invalid item count reported", (long)3L, (long)itemCount.get());
        this.dataView.setItemCountEstimate(500);
        Assert.assertEquals((String)"Invalid item count reported", (long)3L, (long)itemCount.get());
        this.fakeClientCommunication();
        Assert.assertEquals((String)"Invalid item count reported", (long)3L, (long)itemCount.get());
        this.dataCommunicator.setDataProvider((DataProvider)DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> {
            query.getOffset();
            return Stream.generate(String::new).limit(query.getLimit());
        }, (CallbackDataProvider.CountCallback & Serializable)query -> 2), null);
        Assert.assertEquals((String)"Invalid item count reported", (long)3L, (long)itemCount.get());
        this.fakeClientCommunication();
        Assert.assertEquals((String)"Invalid item count reported", (long)2L, (long)itemCount.get());
        this.dataView.setItemCountEstimate(300);
        Assert.assertEquals((String)"Invalid item count reported", (long)2L, (long)itemCount.get());
        this.fakeClientCommunication();
        Assert.assertEquals((String)"Invalid item count reported", (long)300L, (long)itemCount.get());
    }

    @Test
    public void getItems_withDefinedSize() {
        this.dataCommunicator.setViewportRange(0, 50);
        this.dataCommunicator.setDataProvider((DataProvider)DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> {
            query.getOffset();
            query.getLimit();
            return Stream.generate(String::new).limit(99L);
        }, (CallbackDataProvider.CountCallback & Serializable)query -> 99), null);
        Stream items = this.dataView.getItems();
        Assert.assertEquals((String)"Invalid amount of items returned", (long)99L, (long)items.count());
    }

    @Test
    public void getItems_withUndefinedSize() {
        this.dataCommunicator.setViewportRange(0, 50);
        AtomicInteger limit = new AtomicInteger(50);
        this.dataCommunicator.setDataProvider((DataProvider)DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> {
            query.getOffset();
            query.getLimit();
            return Stream.generate(String::new).limit(limit.get());
        }, (CallbackDataProvider.CountCallback & Serializable)query -> -1), null);
        int itemCountEstimate = 66;
        this.dataCommunicator.setItemCountEstimate(66);
        this.fakeClientCommunication();
        Assert.assertEquals((long)(66 + this.dataCommunicator.getItemCountEstimateIncrease()), (long)this.dataCommunicator.getItemCount());
        limit.set(70);
        Stream items = this.dataView.getItems();
        Assert.assertEquals((String)"Invalid amount of items returned", (long)limit.get(), (long)items.count());
    }

    @Test
    public void getItem_correctIndex_itemObtained() {
        this.dataCommunicator.setViewportRange(0, 50);
        this.dataCommunicator.setDataProvider((DataProvider)DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> {
            query.getOffset();
            query.getLimit();
            return Stream.of(ITEM1, "bar", "baz");
        }, (CallbackDataProvider.CountCallback & Serializable)query -> 3), null);
        this.fakeClientCommunication();
        Assert.assertEquals((String)"Invalid item on index 1", (Object)"bar", (Object)this.dataView.getItem(1));
    }

    @Test
    public void getItem_negativeIndex_throws() {
        this.exceptionRule.expect(IndexOutOfBoundsException.class);
        this.exceptionRule.expectMessage("Index must be non-negative");
        this.dataCommunicator.setViewportRange(0, 50);
        this.dataCommunicator.setDataProvider((DataProvider)DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> {
            query.getOffset();
            query.getLimit();
            return Stream.of(ITEM1, "bar", "baz");
        }, (CallbackDataProvider.CountCallback & Serializable)query -> 3), null);
        this.fakeClientCommunication();
        this.dataView.getItem(-1);
    }

    @Test
    public void getItem_emptyData_throws() {
        this.exceptionRule.expect(IndexOutOfBoundsException.class);
        this.exceptionRule.expectMessage("Requested index 0 on empty data.");
        this.dataCommunicator.setViewportRange(0, 50);
        this.dataCommunicator.setDataProvider((DataProvider)DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> {
            query.getOffset();
            query.getLimit();
            return Stream.empty();
        }, (CallbackDataProvider.CountCallback & Serializable)query -> 0), null);
        this.fakeClientCommunication();
        this.dataView.getItem(0);
    }

    @Test
    public void getItem_outsideOfRange_throws() {
        this.exceptionRule.expect(IndexOutOfBoundsException.class);
        this.exceptionRule.expectMessage("Given index 3 is outside of the accepted range '0 - 2'");
        this.dataCommunicator.setViewportRange(0, 50);
        this.dataCommunicator.setDataProvider((DataProvider)DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> {
            query.getOffset();
            query.getLimit();
            return Stream.of(ITEM1, "bar", "baz");
        }, (CallbackDataProvider.CountCallback & Serializable)query -> 3), null);
        this.fakeClientCommunication();
        this.dataView.getItem(3);
    }

    @Test
    public void getItemIndex_withoutItemIndexProvider_throwUnsupportedOperationException() {
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.dataView.getItemIndex((Object)"bar"));
    }

    @Test
    public void getItemIndex_itemPresentedInDataSet_indexFound() {
        this.dataView.setItemIndexProvider((ItemIndexProvider & Serializable)(item, query) -> "bar".equals(item) ? Integer.valueOf(1) : null);
        Assert.assertEquals((String)"Wrong index returned for item", Optional.of(1), (Object)this.dataView.getItemIndex((Object)"bar"));
    }

    @Test
    public void getItemIndex_itemNotPresentedInDataSet_indexNotFound() {
        this.dataView.setItemIndexProvider((ItemIndexProvider & Serializable)(item, query) -> "bar".equals(item) ? Integer.valueOf(1) : null);
        Assert.assertEquals((String)"Wrong index returned for item", Optional.empty(), (Object)this.dataView.getItemIndex((Object)"notPresent"));
    }

    @Test
    public void refreshItem_itemPresentInDataSet_refreshesItem() {
        Item item1 = new Item(0L, "value1");
        Item item2 = new Item(1L, "value2");
        DataProvider dataProvider = (DataProvider)Mockito.spy((Object)DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> {
            query.getOffset();
            query.getLimit();
            return Stream.of(item1, item2);
        }, (CallbackDataProvider.CountCallback & Serializable)query -> 2));
        DataCommunicator dataCommunicator = (DataCommunicator)Mockito.spy((Object)new DataCommunicator((DataGenerator & Serializable)(item, jsonObject) -> {}, this.arrayUpdater, null, this.component.getElement().getNode()));
        dataCommunicator.setDataProvider(dataProvider, null);
        AbstractLazyDataView<Item> dataView = new AbstractLazyDataView<Item>(dataCommunicator, this.component){};
        item1.setValue("updatedValue1");
        dataView.refreshItem((Object)item1);
        ((DataProvider)Mockito.verify((Object)dataProvider)).refreshItem((Object)item1);
        ((DataCommunicator)Mockito.verify((Object)dataCommunicator)).refresh((Object)item1);
        dataView.setIdentifierProvider(Item::getId);
        Item updatedItem2 = new Item(1L, "updatedValue2");
        dataView.refreshItem((Object)updatedItem2);
        ((DataProvider)Mockito.verify((Object)dataProvider, (VerificationMode)Mockito.times((int)0))).refreshItem((Object)item2);
        ((DataCommunicator)Mockito.verify((Object)dataCommunicator, (VerificationMode)Mockito.times((int)0))).refresh((Object)item2);
        ((DataProvider)Mockito.verify((Object)dataProvider)).refreshItem((Object)updatedItem2);
        ((DataCommunicator)Mockito.verify((Object)dataCommunicator)).refresh((Object)updatedItem2);
    }

    @Test
    public void refreshItem_itemNotPresent_itemNotRefreshed() {
        Item item1 = new Item(0L, "value1");
        DataProvider dataProvider = (DataProvider)Mockito.spy((Object)DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> {
            query.getOffset();
            query.getLimit();
            return Stream.of(item1);
        }, (CallbackDataProvider.CountCallback & Serializable)query -> 1));
        DataCommunicator dataCommunicator = (DataCommunicator)Mockito.spy((Object)new DataCommunicator((DataGenerator & Serializable)(item, jsonObject) -> {}, this.arrayUpdater, null, this.component.getElement().getNode()));
        dataCommunicator.setDataProvider(dataProvider, null);
        AbstractLazyDataView<Item> dataView = new AbstractLazyDataView<Item>(dataCommunicator, this.component){};
        Item item2 = new Item(1L, "value1");
        dataView.refreshItem((Object)item1);
        ((DataProvider)Mockito.verify((Object)dataProvider, (VerificationMode)Mockito.times((int)0))).refreshItem((Object)item2);
        ((DataCommunicator)Mockito.verify((Object)dataCommunicator, (VerificationMode)Mockito.times((int)0))).refresh((Object)item2);
    }

    @Test
    public void paged_access_methods_in_query_object() {
        Query query = new Query(0, 20, null, null, null);
        Assert.assertEquals((long)0L, (long)query.getPage());
        Assert.assertEquals((long)20L, (long)query.getPageSize());
        query = new Query(20, 20, null, null, null);
        Assert.assertEquals((long)1L, (long)query.getPage());
        Assert.assertEquals((long)20L, (long)query.getPageSize());
        query = new Query(200, 40, null, null, null);
        Assert.assertEquals((long)5L, (long)query.getPage());
        Assert.assertEquals((long)40L, (long)query.getPageSize());
    }

    @Test
    public void getItems_withOffsetAndLimit_correctQuery() {
        this.dataCommunicator.setViewportRange(0, 50);
        this.dataCommunicator.setDataProvider((DataProvider)DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> {
            Assert.assertEquals((String)"Invalid offset", (long)10L, (long)query.getOffset());
            Assert.assertEquals((String)"Invalid limit", (long)20L, (long)query.getLimit());
            return Stream.of(ITEM1, "bar");
        }, (CallbackDataProvider.CountCallback & Serializable)query -> 100), null);
        Stream items = this.dataView.getItems(10, 20);
        Assert.assertEquals((long)2L, (long)items.count());
    }

    @Test
    public void getItems_withOffsetAndLimit_definedSize_limitAdjusted() {
        this.dataCommunicator.setViewportRange(0, 50);
        AtomicInteger fetchCount = new AtomicInteger(0);
        this.dataCommunicator.setDataProvider((DataProvider)DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> {
            if (query.getOffset() == 90) {
                Assert.assertEquals((String)"Invalid limit", (long)10L, (long)query.getLimit());
                fetchCount.incrementAndGet();
                return Stream.of(ITEM1);
            }
            query.getLimit();
            query.getOffset();
            return Stream.generate(() -> "dummy").limit(query.getLimit());
        }, (CallbackDataProvider.CountCallback & Serializable)query -> 100), null);
        this.fakeClientCommunication();
        Stream items = this.dataView.getItems(90, 20);
        Assert.assertEquals((long)1L, (long)items.count());
        Assert.assertEquals((long)1L, (long)fetchCount.get());
    }

    @Test
    public void getItems_withOffsetAndLimit_outOfBounds_emptyStream() {
        this.dataCommunicator.setViewportRange(0, 50);
        this.dataCommunicator.setDataProvider((DataProvider)DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> {
            query.getOffset();
            query.getLimit();
            if (query.getOffset() >= 100) {
                return Stream.empty();
            }
            return Stream.generate(() -> "dummy").limit(query.getLimit());
        }, (CallbackDataProvider.CountCallback & Serializable)query -> 100), null);
        this.fakeClientCommunication();
        Stream items = this.dataView.getItems(110, 20);
        Assert.assertEquals((long)0L, (long)items.count());
    }

    private void fakeClientCommunication() {
        this.ui.getInternals().getStateTree().runExecutionsBeforeClientResponse();
        this.ui.getInternals().getStateTree().collectChanges(ignore -> {});
    }

    @Test
    public void getItems_withNegativeOffset_throwsException() {
        IndexOutOfBoundsException exception = (IndexOutOfBoundsException)Assert.assertThrows(IndexOutOfBoundsException.class, () -> this.dataView.getItems(-1, 10));
        Assert.assertEquals((Object)"Offset must be non-negative", (Object)exception.getMessage());
    }

    @Test
    public void getItems_withNegativeLimit_throwsException() {
        IndexOutOfBoundsException exception = (IndexOutOfBoundsException)Assert.assertThrows(IndexOutOfBoundsException.class, () -> this.dataView.getItems(0, -1));
        Assert.assertEquals((Object)"Limit must be non-negative", (Object)exception.getMessage());
    }

    @Tag(value="test-component")
    private static class TestComponent
    extends Component {
        private TestComponent() {
        }
    }
}

