/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider.hierarchy;

import com.vaadin.flow.data.provider.CompositeDataGenerator;
import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.data.provider.QuerySortOrderBuilder;
import com.vaadin.flow.data.provider.hierarchy.AbstractHierarchicalDataCommunicatorTest;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalDataCommunicator;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalDataProvider;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalQuery;
import com.vaadin.flow.data.provider.hierarchy.TreeData;
import com.vaadin.flow.data.provider.hierarchy.TreeDataProvider;
import com.vaadin.flow.function.SerializableComparator;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.SerializableSupplier;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class HierarchicalDataCommunicatorFlatHierarchyTest
extends AbstractHierarchicalDataCommunicatorTest {
    private TreeData<AbstractHierarchicalDataCommunicatorTest.Item> treeData = new TreeData();
    private TreeDataProvider<AbstractHierarchicalDataCommunicatorTest.Item> dataProvider = new TreeDataProvider(this.treeData, HierarchicalDataProvider.HierarchyFormat.FLATTENED);
    private HierarchicalDataCommunicator<AbstractHierarchicalDataCommunicatorTest.Item> dataCommunicator;

    @Override
    @Before
    public void init() {
        super.init();
        CompositeDataGenerator compositeDataGenerator = new CompositeDataGenerator();
        compositeDataGenerator.addDataGenerator((DataGenerator & Serializable)(item, json) -> {
            json.put("name", item.getName());
            json.put("state", item.getState());
        });
        this.dataCommunicator = new HierarchicalDataCommunicator(compositeDataGenerator, this.arrayUpdater, this.ui.getElement().getNode(), (SerializableSupplier & Serializable)() -> null);
        this.dataCommunicator.setDataProvider(this.dataProvider, null);
        this.populateTreeData(this.treeData, 100, 2, 2);
    }

    @Test
    public void setViewportRange_requestedRangeSent() {
        this.dataCommunicator.expand(Arrays.asList(new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 99")));
        this.dataCommunicator.setViewportRange(0, 6);
        this.fakeClientCommunication();
        this.assertArrayUpdateSize(106);
        this.assertArrayUpdateRange(0, 6);
        this.assertArrayUpdateItems("name", Map.of(0, "Item 0", 1, "Item 0-0", 2, "Item 0-0-0", 3, "Item 0-0-1", 4, "Item 0-1", 5, "Item 1"));
        Mockito.clearInvocations((Object[])new Serializable[]{this.arrayUpdater, this.arrayUpdate});
        this.dataCommunicator.setViewportRange(100, 8);
        this.fakeClientCommunication();
        this.assertArrayUpdateSize(106);
        this.assertArrayUpdateRange(100, 6);
        this.assertArrayUpdateItems("name", Map.of(100, "Item 96", 101, "Item 97", 102, "Item 98", 103, "Item 99", 104, "Item 99-0", 105, "Item 99-1"));
    }

    @Test
    public void toggleItems_updatedRangeSent() {
        this.dataCommunicator.setViewportRange(10, 4);
        this.fakeClientCommunication();
        this.assertArrayUpdateSize(100);
        this.assertArrayUpdateRange(10, 4);
        this.assertArrayUpdateItems("name", Map.of(10, "Item 10", 11, "Item 11", 12, "Item 12", 13, "Item 13"));
        Mockito.clearInvocations((Object[])new Serializable[]{this.arrayUpdater, this.arrayUpdate});
        this.dataCommunicator.expand((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 10"));
        this.fakeClientCommunication();
        this.assertArrayUpdateSize(102);
        this.assertArrayUpdateRange(10, 4);
        this.assertArrayUpdateItems("name", Map.of(10, "Item 10", 11, "Item 10-0", 12, "Item 10-1", 13, "Item 11"));
        Mockito.clearInvocations((Object[])new Serializable[]{this.arrayUpdater, this.arrayUpdate});
        this.dataCommunicator.collapse((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 10"));
        this.fakeClientCommunication();
        this.assertArrayUpdateSize(100);
        this.assertArrayUpdateRange(10, 4);
        this.assertArrayUpdateItems("name", Map.of(10, "Item 10", 11, "Item 11", 12, "Item 12", 13, "Item 13"));
    }

    @Test
    public void refreshItem_updatedRangeSent() {
        this.dataCommunicator.setViewportRange(0, 4);
        this.fakeClientCommunication();
        this.assertArrayUpdateItems("state", Map.of(0, "initial", 1, "initial", 2, "initial", 3, "initial"));
        Mockito.clearInvocations((Object[])new Serializable[]{this.arrayUpdater, this.arrayUpdate});
        this.dataCommunicator.refresh((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0", "refreshed"));
        this.fakeClientCommunication();
        this.assertArrayUpdateItems("state", Map.of(0, "refreshed"));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void refreshItemWithChildren_throws() {
        this.dataCommunicator.refresh((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0", "refreshed"), true);
    }

    @Test
    public void reset_updatedRangeSent() {
        this.dataCommunicator.expand(Arrays.asList(new AbstractHierarchicalDataCommunicatorTest.Item("Item 1"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 1-0")));
        this.dataCommunicator.setViewportRange(0, 5);
        this.fakeClientCommunication();
        this.assertArrayUpdateItems("name", Map.of(0, "Item 0", 1, "Item 1", 2, "Item 1-0", 3, "Item 1-0-0", 4, "Item 1-0-1"));
        Mockito.clearInvocations((Object[])new Serializable[]{this.arrayUpdater, this.arrayUpdate});
        this.treeData.removeItem((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"));
        this.treeData.removeItem((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 1-0"));
        this.dataCommunicator.reset();
        this.fakeClientCommunication();
        this.assertArrayUpdateItems("name", Map.of(0, "Item 1", 1, "Item 1-1", 2, "Item 2", 3, "Item 3", 4, "Item 4"));
    }

    @Test
    public void resolveIndexPath_correctIndexReturned() {
        this.dataCommunicator.expand(Arrays.asList(new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0")));
        Assert.assertEquals((long)0L, (long)this.dataCommunicator.resolveIndexPath(new int[]{0}));
        Assert.assertEquals((long)104L, (long)this.dataCommunicator.rootCache.getFlatSize());
        Assert.assertEquals((long)50L, (long)this.dataCommunicator.resolveIndexPath(new int[]{50}));
        Assert.assertEquals((long)104L, (long)this.dataCommunicator.rootCache.getFlatSize());
        Assert.assertEquals((long)54L, (long)this.dataCommunicator.resolveIndexPath(new int[]{-50}));
        Assert.assertEquals((long)104L, (long)this.dataCommunicator.rootCache.getFlatSize());
        Assert.assertEquals((long)0L, (long)this.dataCommunicator.resolveIndexPath(new int[]{-104}));
        Assert.assertEquals((long)104L, (long)this.dataCommunicator.rootCache.getFlatSize());
    }

    @Test
    public void invalidIndexPath_resolveIndexPath_correctIndexReturned() {
        this.dataCommunicator.expand(Arrays.asList(new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0")));
        Assert.assertEquals((long)2L, (long)this.dataCommunicator.resolveIndexPath(new int[]{2, 2, 2}));
        Assert.assertEquals((long)104L, (long)this.dataCommunicator.rootCache.getFlatSize());
        Assert.assertEquals((long)103L, (long)this.dataCommunicator.resolveIndexPath(new int[]{1000}));
        Assert.assertEquals((long)104L, (long)this.dataCommunicator.rootCache.getFlatSize());
        Assert.assertEquals((long)0L, (long)this.dataCommunicator.resolveIndexPath(new int[]{-1000}));
        Assert.assertEquals((long)104L, (long)this.dataCommunicator.rootCache.getFlatSize());
    }

    @Test
    public void buildQuery_correctQueryReturned() {
        List sortOrders = new QuerySortOrderBuilder().thenDesc("name").build();
        SerializablePredicate & Serializable filter = (SerializablePredicate & Serializable)f -> true;
        SerializableComparator & Serializable comparator = Comparator.comparing(AbstractHierarchicalDataCommunicatorTest.Item::getName).reversed()::compare;
        this.dataCommunicator.setDataProvider(this.dataProvider, (Object)filter);
        this.dataCommunicator.setInMemorySorting((SerializableComparator)comparator);
        this.dataCommunicator.setBackEndSorting(sortOrders);
        this.dataCommunicator.expand((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"));
        HierarchicalQuery query = this.dataCommunicator.buildQuery(10, 20);
        Assert.assertNull((Object)query.getParent());
        Assert.assertEquals((long)10L, (long)query.getOffset());
        Assert.assertEquals((long)20L, (long)query.getLimit());
        Assert.assertEquals((Object)filter, query.getFilter().get());
        Assert.assertEquals((Object)sortOrders, (Object)query.getSortOrders());
        Assert.assertEquals((Object)comparator, (Object)query.getInMemorySorting());
        Assert.assertEquals(Set.of(new AbstractHierarchicalDataCommunicatorTest.Item("Item 0")), (Object)query.getExpandedItemIds());
        query = this.dataCommunicator.buildQuery((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"), 10, 20);
        Assert.assertEquals((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"), (Object)query.getParent());
        Assert.assertEquals((long)10L, (long)query.getOffset());
        Assert.assertEquals((long)20L, (long)query.getLimit());
        Assert.assertEquals((Object)filter, query.getFilter().get());
        Assert.assertEquals((Object)sortOrders, (Object)query.getSortOrders());
        Assert.assertEquals((Object)comparator, (Object)query.getInMemorySorting());
        Assert.assertEquals(Set.of(new AbstractHierarchicalDataCommunicatorTest.Item("Item 0")), (Object)query.getExpandedItemIds());
    }
}

