/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider.hierarchy;

import com.vaadin.flow.data.provider.CompositeDataGenerator;
import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.data.provider.hierarchy.AbstractHierarchicalDataCommunicatorTest;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalDataCommunicator;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalDataProvider;
import com.vaadin.flow.data.provider.hierarchy.TreeData;
import com.vaadin.flow.data.provider.hierarchy.TreeDataProvider;
import com.vaadin.flow.function.SerializableSupplier;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class HierarchicalDataCommunicatorIndexPathResolutionTest
extends AbstractHierarchicalDataCommunicatorTest {
    private HierarchicalDataCommunicator<AbstractHierarchicalDataCommunicatorTest.Item> dataCommunicator;

    @Override
    @Before
    public void init() {
        super.init();
        TreeData treeData = new TreeData();
        this.populateTreeData((TreeData<AbstractHierarchicalDataCommunicatorTest.Item>)treeData, 3, 2, 1);
        CompositeDataGenerator dataGenerator = new CompositeDataGenerator();
        dataGenerator.addDataGenerator((DataGenerator & Serializable)(item, json) -> json.put("name", item.getName()));
        this.dataCommunicator = new HierarchicalDataCommunicator(dataGenerator, this.arrayUpdater, this.ui.getElement().getNode(), (SerializableSupplier & Serializable)() -> null);
        this.dataCommunicator.setDataProvider((HierarchicalDataProvider)new TreeDataProvider(treeData), null);
    }

    @Test
    public void positiveIndexes_resolveIndexPath_correctFlatIndexReturned() {
        this.dataCommunicator.expand(Arrays.asList(new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 1"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 1-1")));
        Assert.assertEquals((long)0L, (long)this.dataCommunicator.resolveIndexPath(new int[]{0}));
        Assert.assertEquals((long)3L, (long)this.dataCommunicator.rootCache.getFlatSize());
        Assert.assertEquals((long)1L, (long)this.dataCommunicator.resolveIndexPath(new int[]{0, 0}));
        Assert.assertEquals((long)5L, (long)this.dataCommunicator.rootCache.getFlatSize());
        Assert.assertEquals((long)3L, (long)this.dataCommunicator.resolveIndexPath(new int[]{1}));
        Assert.assertEquals((long)5L, (long)this.dataCommunicator.rootCache.getFlatSize());
        Assert.assertEquals((long)4L, (long)this.dataCommunicator.resolveIndexPath(new int[]{1, 0}));
        Assert.assertEquals((long)7L, (long)this.dataCommunicator.rootCache.getFlatSize());
        Assert.assertEquals((long)5L, (long)this.dataCommunicator.resolveIndexPath(new int[]{1, 1}));
        Assert.assertEquals((long)7L, (long)this.dataCommunicator.rootCache.getFlatSize());
        Assert.assertEquals((long)6L, (long)this.dataCommunicator.resolveIndexPath(new int[]{1, 1, 0}));
        Assert.assertEquals((long)8L, (long)this.dataCommunicator.rootCache.getFlatSize());
        Assert.assertEquals((long)7L, (long)this.dataCommunicator.resolveIndexPath(new int[]{2}));
        Assert.assertEquals((long)8L, (long)this.dataCommunicator.rootCache.getFlatSize());
    }

    @Test
    public void negativeIndexes_resolveIndexPath_correctFlatIndexReturned() {
        this.dataCommunicator.expand(Arrays.asList(new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 1"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 1-1")));
        Assert.assertEquals((long)0L, (long)this.dataCommunicator.resolveIndexPath(new int[]{-3}));
        Assert.assertEquals((long)3L, (long)this.dataCommunicator.rootCache.getFlatSize());
        Assert.assertEquals((long)1L, (long)this.dataCommunicator.resolveIndexPath(new int[]{-3, -2}));
        Assert.assertEquals((long)5L, (long)this.dataCommunicator.rootCache.getFlatSize());
        Assert.assertEquals((long)3L, (long)this.dataCommunicator.resolveIndexPath(new int[]{-2}));
        Assert.assertEquals((long)5L, (long)this.dataCommunicator.rootCache.getFlatSize());
        Assert.assertEquals((long)4L, (long)this.dataCommunicator.resolveIndexPath(new int[]{-2, -2}));
        Assert.assertEquals((long)7L, (long)this.dataCommunicator.rootCache.getFlatSize());
        Assert.assertEquals((long)5L, (long)this.dataCommunicator.resolveIndexPath(new int[]{-2, -1}));
        Assert.assertEquals((long)7L, (long)this.dataCommunicator.rootCache.getFlatSize());
        Assert.assertEquals((long)6L, (long)this.dataCommunicator.resolveIndexPath(new int[]{-2, -1, -1}));
        Assert.assertEquals((long)8L, (long)this.dataCommunicator.rootCache.getFlatSize());
        Assert.assertEquals((long)7L, (long)this.dataCommunicator.resolveIndexPath(new int[]{-1}));
        Assert.assertEquals((long)8L, (long)this.dataCommunicator.rootCache.getFlatSize());
    }

    @Test
    public void exceedingPositiveIndexes_resolveIndexPath_indexesClamped() {
        this.dataCommunicator.expand(Arrays.asList(new AbstractHierarchicalDataCommunicatorTest.Item("Item 2"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 2-1")));
        Assert.assertEquals((long)2L, (long)this.dataCommunicator.resolveIndexPath(new int[]{100}));
        Assert.assertEquals((long)3L, (long)this.dataCommunicator.rootCache.getFlatSize());
        Assert.assertEquals((long)4L, (long)this.dataCommunicator.resolveIndexPath(new int[]{100, 100}));
        Assert.assertEquals((long)5L, (long)this.dataCommunicator.rootCache.getFlatSize());
        Assert.assertEquals((long)5L, (long)this.dataCommunicator.resolveIndexPath(new int[]{100, 100, 100}));
        Assert.assertEquals((long)6L, (long)this.dataCommunicator.rootCache.getFlatSize());
        Assert.assertEquals((long)5L, (long)this.dataCommunicator.resolveIndexPath(new int[]{100, 100, 100, 100}));
        Assert.assertEquals((long)6L, (long)this.dataCommunicator.rootCache.getFlatSize());
    }

    @Test
    public void exceedingNegativeIndexes_resolveIndexPath_indexesClamped() {
        this.dataCommunicator.expand(Arrays.asList(new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0")));
        Assert.assertEquals((long)0L, (long)this.dataCommunicator.resolveIndexPath(new int[]{-100}));
        Assert.assertEquals((long)3L, (long)this.dataCommunicator.rootCache.getFlatSize());
        Assert.assertEquals((long)1L, (long)this.dataCommunicator.resolveIndexPath(new int[]{-100, -100}));
        Assert.assertEquals((long)5L, (long)this.dataCommunicator.rootCache.getFlatSize());
        Assert.assertEquals((long)2L, (long)this.dataCommunicator.resolveIndexPath(new int[]{-100, -100, -100}));
        Assert.assertEquals((long)6L, (long)this.dataCommunicator.rootCache.getFlatSize());
        Assert.assertEquals((long)2L, (long)this.dataCommunicator.resolveIndexPath(new int[]{-100, -100, -100, -100}));
        Assert.assertEquals((long)6L, (long)this.dataCommunicator.rootCache.getFlatSize());
    }

    @Test
    public void setViewportRange_resolveIndexPage_entireRangeSentWhenSizeChanged() {
        this.dataCommunicator.expand((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"));
        this.dataCommunicator.setViewportRange(2, 1);
        this.fakeClientCommunication();
        this.assertArrayUpdateSize(3);
        this.assertArrayUpdateRange(2, 1);
        this.assertArrayUpdateItems("name", Map.of(2, "Item 2"));
        Mockito.clearInvocations((Object[])new Serializable[]{this.arrayUpdater, this.arrayUpdate});
        this.dataCommunicator.resolveIndexPath(new int[]{0});
        this.fakeClientCommunication();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.arrayUpdater, this.arrayUpdate});
        this.dataCommunicator.resolveIndexPath(new int[]{0, 0});
        this.fakeClientCommunication();
        this.assertArrayUpdateSize(5);
        this.assertArrayUpdateRange(2, 1);
        this.assertArrayUpdateItems("name", Map.of(2, "Item 0-1"));
    }
}

