/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.converter;

import com.vaadin.flow.data.binder.Result;
import com.vaadin.flow.data.converter.BigDecimalToIntegerConverter;
import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Test;

public class BigDecimalToIntegerConverterTest {
    BigDecimalToIntegerConverter converter = new BigDecimalToIntegerConverter();

    @Test
    public void testNullConversionToModel() {
        Assert.assertEquals((Object)Result.ok(null), (Object)this.converter.convertToModel(null, null));
    }

    @Test
    public void testNullConversionToPresentation() {
        Assert.assertNull((Object)this.converter.convertToPresentation(null, null));
    }

    @Test
    public void testConvertToModel() {
        Result result = this.converter.convertToModel(BigDecimal.valueOf(42L), null);
        Assert.assertEquals((Object)Result.ok((Object)42), (Object)result);
    }

    @Test
    public void testConvertToPresentation() {
        BigDecimal value = this.converter.convertToPresentation(Integer.valueOf(42), null);
        Assert.assertEquals((Object)BigDecimal.valueOf(42L), (Object)value);
    }

    @Test
    public void testConvertToModelWithDecimalValue() {
        Result result = this.converter.convertToModel(BigDecimal.valueOf(42.99), null);
        Assert.assertEquals((Object)Result.ok((Object)42), (Object)result);
    }

    @Test
    public void testConvertToPresentationWithDecimalValue() {
        BigDecimal value = this.converter.convertToPresentation(Integer.valueOf(42), null);
        Assert.assertEquals((Object)BigDecimal.valueOf(42L), (Object)value);
    }
}

