/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider.hierarchy;

import com.vaadin.flow.data.provider.CompositeDataGenerator;
import com.vaadin.flow.data.provider.hierarchy.AbstractHierarchicalDataCommunicatorTest;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalDataCommunicator;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalDataProvider;
import com.vaadin.flow.data.provider.hierarchy.TreeData;
import com.vaadin.flow.data.provider.hierarchy.TreeDataProvider;
import com.vaadin.flow.function.SerializableSupplier;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HierarchicalDataCommunicatorDataPreloadingTest
extends AbstractHierarchicalDataCommunicatorTest {
    private HierarchicalDataCommunicator<AbstractHierarchicalDataCommunicatorTest.Item> dataCommunicator;

    @Override
    @Before
    public void init() {
        super.init();
        TreeData treeData = new TreeData();
        this.populateTreeData((TreeData<AbstractHierarchicalDataCommunicatorTest.Item>)treeData, 20, 2, 2);
        this.dataCommunicator = new HierarchicalDataCommunicator(new CompositeDataGenerator(), this.arrayUpdater, this.ui.getElement().getNode(), (SerializableSupplier & Serializable)() -> null);
        this.dataCommunicator.setDataProvider((HierarchicalDataProvider)new TreeDataProvider(treeData), null);
    }

    @Test
    public void preloadFlatRangeForward_nearStart_requestedRangeReturned() {
        this.dataCommunicator.expand(Arrays.asList(new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 2"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 2-0"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 1-0"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 9")));
        List items = this.dataCommunicator.preloadFlatRangeForward(0, 10);
        this.assertPreloadedRange("Item 0, Item 0-0, Item 0-1, Item 1, Item 2, Item 2-0, Item 2-0-0, Item 2-0-1, Item 2-1, Item 3", items);
        Assert.assertEquals((long)26L, (long)this.dataCommunicator.rootCache.getFlatSize());
    }

    @Test
    public void preloadFlatRangeForward_nearMiddle_requestedRangeReturned() {
        this.dataCommunicator.expand(Arrays.asList(new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 9"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 19")));
        List items = this.dataCommunicator.preloadFlatRangeForward(9, 6);
        this.assertPreloadedRange("Item 9, Item 9-0, Item 9-1, Item 10, Item 11, Item 12", items);
        Assert.assertEquals((long)22L, (long)this.dataCommunicator.rootCache.getFlatSize());
    }

    @Test
    public void preloadFlatRangeForward_nearEnd_requestedRangeReturned() {
        this.dataCommunicator.expand(Arrays.asList(new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 9"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 19"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 19-1")));
        List items = this.dataCommunicator.preloadFlatRangeForward(18, 6);
        this.assertPreloadedRange("Item 18, Item 19, Item 19-0, Item 19-1, Item 19-1-0, Item 19-1-1", items);
        Assert.assertEquals((long)24L, (long)this.dataCommunicator.rootCache.getFlatSize());
    }

    @Test
    public void preloadFlatRangeForward_rangeEndOutOfBounds_availableRangeReturned() {
        this.dataCommunicator.expand(Arrays.asList(new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 9"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 19")));
        List items = this.dataCommunicator.preloadFlatRangeForward(19, 10);
        this.assertPreloadedRange("Item 19, Item 19-0, Item 19-1", items);
        Assert.assertEquals((long)22L, (long)this.dataCommunicator.rootCache.getFlatSize());
    }

    @Test
    public void preloadFlatRangeForward_rangeStartOutOfBounds_emptyRangeReturned() {
        this.dataCommunicator.expand(Arrays.asList(new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 9"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 19")));
        List items = this.dataCommunicator.preloadFlatRangeForward(100, 10);
        Assert.assertEquals((long)0L, (long)items.size());
        Assert.assertEquals((long)20L, (long)this.dataCommunicator.rootCache.getFlatSize());
    }

    @Test
    public void preloadFlatRangeBackward_nearEnd_requestedRangeReturned() {
        this.dataCommunicator.expand(Arrays.asList(new AbstractHierarchicalDataCommunicatorTest.Item("Item 19"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 18"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 18-1"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 17-1"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 16"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 9")));
        List items = this.dataCommunicator.preloadFlatRangeBackward(19, 10);
        this.assertPreloadedRange("Item 16, Item 16-0, Item 16-1, Item 17, Item 18, Item 18-0, Item 18-1, Item 18-1-0, Item 18-1-1, Item 19", items);
        Assert.assertEquals((long)26L, (long)this.dataCommunicator.rootCache.getFlatSize());
    }

    @Test
    public void preloadFlatRangeBackward_nearMiddle_requestedRangeReturned() {
        this.dataCommunicator.expand(Arrays.asList(new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 9"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 12"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 19")));
        List items = this.dataCommunicator.preloadFlatRangeBackward(12, 6);
        this.assertPreloadedRange("Item 9, Item 9-0, Item 9-1, Item 10, Item 11, Item 12", items);
        Assert.assertEquals((long)22L, (long)this.dataCommunicator.rootCache.getFlatSize());
    }

    @Test
    public void preloadFlatRangeBackward_nearStart_requestedRangeReturned() {
        this.dataCommunicator.expand(Arrays.asList(new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-1"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 9"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 19")));
        List items = this.dataCommunicator.preloadFlatRangeBackward(1, 6);
        this.assertPreloadedRange("Item 0, Item 0-0, Item 0-1, Item 0-1-0, Item 0-1-1, Item 1", items);
        Assert.assertEquals((long)24L, (long)this.dataCommunicator.rootCache.getFlatSize());
    }

    @Test
    public void preloadFlatRangeBackward_rangeEndOutOfBounds_availableRangeReturned() {
        this.dataCommunicator.expand(Arrays.asList(new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 9"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 19")));
        List items = this.dataCommunicator.preloadFlatRangeBackward(0, 10);
        this.assertPreloadedRange("Item 0", items);
        Assert.assertEquals((long)20L, (long)this.dataCommunicator.rootCache.getFlatSize());
    }

    @Test
    public void preloadFlatRangeBackward_rangeStartOutOfBounds_emptyRangeReturned() {
        this.dataCommunicator.expand(Arrays.asList(new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 9"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 19")));
        List items = this.dataCommunicator.preloadFlatRangeBackward(-100, 10);
        Assert.assertEquals((long)0L, (long)items.size());
        Assert.assertEquals((long)20L, (long)this.dataCommunicator.rootCache.getFlatSize());
    }

    private void assertPreloadedRange(String expectedItems, List<AbstractHierarchicalDataCommunicatorTest.Item> items) {
        Assert.assertEquals((Object)expectedItems, (Object)items.stream().map(AbstractHierarchicalDataCommunicatorTest.Item::getName).collect(Collectors.joining(", ")));
    }
}

