/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.vaadin.flow.data.provider.AbstractDataProvider;
import com.vaadin.flow.data.provider.InMemoryDataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.function.SerializableComparator;
import com.vaadin.flow.function.SerializablePredicate;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class ListDataProvider<T>
extends AbstractDataProvider<T, SerializablePredicate<T>>
implements InMemoryDataProvider<T> {
    private SerializableComparator<T> sortOrder = null;
    private SerializablePredicate<T> filter;
    private final Collection<T> backend;

    public ListDataProvider(Collection<T> items) {
        Objects.requireNonNull(items, "items cannot be null");
        this.backend = items;
        this.sortOrder = null;
    }

    public Collection<T> getItems() {
        return this.backend;
    }

    @Override
    public Stream<T> fetch(Query<T, SerializablePredicate<T>> query) {
        Stream<T> stream = this.getFilteredStream(query);
        Optional<Comparator> comparing = Stream.of(query.getInMemorySorting(), this.sortOrder).filter(Objects::nonNull).reduce((c1, c2) -> c1.thenComparing(c2));
        if (comparing.isPresent()) {
            stream = stream.sorted(comparing.get());
        }
        return stream.skip(query.getOffset()).limit(query.getLimit());
    }

    @Override
    public int size(Query<T, SerializablePredicate<T>> query) {
        return (int)this.getFilteredStream(query).count();
    }

    private Stream<T> getFilteredStream(Query<T, SerializablePredicate<T>> query) {
        Stream<T> stream = this.backend.stream();
        if (this.filter != null) {
            stream = stream.filter((Predicate<T>)this.filter);
        }
        stream = query.getFilter().map(stream::filter).orElse(stream);
        return stream;
    }

    @Override
    public SerializableComparator<T> getSortComparator() {
        return this.sortOrder;
    }

    @Override
    public void setSortComparator(SerializableComparator<T> comparator) {
        this.sortOrder = comparator;
        this.refreshAll();
    }

    @Override
    public SerializablePredicate<T> getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(SerializablePredicate<T> filter) {
        this.filter = filter;
        this.refreshAll();
    }
}

