/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.selection;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.data.binder.testcomponents.TestLabel;
import com.vaadin.flow.data.selection.MultiSelect;
import com.vaadin.flow.data.selection.MultiSelectionListener;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.shared.Registration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class MultiSelectTest {
    @Test
    public void selectItem_previousItemsAreStillSelected() {
        MultiSelectMock select = new MultiSelectMock("item 1");
        Assert.assertEquals((long)1L, (long)select.getSelectedItems().size());
        Assert.assertArrayEquals((Object[])new Object[]{"item 1"}, (Object[])select.getSelectedItems().toArray());
        Assert.assertTrue((boolean)select.isSelected("item 1"));
        Assert.assertFalse((boolean)select.isSelected("item 2"));
        select.select(new String[]{"item 2"});
        Assert.assertEquals((long)2L, (long)select.getSelectedItems().size());
        Assert.assertArrayEquals((Object[])new Object[]{"item 1", "item 2"}, (Object[])select.getSelectedItems().toArray());
        Assert.assertTrue((boolean)select.isSelected("item 1"));
        Assert.assertTrue((boolean)select.isSelected("item 2"));
        select.select(Arrays.asList("item 3", "item 4"));
        Assert.assertEquals((long)4L, (long)select.getSelectedItems().size());
        Assert.assertArrayEquals((Object[])new Object[]{"item 1", "item 2", "item 3", "item 4"}, (Object[])select.getSelectedItems().toArray());
        Assert.assertTrue((boolean)select.isSelected("item 1"));
        Assert.assertTrue((boolean)select.isSelected("item 2"));
        Assert.assertTrue((boolean)select.isSelected("item 3"));
        Assert.assertTrue((boolean)select.isSelected("item 4"));
    }

    @Test
    public void deselectItem_deselectNonSelectedItem_nothingHappens() {
        MultiSelectMock select = new MultiSelectMock("item 1");
        select.deselect(new String[]{"item 2"});
        Assert.assertEquals((long)1L, (long)select.getSelectedItems().size());
        Assert.assertArrayEquals((Object[])new Object[]{"item 1"}, (Object[])select.getSelectedItems().toArray());
        Assert.assertTrue((boolean)select.isSelected("item 1"));
        Assert.assertFalse((boolean)select.isSelected("item 2"));
    }

    @Test
    public void deselectItem_deselectSelectedItem_itemIsDesselected() {
        MultiSelectMock select = new MultiSelectMock("item 1", "item 2", "item 3");
        select.deselect(new String[]{"item 2"});
        Assert.assertEquals((long)2L, (long)select.getSelectedItems().size());
        Assert.assertArrayEquals((Object[])new Object[]{"item 1", "item 3"}, (Object[])select.getSelectedItems().toArray());
        Assert.assertTrue((boolean)select.isSelected("item 1"));
        Assert.assertFalse((boolean)select.isSelected("item 2"));
        Assert.assertTrue((boolean)select.isSelected("item 3"));
        select.deselect(Arrays.asList("item 3", "item 1"));
        Assert.assertEquals((long)0L, (long)select.getSelectedItems().size());
        Assert.assertFalse((boolean)select.isSelected("item 1"));
        Assert.assertFalse((boolean)select.isSelected("item 2"));
        Assert.assertFalse((boolean)select.isSelected("item 3"));
    }

    @Test
    public void setValue_previousItemsAreOverridden() {
        MultiSelectMock select = new MultiSelectMock("item 1", "item 2");
        select.setValue(new HashSet<String>(Arrays.asList("item 3")));
        Assert.assertEquals((long)1L, (long)select.getSelectedItems().size());
        Assert.assertArrayEquals((Object[])new Object[]{"item 3"}, (Object[])select.getSelectedItems().toArray());
        Assert.assertFalse((boolean)select.isSelected("item 1"));
        Assert.assertFalse((boolean)select.isSelected("item 2"));
        Assert.assertTrue((boolean)select.isSelected("item 3"));
        select.setValue(Collections.emptySet());
        Assert.assertEquals((long)0L, (long)select.getSelectedItems().size());
        Assert.assertFalse((boolean)select.isSelected("item 1"));
        Assert.assertFalse((boolean)select.isSelected("item 2"));
        Assert.assertFalse((boolean)select.isSelected("item 3"));
    }

    @Test
    public void getValue_selectAndDeselect_correctItemsAreReturned() {
        MultiSelectMock select = new MultiSelectMock("item 1", "item 2");
        Assert.assertEquals((long)2L, (long)select.getValue().size());
        Assert.assertArrayEquals((Object[])new Object[]{"item 1", "item 2"}, (Object[])select.getValue().toArray());
        select.select(new String[]{"item 3"});
        Assert.assertEquals((long)3L, (long)select.getValue().size());
        Assert.assertArrayEquals((Object[])new Object[]{"item 1", "item 2", "item 3"}, (Object[])select.getValue().toArray());
        select.deselect(new String[]{"item 2"});
        Assert.assertEquals((long)2L, (long)select.getValue().size());
        Assert.assertArrayEquals((Object[])new Object[]{"item 1", "item 3"}, (Object[])select.getValue().toArray());
    }

    @Test
    public void deselectAll_noValuesAreReturned() {
        MultiSelectMock select = new MultiSelectMock("item 1", "item 2");
        select.deselectAll();
        Assert.assertEquals((long)0L, (long)select.getValue().size());
        Assert.assertEquals((long)0L, (long)select.getSelectedItems().size());
    }

    private static class MultiSelectMock
    implements MultiSelect<TestLabel, String> {
        private final TestLabel component = new TestLabel();
        private final Set<String> selectedItems = new LinkedHashSet<String>();

        public MultiSelectMock(String ... initialItems) {
            Collections.addAll(this.selectedItems, initialItems);
        }

        public Registration addValueChangeListener(HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<TestLabel, Set<String>>> listener) {
            return null;
        }

        public Element getElement() {
            return this.component.getElement();
        }

        public void updateSelection(Set<String> addedItems, Set<String> removedItems) {
            this.selectedItems.removeAll(removedItems);
            this.selectedItems.addAll(addedItems);
        }

        public Set<String> getSelectedItems() {
            return new LinkedHashSet<String>(this.selectedItems);
        }

        public Registration addSelectionListener(MultiSelectionListener<TestLabel, String> listener) {
            return null;
        }
    }
}

