/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.converter;

import com.vaadin.flow.data.binder.ErrorMessageProvider;
import com.vaadin.flow.data.binder.Result;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.data.converter.AbstractStringToNumberConverter;
import com.vaadin.flow.function.SerializableFunction;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Locale;

public class StringToIntegerConverter
extends AbstractStringToNumberConverter<Integer> {
    public StringToIntegerConverter(String errorMessage) {
        this(null, errorMessage);
    }

    public StringToIntegerConverter(Integer emptyValue, String errorMessage) {
        super(emptyValue, errorMessage);
    }

    public StringToIntegerConverter(ErrorMessageProvider errorMessageProvider) {
        this(null, errorMessageProvider);
    }

    public StringToIntegerConverter(Integer emptyValue, ErrorMessageProvider errorMessageProvider) {
        super(emptyValue, errorMessageProvider);
    }

    @Override
    protected NumberFormat getFormat(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return NumberFormat.getIntegerInstance(locale);
    }

    @Override
    public Result<Integer> convertToModel(String value, ValueContext context) {
        Result<Number> n = this.convertToNumber(value, context);
        return n.flatMap((SerializableFunction & Serializable)number -> {
            if (number == null) {
                return Result.ok(null);
            }
            int intValue = number.intValue();
            if ((long)intValue == number.longValue()) {
                return Result.ok(intValue);
            }
            return Result.error(this.getErrorMessage(context));
        });
    }
}

