/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.vaadin.flow.data.provider.BackendDataProviderTest;
import com.vaadin.flow.data.provider.ConfigurableFilterDataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.provider.StrBean;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.function.SerializablePredicate;
import java.io.Serializable;
import org.junit.Assert;
import org.junit.Test;

public class ConfigurableFilterDataProviderWrapperTest {
    private static SerializablePredicate<StrBean> xyzFilter = (SerializablePredicate & Serializable)item -> item.getValue().equals("Xyz");
    private BackendDataProviderTest.StrBeanBackEndDataProvider backEndProvider = new BackendDataProviderTest.StrBeanBackEndDataProvider(StrBean.generateRandomBeans(100));
    private ConfigurableFilterDataProvider<StrBean, Void, SerializablePredicate<StrBean>> configurableVoid = this.backEndProvider.withConfigurableFilter();
    private ConfigurableFilterDataProvider<StrBean, String, Integer> configurablePredicate = this.backEndProvider.withConfigurableFilter((SerializableBiFunction & Serializable)(queryFilter, configuredFilter) -> (SerializablePredicate & Serializable)item -> {
        if (queryFilter != null && !item.getValue().equals(queryFilter)) {
            return false;
        }
        return configuredFilter == null || item.getId() >= configuredFilter;
    });

    @Test
    public void void_setFilter() {
        this.configurableVoid.setFilter(xyzFilter);
        Assert.assertEquals((String)"Set filter should be used", (long)1L, (long)this.configurableVoid.size(new Query()));
        this.configurableVoid.setFilter(null);
        Assert.assertEquals((String)"null filter should return all items", (long)100L, (long)this.configurableVoid.size(new Query()));
    }

    @Test(expected=Exception.class)
    public void void_nonNullQueryFilter_throws() {
        this.configurableVoid.size(new Query((Object)"invalid filter"));
    }

    @Test
    public void predicate_setFilter() {
        this.configurablePredicate.setFilter((Object)50);
        Assert.assertEquals((String)"Set filter should be used", (long)49L, (long)this.configurablePredicate.size(new Query()));
        this.configurablePredicate.setFilter(null);
        Assert.assertEquals((String)"null filter should return all items", (long)100L, (long)this.configurablePredicate.size(new Query()));
    }

    @Test
    public void predicate_queryFilter() {
        Assert.assertEquals((String)"Query filter should be used", (long)1L, (long)this.configurablePredicate.size(new Query((Object)"Xyz")));
        Assert.assertEquals((String)"null query filter should return all items", (long)100L, (long)this.configurablePredicate.size(new Query()));
    }

    @Test
    public void predicate_combinedFilters() {
        this.configurablePredicate.setFilter((Object)50);
        Assert.assertEquals((String)"Both filters should be used", (long)0L, (long)this.configurablePredicate.size(new Query((Object)"Xyz")));
        this.configurablePredicate.setFilter(null);
        Assert.assertEquals((String)"Only zyz filter should be used", (long)1L, (long)this.configurablePredicate.size(new Query((Object)"Xyz")));
    }
}

