/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.binder;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.data.binder.BeanPropertySet;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.PropertyFilterDefinition;
import com.vaadin.flow.data.binder.PropertyId;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.data.binder.testcomponents.TestDatePicker;
import com.vaadin.flow.data.binder.testcomponents.TestFormLayout;
import com.vaadin.flow.data.binder.testcomponents.TestTextField;
import com.vaadin.flow.data.converter.Converter;
import com.vaadin.flow.data.converter.StringToIntegerConverter;
import com.vaadin.flow.data.validator.StringLengthValidator;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.tests.data.bean.Address;
import com.vaadin.flow.tests.data.bean.ConvertibleValues;
import com.vaadin.flow.tests.data.bean.Person;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Locale;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;

public class BinderInstanceFieldTest {
    @Test
    public void bindInstanceFields_bindAllFields() {
        BindAllFields form = new BindAllFields();
        Binder binder = new Binder(Person.class);
        binder.bindInstanceFields((Object)form);
        Person person = new Person();
        person.setFirstName("foo");
        person.setBirthDate(LocalDate.now());
        binder.setBean((Object)person);
        Assert.assertEquals((Object)person.getFirstName(), (Object)form.firstName.getValue());
        Assert.assertEquals((Object)person.getBirthDate(), (Object)form.birthDate.getValue());
        form.firstName.setValue("bar");
        form.birthDate.setValue(person.getBirthDate().plusDays(345L));
        Assert.assertEquals((Object)form.firstName.getValue(), (Object)person.getFirstName());
        Assert.assertEquals((Object)form.birthDate.getValue(), (Object)person.getBirthDate());
    }

    @Test(expected=IllegalStateException.class)
    public void bind_instanceFields_noArgsConstructor() {
        BindAllFields form = new BindAllFields();
        Binder binder = new Binder();
        binder.bindInstanceFields((Object)form);
    }

    @Test
    public void bindInstanceFields_bindOnlyOneFields() {
        BindOnlyOneField form = new BindOnlyOneField();
        Binder binder = new Binder(Person.class);
        binder.bindInstanceFields((Object)form);
        Person person = new Person();
        person.setFirstName("foo");
        binder.setBean((Object)person);
        Assert.assertEquals((Object)person.getFirstName(), (Object)form.firstName.getValue());
        Assert.assertNull((Object)((Object)form.noFieldInPerson));
        form.firstName.setValue("bar");
        Assert.assertEquals((Object)form.firstName.getValue(), (Object)person.getFirstName());
    }

    @Test
    public void bindInstanceFields_bindNotHasValueField_fieldIsNull() {
        BindFieldHasWrongType form = new BindFieldHasWrongType();
        Binder binder = new Binder(Person.class);
        binder.bindInstanceFields((Object)form);
        Person person = new Person();
        person.setFirstName("foo");
        binder.setBean((Object)person);
        Assert.assertNull((Object)form.firstName);
    }

    @Test
    public void bindInstanceFields_genericField() {
        BindGenericField form = new BindGenericField();
        Binder binder = new Binder(Person.class);
        binder.bindInstanceFields((Object)form);
        Person person = new Person();
        person.setFirstName("foo");
        binder.setBean((Object)person);
        Assert.assertEquals((Object)person.getFirstName(), (Object)form.firstName.getValue());
        form.firstName.setValue("bar");
        Assert.assertEquals((Object)form.firstName.getValue(), (Object)person.getFirstName());
    }

    @Test(expected=IllegalStateException.class)
    public void bindInstanceFields_genericFieldWithWrongTypeParameter() {
        BindGenericWrongTypeParameterField form = new BindGenericWrongTypeParameterField();
        Binder binder = new Binder(Person.class);
        binder.bindInstanceFields((Object)form);
    }

    @Test(expected=IllegalStateException.class)
    public void bindInstanceFields_generic() {
        BindGeneric form = new BindGeneric();
        Binder binder = new Binder(Person.class);
        binder.bindInstanceFields(form);
    }

    @Test(expected=IllegalStateException.class)
    public void bindInstanceFields_rawFieldType() {
        BindRaw form = new BindRaw();
        Binder binder = new Binder(Person.class);
        binder.bindInstanceFields((Object)form);
    }

    @Test(expected=IllegalStateException.class)
    public void bindInstanceFields_abstractFieldType() {
        BindAbstract form = new BindAbstract();
        Binder binder = new Binder(Person.class);
        binder.bindInstanceFields((Object)form);
    }

    @Test(expected=IllegalStateException.class)
    public void bindInstanceFields_noInstantiatableFieldType() {
        BindNonInstantiatableType form = new BindNonInstantiatableType();
        Binder binder = new Binder(Person.class);
        binder.bindInstanceFields((Object)form);
    }

    @Test(expected=IllegalStateException.class)
    public void bindInstanceFields_wrongFieldType() {
        BindWrongTypeParameterField form = new BindWrongTypeParameterField();
        Binder binder = new Binder(Person.class);
        binder.bindInstanceFields((Object)form);
    }

    @Test
    public void bindInstanceFields_complexGenericHierarchy() {
        BindComplextHierarchyGenericType form = new BindComplextHierarchyGenericType();
        Binder binder = new Binder(Person.class);
        binder.bindInstanceFields((Object)form);
        Person person = new Person();
        person.setFirstName("foo");
        binder.setBean((Object)person);
        Assert.assertEquals((Object)person.getFirstName(), (Object)form.firstName.getValue());
        form.firstName.setValue("bar");
        Assert.assertEquals((Object)form.firstName.getValue(), (Object)person.getFirstName());
    }

    @Test
    public void bindInstanceFields_bindNotHasValueField_fieldIsNotReplaced() {
        String name;
        BindFieldHasWrongType form = new BindFieldHasWrongType();
        Binder binder = new Binder(Person.class);
        form.firstName = name = "foo";
        Person person = new Person();
        person.setFirstName("foo");
        binder.setBean((Object)person);
        Assert.assertEquals((Object)name, (Object)form.firstName);
    }

    @Test
    public void bindInstanceFields_bindAllFieldsUsingAnnotations() {
        BindFieldsUsingAnnotation form = new BindFieldsUsingAnnotation();
        Binder binder = new Binder(Person.class);
        binder.bindInstanceFields((Object)form);
        Person person = new Person();
        person.setFirstName("foo");
        person.setBirthDate(LocalDate.now());
        binder.setBean((Object)person);
        Assert.assertEquals((Object)person.getFirstName(), (Object)form.nameField.getValue());
        Assert.assertEquals((Object)person.getBirthDate(), (Object)form.birthDateField.getValue());
        form.nameField.setValue("bar");
        form.birthDateField.setValue(person.getBirthDate().plusDays(345L));
        Assert.assertEquals((Object)form.nameField.getValue(), (Object)person.getFirstName());
        Assert.assertEquals((Object)form.birthDateField.getValue(), (Object)person.getBirthDate());
    }

    @Test
    public void bindInstanceFields_bindNestedFieldUsingAnnotation() {
        BindNestedFieldsUsingAnnotation form = new BindNestedFieldsUsingAnnotation();
        Binder binder = new Binder(Person.class, true);
        binder.bindInstanceFields((Object)form);
        Person person = new Person();
        Address address = new Address();
        address.setStreetAddress("Foo st.");
        person.setAddress(address);
        binder.setBean((Object)person);
        Assert.assertEquals((String)"Reading nested properties bound using annotation", (Object)person.getAddress().getStreetAddress(), (Object)form.streetAddressField.getValue());
        form.streetAddressField.setValue("Bar ave.");
        Assert.assertEquals((String)"Changing nested properties bound using annotation", (Object)form.streetAddressField.getValue(), (Object)person.getAddress().getStreetAddress());
    }

    @Test
    public void bindInstanceFields_bindDeepNestedFieldsUsingAnnotation() {
        BindDeepNestedFieldsUsingAnnotation form = new BindDeepNestedFieldsUsingAnnotation();
        Binder binder = new Binder(Couple.class, true);
        binder.bindInstanceFields((Object)form);
        Person first = new Person();
        Person second = new Person();
        Address firstAddress = new Address();
        firstAddress.setStreetAddress("Foo st.");
        first.setAddress(firstAddress);
        Address secondAddress = new Address();
        second.setAddress(secondAddress);
        secondAddress.setStreetAddress("Bar ave.");
        Couple couple = new Couple();
        couple.setFirst(first);
        couple.setSecond(second);
        binder.setBean((Object)couple);
        Assert.assertEquals((String)"Binding deep nested properties using annotation", (Object)couple.first.getAddress().getStreetAddress(), (Object)form.firstStreetField.getValue());
        Assert.assertEquals((String)"Binding parallel deep nested properties using annotation", (Object)couple.second.getAddress().getStreetAddress(), (Object)form.secondStreetField.getValue());
        form.firstStreetField.setValue(second.getAddress().getStreetAddress());
        Assert.assertEquals((String)"Updating value in deep nested properties", (Object)form.firstStreetField.getValue(), (Object)first.getAddress().getStreetAddress());
    }

    @Test
    public void bindInstanceFields_circular() {
        BindDeepNestingFieldsWithCircularStructure form = new BindDeepNestingFieldsWithCircularStructure();
        Binder binder = new Binder(NestingStructure.class, true);
        binder.bindInstanceFields((Object)form);
        NestingStructure parent = new NestingStructure(this);
        parent.setName("parent");
        NestingStructure child = new NestingStructure(this);
        child.setName("child");
        parent.setChild(child);
        NestingStructure grandchild = new NestingStructure(this);
        grandchild.setName("grandchild");
        child.setChild(grandchild);
        NestingStructure root = grandchild;
        for (int i = 1; i < 15; ++i) {
            NestingStructure ns = new NestingStructure(this);
            ns.setName("great " + root.getName());
            root.setChild(ns);
            root = ns;
        }
        binder.setBean((Object)parent);
        Assert.assertEquals((Object)child.getName(), (Object)form.childName.getValue());
        Assert.assertEquals((Object)grandchild.getName(), (Object)form.grandchildName.getValue());
        Assert.assertNotNull((String)"Reading nested properties within default supported nested depth (max 10 levels)", (Object)((Object)form.eighthLevelGrandchildName));
        Assert.assertNull((String)"By default, only 10 levels of nesting properties are scanned.", (Object)((Object)form.distantGreatGrandchildName));
    }

    @Test
    public void bindInstanceFields_customNestingLevel() {
        BindDeepNestingFieldsWithCircularStructure form = new BindDeepNestingFieldsWithCircularStructure();
        int customScanningDepth = 5;
        PropertyFilterDefinition shallowFilter = new PropertyFilterDefinition(customScanningDepth, Arrays.asList("java.lang"));
        Binder binder = new Binder(BeanPropertySet.get(NestingStructure.class, (boolean)true, (PropertyFilterDefinition)shallowFilter));
        binder.bindInstanceFields((Object)form);
        NestingStructure parent = new NestingStructure(this);
        parent.setName("parent");
        NestingStructure child = new NestingStructure(this);
        child.setName("child");
        parent.setChild(child);
        NestingStructure grandchild = new NestingStructure(this);
        grandchild.setName("grandchild");
        child.setChild(grandchild);
        NestingStructure root = grandchild;
        for (int i = 1; i < 15; ++i) {
            NestingStructure ns = new NestingStructure(this);
            ns.setName("great " + root.getName());
            root.setChild(ns);
            root = ns;
        }
        binder.setBean((Object)parent);
        Assert.assertEquals((Object)child.getName(), (Object)form.childName.getValue());
        Assert.assertEquals((String)"Reading 3rd level nesting works when custom scanning depth is 5", (Object)grandchild.getName(), (Object)form.grandchildName.getValue());
        Assert.assertNull((String)"Reading eighth level nesting doesn't work when custom scanning depth is 5", (Object)((Object)form.eighthLevelGrandchildName));
    }

    @Test
    public void bindInstanceFields_bindNotBoundFieldsOnly_customBindingIsNotReplaced() {
        TestTextField name;
        BindAllFields form = new BindAllFields();
        Binder binder = new Binder(Person.class);
        form.firstName = name = new TestTextField();
        binder.forField((HasValue)form.firstName).withValidator((Validator)new StringLengthValidator("Name is invalid", Integer.valueOf(3), Integer.valueOf(10))).bind("firstName");
        binder.bindInstanceFields((Object)form);
        Person person = new Person();
        String personName = "foo";
        person.setFirstName(personName);
        person.setBirthDate(LocalDate.now());
        binder.setBean((Object)person);
        Assert.assertEquals((Object)person.getFirstName(), (Object)form.firstName.getValue());
        Assert.assertEquals((Object)person.getBirthDate(), (Object)form.birthDate.getValue());
        Assert.assertEquals((Object)((Object)name), (Object)((Object)form.firstName));
        form.birthDate.setValue(person.getBirthDate().plusDays(345L));
        Assert.assertEquals((Object)form.birthDate.getValue(), (Object)person.getBirthDate());
        form.firstName.setValue("aa");
        Assert.assertEquals((Object)personName, (Object)person.getFirstName());
        Assert.assertFalse((boolean)binder.validate().isOk());
    }

    @Test
    public void bindInstanceFields_fieldsAreConfigured_customBindingIsNotReplaced() {
        TestTextField ageField;
        TestTextField name;
        BindWithNoFieldInPerson form = new BindWithNoFieldInPerson();
        Binder binder = new Binder(Person.class);
        form.firstName = name = new TestTextField();
        binder.forField((HasValue)form.firstName).withValidator((Validator)new StringLengthValidator("Name is invalid", Integer.valueOf(3), Integer.valueOf(10))).bind("firstName");
        form.noFieldInPerson = ageField = new TestTextField();
        binder.forField((HasValue)form.noFieldInPerson).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        binder.bindInstanceFields((Object)form);
        Person person = new Person();
        String personName = "foo";
        int age = 11;
        person.setFirstName(personName);
        person.setAge(age);
        binder.setBean((Object)person);
        Assert.assertEquals((Object)person.getFirstName(), (Object)form.firstName.getValue());
        Assert.assertEquals((Object)String.valueOf(person.getAge()), (Object)form.noFieldInPerson.getValue());
        Assert.assertEquals((Object)((Object)name), (Object)((Object)form.firstName));
        Assert.assertEquals((Object)((Object)ageField), (Object)((Object)form.noFieldInPerson));
        form.noFieldInPerson.setValue(String.valueOf(age += 56));
        Assert.assertEquals((Object)form.noFieldInPerson.getValue(), (Object)String.valueOf(person.getAge()));
        form.firstName.setValue("aa");
        Assert.assertEquals((Object)personName, (Object)person.getFirstName());
        Assert.assertFalse((boolean)binder.validate().isOk());
    }

    @Test
    public void bindInstanceFields_preconfiguredFieldNotBoundToPropertyPreserved() {
        BindOneFieldRequiresConverter form = new BindOneFieldRequiresConverter();
        form.age = new TestTextField();
        form.firstName = new TestTextField();
        Binder binder = new Binder(Person.class);
        binder.forField((HasValue)form.age).withConverter((SerializableFunction & Serializable)str -> Integer.parseInt(str) / 2, (SerializableFunction & Serializable)integer -> Integer.toString(integer * 2)).bind(Person::getAge, Person::setAge);
        binder.bindInstanceFields((Object)form);
        Person person = new Person();
        person.setFirstName("first");
        person.setAge(45);
        binder.setBean((Object)person);
        Assert.assertEquals((Object)"90", (Object)form.age.getValue());
    }

    @Test
    public void bindInstanceFields_explicitelyBoundFieldAndNotBoundField() {
        BindOnlyOneField form = new BindOnlyOneField();
        Binder binder = new Binder(Person.class);
        binder.forField((HasValue)new TestTextField()).bind("firstName");
        binder.bindInstanceFields((Object)form);
    }

    @Test
    public void bindInstanceFields_tentativelyBoundFieldAndNotBoundField() {
        TestTextField field;
        BindOnlyOneField form = new BindOnlyOneField();
        Binder binder = new Binder(Person.class);
        form.firstName = field = new TestTextField();
        binder.forMemberField((HasValue)field);
        binder.bindInstanceFields((Object)form);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void bindInstanceFields_fieldsNeedConversion_knownConvertersApplied() {
        Locale defaultLocale = Locale.getDefault();
        Locale.setDefault(Locale.ENGLISH);
        try {
            BindAutomaticConverter form = new BindAutomaticConverter();
            form.stringToInteger = new TestTextField();
            form.localDateToDate = new TestDatePicker();
            form.stringToBigDecimal = new TestTextField();
            form.stringToBigInteger = new TestTextField();
            form.stringToBoolean = new TestTextField();
            form.stringToPrimitiveBoolean = new TestTextField();
            form.stringToDouble = new TestTextField();
            form.stringToPrimitiveDouble = new TestTextField();
            form.stringToFloat = new TestTextField();
            form.stringToPrimitiveFloat = new TestTextField();
            form.stringToInteger = new TestTextField();
            form.stringToPrimitiveInteger = new TestTextField();
            form.stringToLong = new TestTextField();
            form.stringToPrimitiveLong = new TestTextField();
            form.stringToUUID = new TestTextField();
            Binder binder = new Binder(ConvertibleValues.class);
            binder.bindInstanceFields((Object)form);
            LocalDate now = LocalDate.of(2022, 3, 27);
            UUID uuid = UUID.randomUUID();
            ConvertibleValues data = new ConvertibleValues();
            data.setStringToBigDecimal(new BigDecimal("20.23"));
            data.setStringToBigInteger(new BigInteger("30"));
            data.setStringToDouble(40.56);
            data.setStringToPrimitiveDouble(50.78);
            data.setStringToFloat(Float.valueOf(60.23f));
            data.setStringToPrimitiveFloat(70.12f);
            data.setStringToInteger(80);
            data.setStringToPrimitiveInteger(90);
            data.setStringToLong(100L);
            data.setStringToPrimitiveLong(110L);
            data.setStringToBoolean(true);
            data.setStringToPrimitiveBoolean(false);
            data.setLocalDateToDate(Date.valueOf(now));
            data.setStringToUUID(uuid);
            binder.setBean((Object)data);
            Assert.assertEquals((Object)"20.23", (Object)form.stringToBigDecimal.getValue());
            Assert.assertEquals((Object)"30", (Object)form.stringToBigInteger.getValue());
            Assert.assertEquals((Object)"40.56", (Object)form.stringToDouble.getValue());
            Assert.assertEquals((Object)"50.78", (Object)form.stringToPrimitiveDouble.getValue());
            Assert.assertEquals((Object)"60.23", (Object)form.stringToFloat.getValue());
            Assert.assertEquals((Object)"70.12", (Object)form.stringToPrimitiveFloat.getValue());
            Assert.assertEquals((Object)"80", (Object)form.stringToInteger.getValue());
            Assert.assertEquals((Object)"90", (Object)form.stringToPrimitiveInteger.getValue());
            Assert.assertEquals((Object)"100", (Object)form.stringToLong.getValue());
            Assert.assertEquals((Object)"110", (Object)form.stringToPrimitiveLong.getValue());
            Assert.assertEquals((Object)"true", (Object)form.stringToBoolean.getValue());
            Assert.assertEquals((Object)"false", (Object)form.stringToPrimitiveBoolean.getValue());
            Assert.assertEquals((Object)now, (Object)form.localDateToDate.getValue());
            Assert.assertEquals((Object)uuid.toString(), (Object)form.stringToUUID.getValue());
        }
        finally {
            Locale.setDefault(defaultLocale);
        }
    }

    @Test
    public void bindInstanceFields_fieldsNeedConversion_nullRepresentationIsConfigured() {
        BindAutomaticConverter form = new BindAutomaticConverter();
        form.stringToInteger = new TestTextField(){

            public String getEmptyValue() {
                return "EMPTY";
            }
        };
        Binder binder = new Binder(ConvertibleValues.class);
        binder.bindInstanceFields((Object)form);
        ConvertibleValues data = new ConvertibleValues();
        binder.setBean((Object)data);
        Assert.assertEquals((Object)"EMPTY", (Object)form.stringToInteger.getValue());
    }

    @Test
    public void bindInstanceFields_incompleteBinding_converterNotAppliedAutomatically() {
        BindOneFieldRequiresConverter form = new BindOneFieldRequiresConverter();
        form.age = new TestTextField();
        Binder binder = new Binder(Person.class);
        Binder.BindingBuilder ageBinding = binder.forField((HasValue)form.age).withConverter((SerializableFunction & Serializable)str -> Integer.parseInt(str) / 2, (SerializableFunction & Serializable)integer -> Integer.toString(integer * 2));
        binder.bindInstanceFields((Object)form);
        Assert.assertFalse((String)"Expecting incomplete binding to be ignored by Binder, but field was bound", (boolean)binder.getBinding("age").isPresent());
        ageBinding.bind(Person::getAge, Person::setAge);
        Person person = new Person();
        person.setAge(45);
        binder.setBean((Object)person);
        Assert.assertEquals((Object)"90", (Object)form.age.getValue());
    }

    @Test
    public void bindInstanceFields_customBindingAfterInvoke_automaticBindingOverwritten() {
        BindOnlyOneField form = new BindOnlyOneField();
        form.firstName = new TestTextField();
        Binder binder = new Binder(Person.class);
        binder.bindInstanceFields((Object)form);
        Binder.BindingBuilder binding = binder.forField((HasValue)form.firstName).withConverter((SerializableFunction & Serializable)str -> str.substring(str.length() / 2), (SerializableFunction & Serializable)str -> str + str);
        binding.bind(Person::getFirstName, Person::setFirstName);
        Person person = new Person();
        person.setFirstName("Hello!");
        binder.setBean((Object)person);
        Assert.assertEquals((Object)"Hello!Hello!", (Object)form.firstName.getValue());
    }

    @Test
    public void bindInstanceFields_incompleteBindingBoundAfterInvoke_automaticBindingOverwritten() {
        BindOnlyOneField form = new BindOnlyOneField();
        form.firstName = new TestTextField();
        Binder binder = new Binder(Person.class);
        Binder.BindingBuilder binding = binder.forField((HasValue)form.firstName).withConverter((SerializableFunction & Serializable)str -> str.substring(str.length() / 2), (SerializableFunction & Serializable)str -> str + str);
        binder.bindInstanceFields((Object)form);
        binding.bind(Person::getFirstName, Person::setFirstName);
        Person person = new Person();
        person.setFirstName("Hello!");
        binder.setBean((Object)person);
        Assert.assertEquals((Object)"Hello!Hello!", (Object)form.firstName.getValue());
    }

    @Test
    public void bindInstanceFields_incompleteBinding_fieldIgnored() {
        BindOnlyOneField form = new BindOnlyOneField();
        form.firstName = new TestTextField();
        Binder binder = new Binder(Person.class);
        binder.forField((HasValue)form.firstName).withConverter((SerializableFunction & Serializable)str -> str.substring(str.length() / 2), (SerializableFunction & Serializable)str -> str + str);
        binder.bindInstanceFields((Object)form);
        Assert.assertFalse((String)"Expecting incomplete binding to be ignored by Binder, but field was bound", (boolean)binder.getBinding("firstName").isPresent());
    }

    public static class BindAllFields
    extends TestFormLayout {
        private TestTextField firstName;
        private TestDatePicker birthDate;
    }

    public static class BindOnlyOneField
    extends TestFormLayout {
        private TestTextField firstName;
        private TestTextField noFieldInPerson;
    }

    public static class BindFieldHasWrongType
    extends TestFormLayout {
        private String firstName;
        private TestDatePicker birthDate;
    }

    public static class BindGenericField
    extends TestFormLayout {
        private CustomField<String> firstName;
    }

    @Tag(value="input")
    public static class CustomField<T>
    extends AbstractField<CustomField<T>, T> {
        public CustomField() {
            super(null);
        }

        protected void setPresentationValue(T newPresentationValue) {
        }
    }

    public static class BindGenericWrongTypeParameterField
    extends TestFormLayout {
        private CustomField<Boolean> firstName;
    }

    public static class BindGeneric<T>
    extends TestFormLayout {
        private CustomField<T> firstName;
    }

    public static class BindRaw
    extends TestFormLayout {
        private CustomField firstName;
    }

    public static class BindAbstract
    extends TestFormLayout {
        private AbstractTextField firstName;
    }

    public static class BindNonInstantiatableType
    extends TestFormLayout {
        private NoDefaultCtor firstName;
    }

    public static class BindWrongTypeParameterField
    extends TestFormLayout {
        private IntegerTextField firstName;
    }

    public static class BindComplextHierarchyGenericType
    extends TestFormLayout {
        private ComplexHierarchy firstName;
    }

    public static class ComplexHierarchy
    extends Generic<Long> {
    }

    public static class BindFieldsUsingAnnotation
    extends TestFormLayout {
        @PropertyId(value="firstName")
        private TestTextField nameField;
        @PropertyId(value="birthDate")
        private TestDatePicker birthDateField;
    }

    public static class BindNestedFieldsUsingAnnotation
    extends TestFormLayout {
        @PropertyId(value="address.streetAddress")
        private TestTextField streetAddressField;
    }

    public static class BindDeepNestedFieldsUsingAnnotation
    extends TestFormLayout {
        @PropertyId(value="first.address.streetAddress")
        private TestTextField firstStreetField;
        @PropertyId(value="second.address.streetAddress")
        private TestTextField secondStreetField;
    }

    static final class Couple {
        Person first;
        Person second;

        Couple() {
        }

        public Person getFirst() {
            return this.first;
        }

        public Person getSecond() {
            return this.second;
        }

        public void setFirst(Person first) {
            this.first = first;
        }

        public void setSecond(Person second) {
            this.second = second;
        }
    }

    public static class BindDeepNestingFieldsWithCircularStructure
    extends TestFormLayout {
        @PropertyId(value="child.name")
        private TestTextField childName;
        @PropertyId(value="child.child.name")
        private TestTextField grandchildName;
        @PropertyId(value="child.child.child.child.child.child.child.child.name")
        private TestTextField eighthLevelGrandchildName;
        @PropertyId(value="child.child.child.child.child.child.child.child.child.child.child.child.child.name")
        private TestTextField distantGreatGrandchildName;
    }

    final class NestingStructure {
        NestingStructure child;
        String name;

        NestingStructure(BinderInstanceFieldTest this$0) {
        }

        public NestingStructure getChild() {
            return this.child;
        }

        public void setChild(NestingStructure child) {
            this.child = child;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class BindWithNoFieldInPerson
    extends TestFormLayout {
        private TestTextField firstName;
        private TestDatePicker birthDate;
        private TestTextField noFieldInPerson;
    }

    public static class BindOneFieldRequiresConverter
    extends TestFormLayout {
        private TestTextField firstName;
        private TestTextField age;
    }

    public static class BindAutomaticConverter
    extends TestFormLayout {
        private TestDatePicker localDateToDate;
        private TestTextField stringToBigDecimal;
        private TestTextField stringToBigInteger;
        private TestTextField stringToBoolean;
        private TestTextField stringToPrimitiveBoolean;
        private TestTextField stringToDouble;
        private TestTextField stringToPrimitiveDouble;
        private TestTextField stringToFloat;
        private TestTextField stringToPrimitiveFloat;
        private TestTextField stringToInteger;
        private TestTextField stringToPrimitiveInteger;
        private TestTextField stringToLong;
        private TestTextField stringToPrimitiveLong;
        private TestTextField stringToUUID;
    }

    public static class ComplexGeneric<U, V, S>
    extends CustomField<V> {
    }

    public static class Generic<T>
    extends ComplexGeneric<Boolean, String, T> {
    }

    public static class IntegerTextField
    extends CustomField<Integer> {
    }

    public static class NoDefaultCtor
    extends TestTextField {
        public NoDefaultCtor(int arg) {
        }
    }

    public static abstract class AbstractTextField
    extends Component
    implements HasValue<HasValue.ValueChangeEvent<String>, String> {
    }
}

