/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.binder;

import com.vaadin.flow.data.binder.Result;
import com.vaadin.flow.data.binder.SimpleResult;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializableSupplier;
import java.io.Serializable;
import org.junit.Assert;
import org.junit.Test;

public class ResultTest {
    @Test
    public void testOk() {
        String value = "foo";
        Result ok = Result.ok((Object)value);
        Assert.assertFalse((boolean)ok.isError());
        Assert.assertFalse((boolean)ok.getMessage().isPresent());
        ok.ifOk((SerializableConsumer & Serializable)v -> Assert.assertEquals((Object)value, (Object)v));
        ok.ifError((SerializableConsumer & Serializable)msg -> Assert.fail());
    }

    @Test
    public void testError() {
        String message = "foo";
        Result error = Result.error((String)message);
        Assert.assertTrue((boolean)error.isError());
        Assert.assertTrue((boolean)error.getMessage().isPresent());
        error.ifOk((SerializableConsumer & Serializable)v -> Assert.fail());
        error.ifError((SerializableConsumer & Serializable)msg -> Assert.assertEquals((Object)message, (Object)msg));
        Assert.assertEquals((Object)message, error.getMessage().get());
    }

    @Test
    public void of_noException() {
        Result result = Result.of((SerializableSupplier & Serializable)() -> "", (SerializableFunction & Serializable)exception -> null);
        Assert.assertTrue((boolean)(result instanceof SimpleResult));
        Assert.assertFalse((boolean)result.isError());
    }

    @Test
    public void of_exception() {
        String message = "foo";
        Result result = Result.of((SerializableSupplier & Serializable)() -> {
            throw new RuntimeException();
        }, (SerializableFunction & Serializable)exception -> message);
        Assert.assertTrue((boolean)(result instanceof SimpleResult));
        Assert.assertTrue((boolean)result.isError());
        Assert.assertEquals((Object)message, result.getMessage().get());
    }

    @Test
    public void map_norError_mapperIsApplied() {
        SimpleResult<String> result = new SimpleResult<String>("foo", null){

            public <S> Result<S> flatMap(SerializableFunction<String, Result<S>> mapper) {
                return (Result)mapper.apply((Object)"foo");
            }
        };
        Result mapResult = result.map((SerializableFunction & Serializable)value -> {
            Assert.assertEquals((Object)"foo", (Object)value);
            return "bar";
        });
        Assert.assertTrue((boolean)(mapResult instanceof SimpleResult));
        Assert.assertFalse((boolean)mapResult.isError());
        mapResult.ifOk((SerializableConsumer & Serializable)v -> Assert.assertEquals((Object)"bar", (Object)v));
    }

    @Test
    public void map_error_mapperIsApplied() {
        SimpleResult<String> result = new SimpleResult<String>("foo", null){

            public <S> Result<S> flatMap(SerializableFunction<String, Result<S>> mapper) {
                return new SimpleResult(null, "bar");
            }
        };
        Result mapResult = result.map((SerializableFunction & Serializable)value -> {
            Assert.assertEquals((Object)"foo", (Object)value);
            return "somevalue";
        });
        Assert.assertTrue((boolean)(mapResult instanceof SimpleResult));
        Assert.assertTrue((boolean)mapResult.isError());
        mapResult.ifError((SerializableConsumer & Serializable)msg -> Assert.assertEquals((Object)"bar", (Object)msg));
    }
}

