/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.converter;

import com.vaadin.flow.data.binder.Result;
import com.vaadin.flow.data.converter.BigDecimalToDoubleConverter;
import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Test;

public class BigDecimalToDoubleConverterTest {
    BigDecimalToDoubleConverter converter = new BigDecimalToDoubleConverter();

    @Test
    public void testNullConversionToModel() {
        Assert.assertEquals((Object)Result.ok(null), (Object)this.converter.convertToModel(null, null));
    }

    @Test
    public void testNullConversionToPresentation() {
        Assert.assertNull((Object)this.converter.convertToPresentation(null, null));
    }

    @Test
    public void testConvertToModel() {
        Result result = this.converter.convertToModel(BigDecimal.valueOf(42.42), null);
        Assert.assertEquals((Object)Result.ok((Object)42.42), (Object)result);
    }

    @Test
    public void testConvertToPresentation() {
        BigDecimal value = this.converter.convertToPresentation(Double.valueOf(42.42), null);
        Assert.assertEquals((Object)BigDecimal.valueOf(42.42), (Object)value);
    }

    @Test
    public void testConvertToModelWithDifferentScales() {
        Result result = this.converter.convertToModel(new BigDecimal("42.420"), null);
        Assert.assertEquals((Object)Result.ok((Object)42.42), (Object)result);
    }

    @Test
    public void testConvertToPresentationWithDifferentScales() {
        BigDecimal value = this.converter.convertToPresentation(Double.valueOf(42.42), null);
        Assert.assertEquals((Object)new BigDecimal("42.42"), (Object)value);
    }
}

