/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.binder;

import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.BindingValidationStatus;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.function.SerializablePredicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class BinderValidationStatus<BEAN>
implements Serializable {
    private final Binder<BEAN> binder;
    private final List<BindingValidationStatus<?>> bindingStatuses;
    private final List<ValidationResult> binderStatuses;

    public BinderValidationStatus(Binder<BEAN> source, List<BindingValidationStatus<?>> bindingStatuses, List<ValidationResult> binderStatuses) {
        Objects.requireNonNull(binderStatuses, "binding statuses cannot be null");
        Objects.requireNonNull(binderStatuses, "binder statuses cannot be null");
        this.binder = source;
        this.bindingStatuses = Collections.unmodifiableList(bindingStatuses);
        this.binderStatuses = Collections.unmodifiableList(binderStatuses);
    }

    public static <BEAN> BinderValidationStatus<BEAN> createUnresolvedStatus(Binder<BEAN> source) {
        return new BinderValidationStatus<BEAN>(source, source.getBindings().stream().map(BindingValidationStatus::createUnresolvedStatus).collect(Collectors.toList()), Collections.emptyList());
    }

    public boolean isOk() {
        return !this.hasErrors();
    }

    public boolean hasErrors() {
        return this.binderStatuses.stream().anyMatch(ValidationResult::isError) || this.bindingStatuses.stream().anyMatch(BindingValidationStatus::isError);
    }

    public Binder<BEAN> getBinder() {
        return this.binder;
    }

    public List<ValidationResult> getValidationErrors() {
        ArrayList<ValidationResult> errors = new ArrayList<ValidationResult>(this.getFieldValidationErrors().stream().map(s -> s.getResult().get()).collect(Collectors.toList()));
        errors.addAll(this.getBeanValidationErrors());
        return errors;
    }

    public List<BindingValidationStatus<?>> getFieldValidationStatuses() {
        return this.bindingStatuses;
    }

    public List<ValidationResult> getBeanValidationResults() {
        return this.binderStatuses;
    }

    public List<BindingValidationStatus<?>> getFieldValidationErrors() {
        return this.bindingStatuses.stream().filter(BindingValidationStatus::isError).collect(Collectors.toList());
    }

    public List<ValidationResult> getBeanValidationErrors() {
        return this.binderStatuses.stream().filter(ValidationResult::isError).collect(Collectors.toList());
    }

    public void notifyBindingValidationStatusHandlers() {
        this.notifyBindingValidationStatusHandlers((SerializablePredicate & Serializable)t -> true);
    }

    public void notifyBindingValidationStatusHandlers(SerializablePredicate<BindingValidationStatus<?>> filter) {
        this.bindingStatuses.stream().filter(filter).forEach(s -> s.getBinding().getValidationStatusHandler().statusChange((BindingValidationStatus<?>)s));
    }
}

