/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.vaadin.flow.data.provider.CompositeDataGenerator;
import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import tools.jackson.databind.node.ObjectNode;

public class CompositeDataGeneratorTest {
    @Test
    public void generateData_innerGeneratorsAreInvoked() {
        CompositeDataGenerator composite = new CompositeDataGenerator();
        MockDataGenerator mock1 = new MockDataGenerator("mock1", "value1");
        MockDataGenerator mock2 = new MockDataGenerator("mock2", "value2");
        MockDataGenerator mock3 = new MockDataGenerator("mock3", "value3");
        composite.addDataGenerator((DataGenerator)mock1);
        composite.addDataGenerator((DataGenerator)mock2);
        composite.addDataGenerator((DataGenerator)mock3);
        ObjectNode json = JacksonUtils.createObjectNode();
        composite.generateData((Object)"item1", json);
        Assert.assertEquals((Object)"value1", (Object)json.get("mock1").asText());
        Assert.assertEquals((Object)"value2", (Object)json.get("mock2").asText());
        Assert.assertEquals((Object)"value3", (Object)json.get("mock3").asText());
        Assert.assertThat(mock1.getProcessed(), (Matcher)CoreMatchers.hasItem((Object)"item1"));
        Assert.assertThat(mock2.getProcessed(), (Matcher)CoreMatchers.hasItem((Object)"item1"));
        Assert.assertThat(mock3.getProcessed(), (Matcher)CoreMatchers.hasItem((Object)"item1"));
    }

    @Test
    public void refreshData_innerGeneratorsAreInvoked() {
        CompositeDataGenerator composite = new CompositeDataGenerator();
        MockDataGenerator mock1 = new MockDataGenerator("mock1", "value1");
        MockDataGenerator mock2 = new MockDataGenerator("mock2", "value2");
        MockDataGenerator mock3 = new MockDataGenerator("mock3", "value3");
        composite.addDataGenerator((DataGenerator)mock1);
        composite.addDataGenerator((DataGenerator)mock2);
        composite.addDataGenerator((DataGenerator)mock3);
        composite.refreshData((Object)"item1");
        Assert.assertThat(mock1.getRefreshed(), (Matcher)CoreMatchers.hasItem((Object)"item1"));
        Assert.assertThat(mock2.getRefreshed(), (Matcher)CoreMatchers.hasItem((Object)"item1"));
        Assert.assertThat(mock3.getRefreshed(), (Matcher)CoreMatchers.hasItem((Object)"item1"));
    }

    @Test
    public void destroyData_innerGeneratorsAreInvoked() {
        CompositeDataGenerator composite = new CompositeDataGenerator();
        MockDataGenerator mock1 = new MockDataGenerator("mock1", "value1");
        MockDataGenerator mock2 = new MockDataGenerator("mock2", "value2");
        MockDataGenerator mock3 = new MockDataGenerator("mock3", "value3");
        composite.addDataGenerator((DataGenerator)mock1);
        composite.addDataGenerator((DataGenerator)mock2);
        composite.addDataGenerator((DataGenerator)mock3);
        composite.generateData((Object)"item1", JacksonUtils.createObjectNode());
        composite.refreshData((Object)"item1");
        composite.generateData((Object)"item2", JacksonUtils.createObjectNode());
        composite.refreshData((Object)"item2");
        composite.destroyData((Object)"item1");
        Assert.assertThat(mock1.getProcessed(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Object)"item1")));
        Assert.assertThat(mock1.getProcessed(), (Matcher)CoreMatchers.hasItem((Object)"item2"));
        Assert.assertThat(mock2.getProcessed(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Object)"item1")));
        Assert.assertThat(mock2.getProcessed(), (Matcher)CoreMatchers.hasItem((Object)"item2"));
        Assert.assertThat(mock3.getProcessed(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Object)"item1")));
        Assert.assertThat(mock3.getProcessed(), (Matcher)CoreMatchers.hasItem((Object)"item2"));
    }

    @Test
    public void destroyAllData_innerGeneratorsAreInvoked() {
        CompositeDataGenerator composite = new CompositeDataGenerator();
        MockDataGenerator mock1 = new MockDataGenerator("mock1", "value1");
        MockDataGenerator mock2 = new MockDataGenerator("mock2", "value2");
        MockDataGenerator mock3 = new MockDataGenerator("mock3", "value3");
        composite.addDataGenerator((DataGenerator)mock1);
        composite.addDataGenerator((DataGenerator)mock2);
        composite.addDataGenerator((DataGenerator)mock3);
        composite.generateData((Object)"item1", JacksonUtils.createObjectNode());
        composite.refreshData((Object)"item1");
        composite.generateData((Object)"item2", JacksonUtils.createObjectNode());
        composite.refreshData((Object)"item2");
        composite.destroyAllData();
        Assert.assertTrue((boolean)mock1.getProcessed().isEmpty());
        Assert.assertTrue((boolean)mock2.getProcessed().isEmpty());
        Assert.assertTrue((boolean)mock3.getProcessed().isEmpty());
    }

    @Test
    public void dataGeneratorRegistration_remove_dataIsDestroyed() {
        CompositeDataGenerator composite = new CompositeDataGenerator();
        MockDataGenerator mock1 = new MockDataGenerator("mock", "value1");
        MockDataGenerator mock2 = new MockDataGenerator("mock", "value1");
        Registration registration1 = composite.addDataGenerator((DataGenerator)mock1);
        Registration registration2 = composite.addDataGenerator((DataGenerator)mock2);
        composite.generateData((Object)"item1", JacksonUtils.createObjectNode());
        Assert.assertThat(mock1.getProcessed(), (Matcher)CoreMatchers.hasItem((Object)"item1"));
        Assert.assertThat(mock2.getProcessed(), (Matcher)CoreMatchers.hasItem((Object)"item1"));
        registration1.remove();
        Assert.assertThat(mock1.getProcessed(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Object)"item1")));
        Assert.assertThat(mock2.getProcessed(), (Matcher)CoreMatchers.hasItem((Object)"item1"));
        registration2.remove();
        Assert.assertThat(mock2.getProcessed(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Object)"item1")));
    }

    @Test
    public void addDataGenerator_orderIsPreserved() {
        CompositeDataGenerator cdg = new CompositeDataGenerator();
        DataGenerator & Serializable dg1 = (DataGenerator & Serializable)(String2, ObjectNode2) -> {};
        DataGenerator & Serializable dg2 = (DataGenerator & Serializable)(String2, ObjectNode2) -> {};
        List<DataGenerator> expected = Arrays.asList(dg1, dg2);
        cdg.addDataGenerator((DataGenerator)dg1);
        cdg.addDataGenerator((DataGenerator)dg2);
        Assert.assertEquals(expected, new ArrayList(cdg.dataGenerators));
    }

    private static class MockDataGenerator
    implements DataGenerator<String> {
        private String jsonKey;
        private String jsonValue;
        private List<String> processed = new ArrayList<String>();
        private List<String> refreshed = new ArrayList<String>();

        public MockDataGenerator(String jsonKey, String jsonValue) {
            this.jsonKey = jsonKey;
            this.jsonValue = jsonValue;
        }

        public void generateData(String item, ObjectNode jsonObject) {
            jsonObject.put(this.jsonKey, this.jsonValue);
            this.processed.add(item);
        }

        public void destroyData(String item) {
            this.processed.remove(item);
            this.refreshed.remove(item);
        }

        public void refreshData(String item) {
            this.refreshed.add(item);
        }

        public void destroyAllData() {
            this.processed.clear();
            this.refreshed.clear();
        }

        public List<String> getProcessed() {
            return this.processed;
        }

        public List<String> getRefreshed() {
            return this.refreshed;
        }
    }
}

