/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider.hierarchy;

import com.vaadin.flow.data.provider.hierarchy.RootCache;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.SerializableSupplier;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

class Cache<T>
implements Serializable {
    private final RootCache<T> rootCache;
    private final Cache<T> parentCache;
    private final T parentItem;
    private int size;
    private final Map<Object, T> itemIdToItem = new HashMap<Object, T>();
    private final SortedMap<Integer, Object> indexToItemId = new TreeMap<Integer, Object>();
    private final SortedMap<Integer, Cache<T>> indexToCache = new TreeMap<Integer, Cache<T>>();

    protected Cache(Cache<T> parentCache, T parentItem, int size) {
        this.rootCache = parentCache != null ? parentCache.rootCache : (RootCache)this;
        this.parentCache = parentCache;
        this.parentItem = parentItem;
        this.size = size;
    }

    public T getParentItem() {
        return this.parentItem;
    }

    public int getDepth() {
        return this.parentCache != null ? this.parentCache.getDepth() + 1 : 0;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public boolean hasItem(int index) {
        return this.indexToItemId.containsKey(index);
    }

    public T getItem(int index) {
        Object itemId = this.indexToItemId.get(index);
        return this.itemIdToItem.get(itemId);
    }

    public void removeItem(int index) {
        Object itemId = this.indexToItemId.remove(index);
        T item = this.itemIdToItem.remove(itemId);
        this.rootCache.onItemRemoved(item);
    }

    public void refreshItem(T item) {
        Object itemId = this.rootCache.getItemId(item);
        this.itemIdToItem.replace(itemId, item);
    }

    public void setItems(int startIndex, List<T> items) {
        int index = startIndex;
        for (T item : items) {
            Object itemId = this.rootCache.getItemId(item);
            this.indexToItemId.put(index, itemId);
            this.itemIdToItem.put(itemId, item);
            this.rootCache.onItemAdded(item, this, index);
            ++index;
        }
    }

    public void clear() {
        this.indexToCache.values().forEach(Cache::clear);
        this.indexToCache.clear();
        this.indexToItemId.values().forEach(itemId -> this.rootCache.onItemRemoved(this.itemIdToItem.get(itemId)));
        this.indexToItemId.clear();
        this.itemIdToItem.clear();
    }

    public boolean hasSubCache(int index) {
        return this.indexToCache.containsKey(index);
    }

    public Cache<T> getSubCache(int index) {
        return (Cache)this.indexToCache.get(index);
    }

    public Set<Map.Entry<Integer, Cache<T>>> getSubCaches() {
        return this.indexToCache.entrySet();
    }

    public Cache<T> ensureSubCache(int index, T item, SerializableSupplier<Integer> sizeSupplier) {
        return this.indexToCache.computeIfAbsent(index, _key -> new Cache<Object>(this, item, (Integer)sizeSupplier.get()));
    }

    public void removeDescendantCacheIf(SerializablePredicate<Cache<T>> predicate) {
        this.indexToCache.values().removeIf(cache -> {
            if (predicate.test(cache)) {
                cache.clear();
                return true;
            }
            cache.removeDescendantCacheIf(predicate);
            return false;
        });
    }
}

