/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.validator;

import com.vaadin.flow.data.validator.RegexpValidator;
import com.vaadin.flow.data.validator.ValidatorTestBase;
import org.junit.Test;

public class RegexpValidatorTest
extends ValidatorTestBase {
    @Test
    public void testNullStringFails() {
        this.assertPasses(null, new RegexpValidator("Should be 'abc'", "abc"));
    }

    @Test
    public void testEmptyPatternMatchesEmptyString() {
        this.assertPasses("", new RegexpValidator("Should be empty", "", true));
    }

    @Test
    public void testEmptyPatternDoesNotMatchNonEmptyString() {
        this.assertFails("x", new RegexpValidator("Should be empty", "", true));
    }

    @Test
    public void testPatternMatchesString() {
        RegexpValidator v = new RegexpValidator("Should be foo and bar repeating", "(foo|bar)+", true);
        this.assertPasses("foo", v);
        this.assertPasses("barfoo", v);
        this.assertPasses("foobarbarbarfoobarfoofoobarbarfoofoofoobar", v);
    }

    @Test
    public void testPatternDoesNotMatchString() {
        RegexpValidator v = new RegexpValidator("Should be foo and bar repeating", "(foo|bar)+", true);
        this.assertFails("", v);
        this.assertFails("barf", v);
        this.assertFails(" bar", v);
        this.assertFails("foobarbarbarfoobar.foofoobarbarfoofoofoobar", v);
    }

    @Test
    public void testEmptyPatternFoundInAnyString() {
        RegexpValidator v = new RegexpValidator("Should always pass", "", false);
        this.assertPasses("", v);
        this.assertPasses("      ", v);
        this.assertPasses("qwertyuiopasdfghjklzxcvbnm", v);
    }

    @Test
    public void testPatternFoundInString() {
        RegexpValidator v = new RegexpValidator("Should contain a number", "\\d+", false);
        this.assertPasses("0", v);
        this.assertPasses("     123     ", v);
        this.assertPasses("qwerty9iop", v);
    }

    @Test
    public void testPatternNotFoundInString() {
        RegexpValidator v = new RegexpValidator("Should contain a number", "\\d+", false);
        this.assertFails("", v);
        this.assertFails("qwertyiop", v);
    }
}

