/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider.hierarchy;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.data.provider.ArrayUpdater;
import com.vaadin.flow.data.provider.DataCommunicatorTest;
import com.vaadin.flow.data.provider.hierarchy.TreeData;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import tools.jackson.databind.JsonNode;

public abstract class AbstractHierarchicalDataCommunicatorTest {
    @Mock
    protected ArrayUpdater arrayUpdater;
    @Mock
    protected ArrayUpdater.Update arrayUpdate;
    protected DataCommunicatorTest.MockUI ui = new DataCommunicatorTest.MockUI();

    @Before
    public void init() {
        MockitoAnnotations.openMocks((Object)this);
        Mockito.when((Object)this.arrayUpdater.startUpdate(Mockito.anyInt())).thenReturn((Object)this.arrayUpdate);
    }

    @After
    public void tearDown() {
        UI.setCurrent(null);
    }

    protected void fakeClientCommunication() {
        this.ui.getInternals().getStateTree().runExecutionsBeforeClientResponse();
        this.ui.getInternals().getStateTree().collectChanges(ignore -> {});
    }

    protected void assertArrayUpdateItems(String property, String ... expected) {
        Assert.assertEquals(Arrays.asList(expected), this.captureArrayUpdateItems().values().stream().map(item -> item.get(property).asString()).toList());
    }

    protected void assertArrayUpdateItems(String property, Map<Integer, String> expected) {
        Assert.assertEquals(expected, this.captureArrayUpdateItems().entrySet().stream().collect(Collectors.toMap(entry -> (Integer)entry.getKey(), entry -> ((JsonNode)entry.getValue()).get(property).asString())));
    }

    protected void assertArrayUpdateRange(int start, int length) {
        int end = start + length;
        int size = this.captureArrayUpdateSize();
        ((ArrayUpdater.Update)Mockito.verify((Object)this.arrayUpdate, (VerificationMode)(start > 0 ? Mockito.times((int)1) : Mockito.never()))).clear(0, start);
        ((ArrayUpdater.Update)Mockito.verify((Object)this.arrayUpdate, (VerificationMode)(end < size ? Mockito.times((int)1) : Mockito.never()))).clear(end, size - end);
        ((ArrayUpdater.Update)Mockito.verify((Object)this.arrayUpdate, (VerificationMode)Mockito.atMost((int)length))).set(Mockito.intThat(index -> start <= index && index < end), Mockito.anyList());
    }

    protected void assertArrayUpdateSize(int size) {
        ((ArrayUpdater)Mockito.verify((Object)this.arrayUpdater)).startUpdate(size);
    }

    protected Map<Integer, JsonNode> captureArrayUpdateItems() {
        ArgumentCaptor itemsCaptor = ArgumentCaptor.forClass(List.class);
        ArgumentCaptor indexCaptor = ArgumentCaptor.forClass(Integer.class);
        ((ArrayUpdater.Update)Mockito.verify((Object)this.arrayUpdate, (VerificationMode)Mockito.atLeast((int)0))).set(((Integer)indexCaptor.capture()).intValue(), (List)itemsCaptor.capture());
        LinkedHashMap<Integer, JsonNode> result = new LinkedHashMap<Integer, JsonNode>();
        for (int i = 0; i < indexCaptor.getAllValues().size(); ++i) {
            Integer index = (Integer)indexCaptor.getAllValues().get(i);
            List items = (List)itemsCaptor.getAllValues().get(i);
            for (int j = 0; j < items.size(); ++j) {
                result.put(index + j, (JsonNode)items.get(j));
            }
        }
        return result;
    }

    protected int captureArrayUpdateSize() {
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(Integer.class);
        ((ArrayUpdater)Mockito.verify((Object)this.arrayUpdater)).startUpdate(((Integer)argumentCaptor.capture()).intValue());
        return (Integer)argumentCaptor.getValue();
    }

    protected void populateTreeData(TreeData<Item> treeData, int ... levelSizes) {
        treeData.clear();
        this.populateTreeData(treeData, null, levelSizes);
    }

    private void populateTreeData(TreeData<Item> treeData, Item parentItem, int ... levelSizes) {
        for (int i = 0; i < levelSizes[0]; ++i) {
            Item item = parentItem != null ? new Item(parentItem.getName() + "-" + i) : new Item("Item " + i, "initial");
            treeData.addItem((Object)parentItem, (Object)item);
            if (levelSizes.length <= 1) continue;
            this.populateTreeData(treeData, item, Arrays.copyOfRange(levelSizes, 1, levelSizes.length));
        }
    }

    public static class Item {
        private String name;
        private String state;

        public Item(String name) {
            this.name = name;
            this.state = "initial";
        }

        public Item(String name, String state) {
            this.name = name;
            this.state = state;
        }

        public String getState() {
            return this.state;
        }

        public void setState(String state) {
            this.state = state;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Item) {
                Item item = (Item)obj;
                return this.name.equals(item.name);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }
    }
}

