/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider.hierarchy;

import com.vaadin.flow.data.provider.ArrayUpdater;
import com.vaadin.flow.data.provider.CompositeDataGenerator;
import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.data.provider.QuerySortOrder;
import com.vaadin.flow.data.provider.QuerySortOrderBuilder;
import com.vaadin.flow.data.provider.SortDirection;
import com.vaadin.flow.data.provider.hierarchy.AbstractBackEndHierarchicalDataProvider;
import com.vaadin.flow.data.provider.hierarchy.AbstractHierarchicalDataCommunicatorTest;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalDataCommunicator;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalDataProvider;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalQuery;
import com.vaadin.flow.data.provider.hierarchy.TreeData;
import com.vaadin.flow.data.provider.hierarchy.TreeDataProvider;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableComparator;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.SerializableSupplier;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class HierarchicalDataCommunicatorBasicTest
extends AbstractHierarchicalDataCommunicatorTest {
    private TreeData<AbstractHierarchicalDataCommunicatorTest.Item> treeData = new TreeData();
    private TreeDataProvider<AbstractHierarchicalDataCommunicatorTest.Item> treeDataProvider = new TreeDataProvider(this.treeData);
    private CompositeDataGenerator<AbstractHierarchicalDataCommunicatorTest.Item> compositeDataGenerator = new CompositeDataGenerator();
    private HierarchicalDataCommunicator<AbstractHierarchicalDataCommunicatorTest.Item> dataCommunicator;

    @Override
    @Before
    public void init() {
        super.init();
        Element element = new Element("div");
        this.dataCommunicator = new HierarchicalDataCommunicator(this.compositeDataGenerator, this.arrayUpdater, element.getNode(), (SerializableSupplier & Serializable)() -> null);
        this.compositeDataGenerator.addDataGenerator((DataGenerator & Serializable)(item, json) -> json.put("name", item.getName()));
        this.ui.getElement().appendChild(new Element[]{element});
    }

    @Test
    public void flush_emptyRangeSent() {
        this.fakeClientCommunication();
        this.assertArrayUpdateSize(0);
        this.assertArrayUpdateRange(0, 0);
    }

    @Test
    public void setViewportRange_flush_emptyRangeSent() {
        this.dataCommunicator.setViewportRange(0, 50);
        this.fakeClientCommunication();
        this.assertArrayUpdateSize(0);
        this.assertArrayUpdateRange(0, 0);
    }

    @Test
    public void flush_arrayUpdaterInitializedOnce() {
        this.fakeClientCommunication();
        ((ArrayUpdater)Mockito.verify((Object)this.arrayUpdater, (VerificationMode)Mockito.times((int)1))).initialize();
        Mockito.clearInvocations((Object[])new ArrayUpdater[]{this.arrayUpdater});
        this.fakeClientCommunication();
        ((ArrayUpdater)Mockito.verify((Object)this.arrayUpdater, (VerificationMode)Mockito.never())).initialize();
    }

    @Test
    public void setViewportRange_flush_arrayUpdaterInitializedOnce() {
        this.dataCommunicator.setViewportRange(0, 50);
        this.fakeClientCommunication();
        ((ArrayUpdater)Mockito.verify((Object)this.arrayUpdater, (VerificationMode)Mockito.times((int)1))).initialize();
        Mockito.clearInvocations((Object[])new ArrayUpdater[]{this.arrayUpdater});
        this.dataCommunicator.setViewportRange(50, 50);
        this.fakeClientCommunication();
        ((ArrayUpdater)Mockito.verify((Object)this.arrayUpdater, (VerificationMode)Mockito.never())).initialize();
    }

    @Test
    public void setDataProvider_getDataProvider() {
        this.dataCommunicator.setDataProvider(this.treeDataProvider, null);
        Assert.assertEquals(this.treeDataProvider, (Object)this.dataCommunicator.getDataProvider());
    }

    @Test
    public void setDataProvider_expandItem_setAnotherDataProvider_expandedItemsCleared() {
        this.populateTreeData(this.treeData, 100, 2, 2);
        this.dataCommunicator.setDataProvider((HierarchicalDataProvider)new TreeDataProvider(this.treeData), null);
        this.dataCommunicator.expand((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"));
        Assert.assertTrue((boolean)this.dataCommunicator.isExpanded((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0")));
        this.dataCommunicator.setDataProvider((HierarchicalDataProvider)new TreeDataProvider(this.treeData), null);
        Assert.assertFalse((boolean)this.dataCommunicator.isExpanded((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0")));
    }

    @Test
    public void setIncompatibleDataProvider_throws() {
        ListDataProvider incompatibleDataProvider = DataProvider.ofItems((Object[])new AbstractHierarchicalDataCommunicatorTest.Item[]{new AbstractHierarchicalDataCommunicatorTest.Item("Item 0")});
        Assert.assertThrows(IllegalArgumentException.class, () -> this.dataCommunicator.setDataProvider((DataProvider)incompatibleDataProvider, null));
    }

    @Test
    public void setDataProviderWithNullItems_setViewport_throws() {
        this.dataCommunicator.setDataProvider((HierarchicalDataProvider)new AbstractBackEndHierarchicalDataProvider<AbstractHierarchicalDataCommunicatorTest.Item, Void>(){

            public Stream<AbstractHierarchicalDataCommunicatorTest.Item> fetchChildrenFromBackEnd(HierarchicalQuery<AbstractHierarchicalDataCommunicatorTest.Item, Void> query) {
                return Stream.of(null, null, null);
            }

            public int getChildCount(HierarchicalQuery<AbstractHierarchicalDataCommunicatorTest.Item, Void> query) {
                return 3;
            }

            public boolean hasChildren(AbstractHierarchicalDataCommunicatorTest.Item item) {
                return false;
            }
        }, null);
        this.dataCommunicator.setViewportRange(0, 3);
        Assert.assertThrows(IllegalStateException.class, () -> this.fakeClientCommunication());
    }

    @Test
    public void setDataProviderWithNegativeChildCount_setViewport_throws() {
        this.dataCommunicator.setDataProvider((HierarchicalDataProvider)new AbstractBackEndHierarchicalDataProvider<AbstractHierarchicalDataCommunicatorTest.Item, Void>(){

            public Stream<AbstractHierarchicalDataCommunicatorTest.Item> fetchChildrenFromBackEnd(HierarchicalQuery<AbstractHierarchicalDataCommunicatorTest.Item, Void> query) {
                return Stream.of(new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 1"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 2"));
            }

            public int getChildCount(HierarchicalQuery<AbstractHierarchicalDataCommunicatorTest.Item, Void> query) {
                return -3;
            }

            public boolean hasChildren(AbstractHierarchicalDataCommunicatorTest.Item item) {
                return false;
            }
        }, null);
        this.dataCommunicator.setViewportRange(0, 3);
        Assert.assertThrows(IllegalStateException.class, () -> this.fakeClientCommunication());
    }

    @Test
    public void getDepth_returnsDepthForViewportItems() {
        this.populateTreeData(this.treeData, 100, 1, 1);
        this.dataCommunicator.setDataProvider(this.treeDataProvider, null);
        this.dataCommunicator.expand(Arrays.asList(new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0")));
        this.dataCommunicator.setViewportRange(0, 4);
        Assert.assertEquals((long)-1L, (long)this.dataCommunicator.getDepth((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0")));
        Assert.assertEquals((long)-1L, (long)this.dataCommunicator.getDepth((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0")));
        Assert.assertEquals((long)-1L, (long)this.dataCommunicator.getDepth((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0-0")));
        Assert.assertEquals((long)-1L, (long)this.dataCommunicator.getDepth((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 1")));
        this.fakeClientCommunication();
        Assert.assertEquals((long)0L, (long)this.dataCommunicator.getDepth((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0")));
        Assert.assertEquals((long)1L, (long)this.dataCommunicator.getDepth((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0")));
        Assert.assertEquals((long)2L, (long)this.dataCommunicator.getDepth((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0-0")));
        Assert.assertEquals((long)0L, (long)this.dataCommunicator.getDepth((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 1")));
        this.dataCommunicator.setViewportRange(4, 4);
        this.fakeClientCommunication();
        Assert.assertEquals((long)-1L, (long)this.dataCommunicator.getDepth((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0")));
        Assert.assertEquals((long)0L, (long)this.dataCommunicator.getDepth((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 5")));
    }

    @Test
    public void getDepth_doesNotReturnDepthForNonExistingItems() {
        this.populateTreeData(this.treeData, 100, 1, 1);
        this.dataCommunicator.setDataProvider(this.treeDataProvider, null);
        this.dataCommunicator.setViewportRange(0, 4);
        this.fakeClientCommunication();
        Assert.assertEquals((long)-1L, (long)this.dataCommunicator.getDepth((Object)new AbstractHierarchicalDataCommunicatorTest.Item("NOT EXISTING")));
    }

    @Test
    public void hasChildren_returnsValueBasedOnDataProvider() {
        this.dataCommunicator.setDataProvider(this.treeDataProvider, null);
        this.populateTreeData(this.treeData, 1, 1);
        Assert.assertTrue((boolean)this.dataCommunicator.hasChildren((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0")));
        Assert.assertFalse((boolean)this.dataCommunicator.hasChildren((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0")));
        this.populateTreeData(this.treeData, 1);
        Assert.assertFalse((boolean)this.dataCommunicator.hasChildren((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0")));
        Assert.assertFalse((boolean)this.dataCommunicator.hasChildren((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0")));
    }

    @Test
    public void expandCollectionOfItems_returnsEffectivelyExpandedItems() {
        this.populateTreeData(this.treeData, 4, 1, 1);
        this.dataCommunicator.setDataProvider(this.treeDataProvider, null);
        Assert.assertEquals(Arrays.asList(new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0")), (Object)this.dataCommunicator.expand(Arrays.asList(new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0-0"))));
        Assert.assertEquals(Arrays.asList(new AbstractHierarchicalDataCommunicatorTest.Item("Item 1")), (Object)this.dataCommunicator.expand(Arrays.asList(new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 1"))));
    }

    @Test
    public void collapseCollectionOfItems_returnsEffectivelyCollapsedItems() {
        this.populateTreeData(this.treeData, 4, 1, 1);
        this.dataCommunicator.setDataProvider(this.treeDataProvider, null);
        this.dataCommunicator.expand(Arrays.asList(new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0")));
        Assert.assertEquals(Arrays.asList(new AbstractHierarchicalDataCommunicatorTest.Item("Item 0")), (Object)this.dataCommunicator.collapse(Arrays.asList(new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 1"))));
    }

    @Test
    public void setFilterViaDataProvider_filterApplied() {
        this.populateTreeData(this.treeData, 3, 2, 1);
        this.dataCommunicator.setDataProvider(this.treeDataProvider, (SerializablePredicate & Serializable)item -> item.equals(new AbstractHierarchicalDataCommunicatorTest.Item("Item 1")) || item.equals(new AbstractHierarchicalDataCommunicatorTest.Item("Item 1-1")));
        this.dataCommunicator.expand((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 1"));
        this.dataCommunicator.setViewportRange(0, 10);
        this.fakeClientCommunication();
        this.assertArrayUpdateSize(2);
        this.assertArrayUpdateItems("name", "Item 1", "Item 1-1");
        Mockito.clearInvocations((Object[])new Serializable[]{this.arrayUpdater, this.arrayUpdate});
        this.dataCommunicator.setDataProvider(this.treeDataProvider, (SerializablePredicate & Serializable)item -> item.equals(new AbstractHierarchicalDataCommunicatorTest.Item("Item 0")));
        this.fakeClientCommunication();
        this.assertArrayUpdateSize(1);
        this.assertArrayUpdateItems("name", "Item 0");
    }

    @Test
    public void setFilterViaCallback_filterApplied() {
        this.populateTreeData(this.treeData, 3, 2, 1);
        SerializableConsumer filterCallback = this.dataCommunicator.setDataProvider(this.treeDataProvider, null);
        this.dataCommunicator.expand((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 1"));
        this.dataCommunicator.setViewportRange(0, 10);
        filterCallback.accept((SerializablePredicate & Serializable)item -> item.equals(new AbstractHierarchicalDataCommunicatorTest.Item("Item 1")) || item.equals(new AbstractHierarchicalDataCommunicatorTest.Item("Item 1-1")));
        this.fakeClientCommunication();
        this.assertArrayUpdateSize(2);
        this.assertArrayUpdateItems("name", "Item 1", "Item 1-1");
        Mockito.clearInvocations((Object[])new Serializable[]{this.arrayUpdater, this.arrayUpdate});
        filterCallback.accept((SerializablePredicate & Serializable)item -> item.equals(new AbstractHierarchicalDataCommunicatorTest.Item("Item 0")));
        this.fakeClientCommunication();
        this.assertArrayUpdateSize(1);
        this.assertArrayUpdateItems("name", "Item 0");
    }

    @Test
    public void setInMemorySorting_sortingApplied() {
        this.populateTreeData(this.treeData, 3, 2, 1);
        this.dataCommunicator.setDataProvider(this.treeDataProvider, null);
        this.dataCommunicator.expand((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 1"));
        this.dataCommunicator.setViewportRange(0, 10);
        this.dataCommunicator.setInMemorySorting(Comparator.comparing(AbstractHierarchicalDataCommunicatorTest.Item::getName).reversed()::compare);
        this.fakeClientCommunication();
        this.assertArrayUpdateSize(5);
        this.assertArrayUpdateItems("name", "Item 2", "Item 1", "Item 1-1", "Item 1-0", "Item 0");
        Mockito.clearInvocations((Object[])new Serializable[]{this.arrayUpdater, this.arrayUpdate});
        this.dataCommunicator.setInMemorySorting(null);
        this.fakeClientCommunication();
        this.assertArrayUpdateSize(5);
        this.assertArrayUpdateItems("name", "Item 0", "Item 1", "Item 1-0", "Item 1-1", "Item 2");
    }

    @Test
    public void setBackendSorting_sortingApplied() {
        this.populateTreeData(this.treeData, 3, 2, 1);
        this.dataCommunicator.setDataProvider((HierarchicalDataProvider)new AbstractBackEndHierarchicalDataProvider<AbstractHierarchicalDataCommunicatorTest.Item, Void>(){

            public Stream<AbstractHierarchicalDataCommunicatorTest.Item> fetchChildrenFromBackEnd(HierarchicalQuery<AbstractHierarchicalDataCommunicatorTest.Item, Void> query) {
                Comparator<AbstractHierarchicalDataCommunicatorTest.Item> sortComparator = null;
                if (!query.getSortOrders().isEmpty()) {
                    QuerySortOrder sortOrder = (QuerySortOrder)query.getSortOrders().get(0);
                    if (((String)sortOrder.getSorted()).equals("name")) {
                        sortComparator = Comparator.comparing(AbstractHierarchicalDataCommunicatorTest.Item::getName);
                    }
                    if (sortOrder.getDirection().equals((Object)SortDirection.DESCENDING)) {
                        sortComparator = sortComparator.reversed();
                    }
                }
                Stream<AbstractHierarchicalDataCommunicatorTest.Item> items = HierarchicalDataCommunicatorBasicTest.this.treeData.getChildren((Object)((AbstractHierarchicalDataCommunicatorTest.Item)query.getParent())).stream();
                if (sortComparator != null) {
                    items = items.sorted(sortComparator);
                }
                return items;
            }

            public int getChildCount(HierarchicalQuery<AbstractHierarchicalDataCommunicatorTest.Item, Void> query) {
                return HierarchicalDataCommunicatorBasicTest.this.treeData.getChildren((Object)((AbstractHierarchicalDataCommunicatorTest.Item)query.getParent())).size();
            }

            public boolean hasChildren(AbstractHierarchicalDataCommunicatorTest.Item item) {
                return !HierarchicalDataCommunicatorBasicTest.this.treeData.getChildren((Object)item).isEmpty();
            }
        }, null);
        this.dataCommunicator.expand((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 1"));
        this.dataCommunicator.setViewportRange(0, 10);
        this.dataCommunicator.setBackEndSorting(new QuerySortOrderBuilder().thenDesc("name").build());
        this.fakeClientCommunication();
        this.assertArrayUpdateSize(5);
        this.assertArrayUpdateItems("name", "Item 2", "Item 1", "Item 1-1", "Item 1-0", "Item 0");
        Mockito.clearInvocations((Object[])new Serializable[]{this.arrayUpdater, this.arrayUpdate});
        this.dataCommunicator.setBackEndSorting(Collections.emptyList());
        this.fakeClientCommunication();
        this.assertArrayUpdateSize(5);
        this.assertArrayUpdateItems("name", "Item 0", "Item 1", "Item 1-0", "Item 1-1", "Item 2");
    }

    @Test
    public void buildQuery_correctQueryReturned() {
        List sortOrders = new QuerySortOrderBuilder().thenDesc("name").build();
        SerializablePredicate & Serializable filter = (SerializablePredicate & Serializable)f -> true;
        SerializableComparator & Serializable comparator = Comparator.comparing(AbstractHierarchicalDataCommunicatorTest.Item::getName).reversed()::compare;
        this.dataCommunicator.setDataProvider(this.treeDataProvider, (Object)filter);
        this.dataCommunicator.setInMemorySorting((SerializableComparator)comparator);
        this.dataCommunicator.setBackEndSorting(sortOrders);
        HierarchicalQuery query = this.dataCommunicator.buildQuery(10, 20);
        Assert.assertNull((Object)query.getParent());
        Assert.assertEquals((long)10L, (long)query.getOffset());
        Assert.assertEquals((long)20L, (long)query.getLimit());
        Assert.assertEquals((Object)filter, query.getFilter().get());
        Assert.assertEquals((Object)sortOrders, (Object)query.getSortOrders());
        Assert.assertEquals((Object)comparator, (Object)query.getInMemorySorting());
        Assert.assertEquals(Collections.emptySet(), (Object)query.getExpandedItemIds());
        query = this.dataCommunicator.buildQuery((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Parent"), 10, 20);
        Assert.assertEquals((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Parent"), (Object)query.getParent());
        Assert.assertEquals((long)10L, (long)query.getOffset());
        Assert.assertEquals((long)20L, (long)query.getLimit());
        Assert.assertEquals((Object)filter, query.getFilter().get());
        Assert.assertEquals((Object)sortOrders, (Object)query.getSortOrders());
        Assert.assertEquals((Object)comparator, (Object)query.getInMemorySorting());
        Assert.assertEquals(Collections.emptySet(), (Object)query.getExpandedItemIds());
    }
}

