/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.data.provider.AbstractLazyDataView;
import com.vaadin.flow.data.provider.BackEndDataProvider;
import com.vaadin.flow.data.provider.CallbackDataProvider;
import com.vaadin.flow.data.provider.DataCommunicator;
import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.data.provider.HasLazyDataView;
import java.io.Serializable;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class HasLazyDataViewTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void setItemsCountCallback_switchesToDefinedSize_throwsOnSizeQuery() {
        TestComponent testComponent = new TestComponent();
        testComponent.setItems((CallbackDataProvider.FetchCallback & Serializable)query -> Stream.of("foo", "bar", "baz"));
        Assert.assertFalse((boolean)testComponent.getLazyDataView().getDataCommunicator().isDefinedSize());
        testComponent.getLazyDataView().setItemCountFromDataProvider();
        Assert.assertTrue((boolean)testComponent.getLazyDataView().getDataCommunicator().isDefinedSize());
        this.expectedException.expect(IllegalStateException.class);
        testComponent.getDataCommunicator().getItemCount();
    }

    @Tag(value="test-component")
    private static class TestComponent
    extends Component
    implements HasLazyDataView<String, Void, AbstractLazyDataView<String>> {
        private DataCommunicator<String> dataCommunicator = new DataCommunicator((DataGenerator & Serializable)(item, jsonObject) -> {}, null, null, this.getElement().getNode());

        public AbstractLazyDataView<String> setItems(BackEndDataProvider<String, Void> dataProvider) {
            this.dataCommunicator.setDataProvider(dataProvider, null);
            return this.getLazyDataView();
        }

        public AbstractLazyDataView<String> getLazyDataView() {
            return new AbstractLazyDataView<String>(this.dataCommunicator, (Component)this){};
        }

        public DataCommunicator<String> getDataCommunicator() {
            return this.dataCommunicator;
        }
    }
}

