/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider.hierarchy;

import com.vaadin.flow.data.provider.hierarchy.Cache;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

class RootCache<T>
extends Cache<T> {
    private final ValueProvider<T, Object> itemIdProvider;
    private final Map<Object, ItemContext<T>> itemIdToContext = new HashMap<Object, ItemContext<T>>();

    public RootCache(int size, ValueProvider<T, Object> itemIdProvider) {
        super(null, null, size);
        this.itemIdProvider = itemIdProvider;
    }

    public int getFlatSize() {
        return this.getFlatSize(this);
    }

    private int getFlatSize(Cache<T> cache) {
        return cache.getSize() + cache.getSubCaches().stream().mapToInt(entry -> this.getFlatSize((Cache)entry.getValue())).sum();
    }

    public ItemContext<T> getContextByFlatIndex(int flatIndex) {
        return this.getContextByFlatIndex(this, flatIndex);
    }

    private ItemContext<T> getContextByFlatIndex(Cache<T> cache, int localFlatIndex) {
        int index = localFlatIndex;
        for (Map.Entry<Integer, Cache<T>> entry : cache.getSubCaches()) {
            Cache<T> subCache = entry.getValue();
            Integer subCacheIndex = entry.getKey();
            int subCacheFlatSize = this.getFlatSize(subCache);
            if (index <= subCacheIndex) break;
            if (index <= subCacheIndex + subCacheFlatSize) {
                return this.getContextByFlatIndex(subCache, index - subCacheIndex - 1);
            }
            index -= subCacheFlatSize;
        }
        if (index >= cache.getSize() || index < 0) {
            return null;
        }
        return new ItemContext<T>(cache, index);
    }

    public int getFlatIndexByPath(int ... path) {
        return this.getFlatIndexByPath(this, path);
    }

    private int getFlatIndexByPath(Cache<T> cache, int ... path) {
        int[] restPath = Arrays.copyOfRange(path, 1, path.length);
        int index = Math.min(path[0], cache.getSize() - 1);
        if (index < 0) {
            index = Math.max(cache.getSize() + index, 0);
        }
        int flatIndex = this.flattenIndex(cache, index);
        Cache<T> subCache = cache.getSubCache(index);
        if (subCache != null && this.getFlatSize(subCache) > 0 && restPath.length > 0) {
            return flatIndex + 1 + this.getFlatIndexByPath(subCache, restPath);
        }
        return flatIndex;
    }

    private int flattenIndex(Cache<T> cache, int index) {
        return cache.getSubCaches().stream().reduce(index, (prev, entry) -> {
            Integer subCacheIndex = (Integer)entry.getKey();
            Cache subCache = (Cache)entry.getValue();
            return index > subCacheIndex ? prev + this.getFlatSize(subCache) : prev;
        }, Integer::sum);
    }

    public ItemContext<T> getContextByItem(T item) {
        Object itemId = this.getItemId(item);
        return this.itemIdToContext.get(itemId);
    }

    public void removeDescendantItemIf(SerializablePredicate<T> predicate) {
        this.itemIdToContext.values().stream().filter(itemContext -> {
            Cache cache = itemContext.cache();
            int index = itemContext.index();
            Object item = cache.getItem(index);
            return predicate.test(item);
        }).toList().forEach(itemContext -> {
            Cache cache = itemContext.cache();
            int index = itemContext.index();
            cache.removeItem(index);
        });
    }

    void addItemContext(T item, Cache<T> cache, int index) {
        Object itemId = this.getItemId(item);
        this.itemIdToContext.put(itemId, new ItemContext<T>(cache, index));
    }

    void removeItemContext(T item) {
        Object itemId = this.getItemId(item);
        this.itemIdToContext.remove(itemId);
    }

    Object getItemId(T item) {
        return this.itemIdProvider.apply(item);
    }

    record ItemContext<T>(Cache<T> cache, int index) implements Serializable
    {
    }
}

