/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider.hierarchy;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.flow.data.provider.CompositeDataGenerator;
import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.data.provider.DataKeyMapper;
import com.vaadin.flow.data.provider.hierarchy.AbstractHierarchicalDataCommunicatorTest;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalDataCommunicator;
import com.vaadin.flow.data.provider.hierarchy.TreeData;
import com.vaadin.flow.data.provider.hierarchy.TreeDataProvider;
import com.vaadin.flow.function.SerializableSupplier;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class HierarchicalDataCommunicatorDataRefreshTest
extends AbstractHierarchicalDataCommunicatorTest {
    private TreeData<AbstractHierarchicalDataCommunicatorTest.Item> treeData = new TreeData();
    private TreeDataProvider<AbstractHierarchicalDataCommunicatorTest.Item> treeDataProvider = new TreeDataProvider(this.treeData);
    private CompositeDataGenerator<AbstractHierarchicalDataCommunicatorTest.Item> compositeDataGenerator = new CompositeDataGenerator();
    private HierarchicalDataCommunicator<AbstractHierarchicalDataCommunicatorTest.Item> dataCommunicator;
    private DataKeyMapper<AbstractHierarchicalDataCommunicatorTest.Item> keyMapper;

    @Override
    @Before
    public void init() {
        super.init();
        this.dataCommunicator = new HierarchicalDataCommunicator(this.compositeDataGenerator, this.arrayUpdater, this.ui.getElement().getNode(), (SerializableSupplier & Serializable)() -> null);
        this.dataCommunicator.setDataProvider(this.treeDataProvider, null);
        this.keyMapper = this.dataCommunicator.getKeyMapper();
        this.compositeDataGenerator.addDataGenerator((DataGenerator & Serializable)(item, json) -> {
            json.put("name", item.getName());
            json.put("state", item.getState());
        });
    }

    @Test
    public void refreshItemThroughDataProvider_refreshMethodCalled() {
        HierarchicalDataCommunicator dataCommunicatorSpy = (HierarchicalDataCommunicator)Mockito.spy(this.dataCommunicator);
        dataCommunicatorSpy.setDataProvider(this.treeDataProvider, null);
        AbstractHierarchicalDataCommunicatorTest.Item item = new AbstractHierarchicalDataCommunicatorTest.Item("Item 0");
        this.treeDataProvider.refreshItem((Object)item);
        ((HierarchicalDataCommunicator)Mockito.verify((Object)dataCommunicatorSpy)).refresh((Object)item, false);
        this.treeDataProvider.refreshItem((Object)item, true);
        ((HierarchicalDataCommunicator)Mockito.verify((Object)dataCommunicatorSpy)).refresh((Object)item, true);
    }

    @Test
    public void refreshAllThroughDataProvider_resetMethodCalled() {
        HierarchicalDataCommunicator dataCommunicatorSpy = (HierarchicalDataCommunicator)Mockito.spy(this.dataCommunicator);
        dataCommunicatorSpy.setDataProvider(this.treeDataProvider, null);
        Mockito.clearInvocations((Object[])new HierarchicalDataCommunicator[]{dataCommunicatorSpy});
        this.treeDataProvider.refreshAll();
        ((HierarchicalDataCommunicator)Mockito.verify((Object)dataCommunicatorSpy)).reset();
    }

    @Test
    public void refreshRootItems_updatedRangeSent() {
        this.populateTreeData(this.treeData, 4);
        this.dataCommunicator.expand((Collection)this.treeData.getRootItems());
        this.dataCommunicator.setViewportRange(0, 4);
        this.fakeClientCommunication();
        this.assertArrayUpdateItems("name", Map.of(0, "Item 0", 1, "Item 1", 2, "Item 2", 3, "Item 3"));
        this.assertArrayUpdateItems("state", Map.of(0, "initial", 1, "initial", 2, "initial", 3, "initial"));
        Mockito.clearInvocations((Object[])new Serializable[]{this.arrayUpdater, this.arrayUpdate});
        AbstractHierarchicalDataCommunicatorTest.Item item0 = new AbstractHierarchicalDataCommunicatorTest.Item("Item 0", "refreshed");
        this.dataCommunicator.refresh((Object)item0);
        AbstractHierarchicalDataCommunicatorTest.Item item2 = new AbstractHierarchicalDataCommunicatorTest.Item("Item 2", "refreshed");
        this.dataCommunicator.refresh((Object)item2);
        this.fakeClientCommunication();
        this.assertArrayUpdateItems("name", Map.of(0, "Item 0", 2, "Item 2"));
        this.assertArrayUpdateItems("state", Map.of(0, "refreshed", 2, "refreshed"));
    }

    @Test
    public void refreshNestedItems_updatedRangeSent() {
        this.populateTreeData(this.treeData, 2, 1, 1);
        this.dataCommunicator.expand(Arrays.asList(new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0")));
        this.dataCommunicator.setViewportRange(0, 4);
        this.fakeClientCommunication();
        this.assertArrayUpdateItems("name", Map.of(0, "Item 0", 1, "Item 0-0", 2, "Item 0-0-0", 3, "Item 1"));
        this.assertArrayUpdateItems("state", Map.of(0, "initial", 1, "initial", 2, "initial", 3, "initial"));
        Mockito.clearInvocations((Object[])new Serializable[]{this.arrayUpdater, this.arrayUpdate});
        AbstractHierarchicalDataCommunicatorTest.Item item0_0 = new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0", "refreshed");
        this.dataCommunicator.refresh((Object)item0_0);
        AbstractHierarchicalDataCommunicatorTest.Item item0_0_0 = new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0-0", "refreshed");
        this.dataCommunicator.refresh((Object)item0_0_0);
        this.fakeClientCommunication();
        this.assertArrayUpdateItems("name", Map.of(1, "Item 0-0", 2, "Item 0-0-0"));
        this.assertArrayUpdateItems("state", Map.of(1, "refreshed", 2, "refreshed"));
    }

    @Test
    public void refreshItemsOutOfViewport_updatedRangeSentOnlyAfterItemEntersViewport() {
        this.populateTreeData(this.treeData, 50, 1);
        this.dataCommunicator.expand((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 49"));
        this.dataCommunicator.setViewportRange(0, 3);
        this.fakeClientCommunication();
        Mockito.clearInvocations((Object[])new Serializable[]{this.arrayUpdater, this.arrayUpdate});
        AbstractHierarchicalDataCommunicatorTest.Item item = (AbstractHierarchicalDataCommunicatorTest.Item)this.treeData.getRootItems().get(49);
        item.setState("refreshed");
        this.dataCommunicator.refresh((Object)item);
        this.fakeClientCommunication();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.arrayUpdater, this.arrayUpdate});
        this.dataCommunicator.setViewportRange(48, 3);
        this.fakeClientCommunication();
        this.assertArrayUpdateItems("name", Map.of(48, "Item 48", 49, "Item 49", 50, "Item 49-0"));
        this.assertArrayUpdateItems("state", Map.of(48, "initial", 49, "refreshed", 50, "initial"));
    }

    @Test
    public void refreshItems_dataGeneratorRefreshItemCalled() {
        this.populateTreeData(this.treeData, 2, 1, 1);
        1 dataGenerator = Mockito.spy((Object)new DataGenerator<AbstractHierarchicalDataCommunicatorTest.Item>(){

            public void generateData(AbstractHierarchicalDataCommunicatorTest.Item item, ObjectNode json) {
            }
        });
        this.compositeDataGenerator.addDataGenerator((DataGenerator)dataGenerator);
        AbstractHierarchicalDataCommunicatorTest.Item item = new AbstractHierarchicalDataCommunicatorTest.Item("Item 0", "refreshed");
        this.dataCommunicator.refresh((Object)item);
        (Mockito.verify((Object)dataGenerator, (VerificationMode)Mockito.only())).refreshData(item);
    }

    @Test
    public void refreshItems_itemRefreshedInKeyMapper() {
        this.populateTreeData(this.treeData, 2, 1, 1);
        this.dataCommunicator.expand(Arrays.asList(new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0")));
        this.dataCommunicator.setViewportRange(0, 4);
        this.fakeClientCommunication();
        List<String> keys = this.captureArrayUpdateItems().values().stream().map(item -> item.get("key").asText()).toList();
        Assert.assertEquals((Object)"initial", (Object)((AbstractHierarchicalDataCommunicatorTest.Item)this.keyMapper.get(keys.get(0))).getState());
        Assert.assertEquals((Object)"initial", (Object)((AbstractHierarchicalDataCommunicatorTest.Item)this.keyMapper.get(keys.get(1))).getState());
        Assert.assertEquals((Object)"initial", (Object)((AbstractHierarchicalDataCommunicatorTest.Item)this.keyMapper.get(keys.get(2))).getState());
        Assert.assertEquals((Object)"initial", (Object)((AbstractHierarchicalDataCommunicatorTest.Item)this.keyMapper.get(keys.get(3))).getState());
        AbstractHierarchicalDataCommunicatorTest.Item item0_0 = new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0", "refreshed");
        this.dataCommunicator.refresh((Object)item0_0);
        AbstractHierarchicalDataCommunicatorTest.Item item0_0_0 = new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0-0", "refreshed");
        this.dataCommunicator.refresh((Object)item0_0_0);
        Assert.assertEquals((Object)"initial", (Object)((AbstractHierarchicalDataCommunicatorTest.Item)this.keyMapper.get(keys.get(0))).getState());
        Assert.assertEquals((Object)"refreshed", (Object)((AbstractHierarchicalDataCommunicatorTest.Item)this.keyMapper.get(keys.get(1))).getState());
        Assert.assertEquals((Object)"refreshed", (Object)((AbstractHierarchicalDataCommunicatorTest.Item)this.keyMapper.get(keys.get(2))).getState());
        Assert.assertEquals((Object)"initial", (Object)((AbstractHierarchicalDataCommunicatorTest.Item)this.keyMapper.get(keys.get(3))).getState());
    }

    @Test
    public void refreshItemsWithChildren_updatedRangeSent() {
        this.populateTreeData(this.treeData, 2, 1, 1);
        this.dataCommunicator.expand(Arrays.asList(new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 1"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 1-0")));
        this.dataCommunicator.setViewportRange(0, 6);
        this.fakeClientCommunication();
        this.assertArrayUpdateItems("name", Map.of(0, "Item 0", 1, "Item 0-0", 2, "Item 0-0-0", 3, "Item 1", 4, "Item 1-0", 5, "Item 1-0-0"));
        Mockito.clearInvocations((Object[])new Serializable[]{this.arrayUpdater, this.arrayUpdate});
        this.treeData.setParent((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0"), (Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 1"));
        this.dataCommunicator.refresh((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"), true);
        this.dataCommunicator.refresh((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 1"), true);
        this.fakeClientCommunication();
        this.assertArrayUpdateItems("name", Map.of(0, "Item 0", 1, "Item 1", 2, "Item 1-0", 3, "Item 1-0-0", 4, "Item 0-0", 5, "Item 0-0-0"));
    }

    @Test
    public void refreshItemsWithChildren_dataGeneratorDestroyItemCalledForChildren() {
        this.populateTreeData(this.treeData, 1, 1, 1);
        this.dataCommunicator.expand(Arrays.asList(new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0")));
        this.dataCommunicator.setViewportRange(0, 3);
        this.fakeClientCommunication();
        2 dataGenerator = Mockito.spy((Object)new DataGenerator<AbstractHierarchicalDataCommunicatorTest.Item>(){

            public void generateData(AbstractHierarchicalDataCommunicatorTest.Item item, ObjectNode json) {
            }
        });
        this.compositeDataGenerator.addDataGenerator((DataGenerator)dataGenerator);
        this.dataCommunicator.refresh((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"), true);
        (Mockito.verify((Object)dataGenerator, (VerificationMode)Mockito.never())).destroyData(new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"));
        (Mockito.verify((Object)dataGenerator)).destroyData(new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0"));
        (Mockito.verify((Object)dataGenerator)).destroyData(new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0-0"));
    }

    @Test
    public void refreshItemsWithChildren_childrenRemovedFromKeyMapper() {
        this.populateTreeData(this.treeData, 1, 1, 1);
        this.dataCommunicator.expand(Arrays.asList(new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0")));
        this.dataCommunicator.setViewportRange(0, 3);
        this.fakeClientCommunication();
        this.dataCommunicator.refresh((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"), true);
        Assert.assertTrue((boolean)this.keyMapper.has((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0")));
        Assert.assertFalse((boolean)this.keyMapper.has((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0")));
        Assert.assertFalse((boolean)this.keyMapper.has((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0-0")));
    }

    @Test
    public void refreshAllItems_updatedRangeSent() {
        this.populateTreeData(this.treeData, 6, 1, 1);
        this.dataCommunicator.expand(Arrays.asList(new AbstractHierarchicalDataCommunicatorTest.Item("Item 1"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 1-0")));
        this.dataCommunicator.setViewportRange(0, 6);
        this.fakeClientCommunication();
        this.assertArrayUpdateItems("name", Map.of(0, "Item 0", 1, "Item 1", 2, "Item 1-0", 3, "Item 1-0-0", 4, "Item 2", 5, "Item 3"));
        Mockito.clearInvocations((Object[])new Serializable[]{this.arrayUpdater, this.arrayUpdate});
        this.treeData.removeItem((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"));
        this.treeData.removeItem((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 1-0"));
        this.dataCommunicator.reset();
        this.fakeClientCommunication();
        this.assertArrayUpdateItems("name", Map.of(0, "Item 1", 1, "Item 2", 2, "Item 3", 3, "Item 4", 4, "Item 5"));
    }

    @Test
    public void refreshAllItems_dataGeneratorDestroyAllDataCalled() {
        this.populateTreeData(this.treeData, 6, 1, 1);
        this.dataCommunicator.expand(Arrays.asList(new AbstractHierarchicalDataCommunicatorTest.Item("Item 1"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 1-0")));
        this.dataCommunicator.setViewportRange(0, 6);
        this.fakeClientCommunication();
        3 dataGenerator = Mockito.spy((Object)new DataGenerator<AbstractHierarchicalDataCommunicatorTest.Item>(){

            public void generateData(AbstractHierarchicalDataCommunicatorTest.Item item, ObjectNode json) {
            }
        });
        this.compositeDataGenerator.addDataGenerator((DataGenerator)dataGenerator);
        this.dataCommunicator.reset();
        (Mockito.verify((Object)dataGenerator)).destroyAllData();
        (Mockito.verify((Object)dataGenerator, (VerificationMode)Mockito.never())).destroyData((AbstractHierarchicalDataCommunicatorTest.Item)Mockito.any());
    }

    @Test
    public void refreshAllItems_allItemsRemovedFromKeyMapper() {
        this.populateTreeData(this.treeData, 1, 1, 1);
        this.dataCommunicator.expand(Arrays.asList(new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"), new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0")));
        this.dataCommunicator.setViewportRange(0, 3);
        this.fakeClientCommunication();
        this.dataCommunicator.reset();
        Assert.assertFalse((boolean)this.keyMapper.has((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0")));
        Assert.assertFalse((boolean)this.keyMapper.has((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0")));
        Assert.assertFalse((boolean)this.keyMapper.has((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0-0")));
    }
}

