/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.binder.testcomponents;

import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.data.binder.HasValidator;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.ValidationStatusChangeEvent;
import com.vaadin.flow.data.binder.ValidationStatusChangeListener;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.data.binder.testcomponents.TestDatePicker;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;

public class TestHasValidatorDatePicker {
    public static final String INVALID_DATE_FORMAT = "Invalid date format";

    public static class DataPickerHasValidatorOverridden
    extends DataPickerHasValidatorAddListenerOverridden {
        public Validator<LocalDate> getDefaultValidator() {
            return (Validator & Serializable)(value, context) -> this.validationStatus ? ValidationResult.ok() : ValidationResult.error((String)TestHasValidatorDatePicker.INVALID_DATE_FORMAT);
        }
    }

    public static class DataPickerHasValidatorAddListenerOverridden
    extends DatePickerHasValidatorDefaults {
        private final Collection<ValidationStatusChangeListener<LocalDate>> validationStatusListeners = new ArrayList<ValidationStatusChangeListener<LocalDate>>();

        public Registration addValidationStatusChangeListener(ValidationStatusChangeListener<LocalDate> listener) {
            this.validationStatusListeners.add(listener);
            return (Registration & Serializable)() -> this.validationStatusListeners.remove(listener);
        }

        public void fireValidationStatusChangeEvent(boolean newValidationStatus) {
            if (this.validationStatus != newValidationStatus) {
                this.validationStatus = newValidationStatus;
                ValidationStatusChangeEvent event = new ValidationStatusChangeEvent((HasValue)this, newValidationStatus);
                this.validationStatusListeners.forEach(listener -> listener.validationStatusChanged(event));
            }
        }

        public ValidationResult customValidation(LocalDate value, ValueContext context) {
            return this.validationStatus ? ValidationResult.ok() : ValidationResult.error((String)TestHasValidatorDatePicker.INVALID_DATE_FORMAT);
        }
    }

    public static class DataPickerHasValidatorGetDefaultValidatorOverridden
    extends DatePickerHasValidatorDefaults {
        public Validator<LocalDate> getDefaultValidator() {
            return (Validator & Serializable)(value, context) -> this.validationStatus ? ValidationResult.ok() : ValidationResult.error((String)TestHasValidatorDatePicker.INVALID_DATE_FORMAT);
        }
    }

    public static class DatePickerHasValidatorDefaults
    extends TestDatePicker
    implements HasValidator<LocalDate> {
        protected boolean validationStatus = true;
    }
}

