/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.validator;

import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.function.SerializableFunction;
import java.io.Serializable;
import java.util.Objects;

public abstract class AbstractValidator<T>
implements Validator<T> {
    private final SerializableFunction<T, String> messageProvider;

    protected AbstractValidator(String errorMessage) {
        Objects.requireNonNull(errorMessage, "error message cannot be null");
        this.messageProvider = (SerializableFunction & Serializable)value -> errorMessage.replace("{0}", String.valueOf(value));
    }

    protected String getMessage(T value) {
        return (String)this.messageProvider.apply(value);
    }

    protected ValidationResult toResult(T value, boolean isValid) {
        return isValid ? ValidationResult.ok() : ValidationResult.error(this.getMessage(value));
    }
}

