/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.fasterxml.jackson.databind.JsonNode;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.data.provider.AbstractDataProvider;
import com.vaadin.flow.data.provider.ArrayUpdater;
import com.vaadin.flow.data.provider.DataCommunicator;
import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.Range;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.shared.communication.PushMode;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=Parameterized.class)
public class DataCommunicatorAsyncTest {
    private DataCommunicator<Item> dataCommunicator;
    @Mock
    private DataGenerator<Item> dataGenerator;
    @Mock
    private ArrayUpdater arrayUpdater;
    private Element element;
    private MockUI ui;
    private ArrayUpdater.Update update;
    private CountDownLatch latch;
    private Executor executor;
    public Range lastClear = null;
    public Range lastSet = null;
    public int lastUpdateId = -1;
    private final boolean dataProviderWithParallelStream;

    public DataCommunicatorAsyncTest(boolean dataProviderWithParallelStream) {
        this.dataProviderWithParallelStream = dataProviderWithParallelStream;
    }

    @Parameterized.Parameters
    public static Collection<Boolean> testParameters() {
        return Arrays.asList(false, true);
    }

    @Before
    public void init() {
        MockitoAnnotations.initMocks((Object)this);
        this.ui = new MockUI();
        this.element = new Element("div");
        this.ui.getElement().appendChild(new Element[]{this.element});
        this.lastClear = null;
        this.lastSet = null;
        this.lastUpdateId = -1;
        this.executor = Executors.newCachedThreadPool();
        this.update = new ArrayUpdater.Update(){

            public void clear(int start, int length) {
                DataCommunicatorAsyncTest.this.lastClear = Range.withLength((int)start, (int)length);
            }

            public void set(int start, List<JsonNode> items) {
                DataCommunicatorAsyncTest.this.lastSet = Range.withLength((int)start, (int)items.size());
            }

            public void commit(int updateId) {
                DataCommunicatorAsyncTest.this.lastUpdateId = updateId;
            }
        };
        this.dataCommunicator = new DataCommunicator(this.dataGenerator, this.arrayUpdater, (SerializableConsumer & Serializable)data -> {}, this.element.getNode());
    }

    @Test(expected=IllegalStateException.class)
    public void asyncExcutorPushDisabledThrows() {
        this.ui.getPushConfiguration().setPushMode(PushMode.DISABLED);
        this.dataCommunicator.setDataProvider(this.createDataProvider(), null);
        this.dataCommunicator.enablePushUpdates(this.executor);
        this.dataCommunicator.setViewportRange(0, 50);
        this.fakeClientCommunication();
    }

    @Test
    public void asyncRequestedRangeHappensLater() {
        this.latch = new CountDownLatch(1);
        this.ui.getPushConfiguration().setPushMode(PushMode.AUTOMATIC);
        this.dataCommunicator.setDataProvider(this.createDataProvider(), null);
        this.dataCommunicator.enablePushUpdates(this.executor);
        this.dataCommunicator.setViewportRange(0, 50);
        this.fakeClientCommunication();
        Assert.assertNotEquals((String)"Expected initial reset not yet done.", (Object)Range.withLength((int)0, (int)50), (Object)this.lastSet);
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        Assert.assertEquals((String)"Expected initial full reset.", (Object)Range.withLength((int)0, (int)50), (Object)this.lastSet);
        this.lastSet = null;
        this.element.removeFromParent();
        this.fakeClientCommunication();
        Assert.assertNull((String)"Expected no during reattach.", (Object)this.lastSet);
        this.ui.getElement().appendChild(new Element[]{this.element});
        this.fakeClientCommunication();
        this.latch = new CountDownLatch(1);
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        Assert.assertEquals((String)"Expected initial full reset after reattach", (Object)Range.withLength((int)0, (int)50), (Object)this.lastSet);
    }

    private AbstractDataProvider<Item, Object> createDataProvider() {
        return this.createDataProvider(100);
    }

    private AbstractDataProvider<Item, Object> createDataProvider(final int items) {
        return new AbstractDataProvider<Item, Object>(){

            public boolean isInMemory() {
                return true;
            }

            public int size(Query<Item, Object> query) {
                return items;
            }

            public Stream<Item> fetch(Query<Item, Object> query) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                DataCommunicatorAsyncTest.this.lastSet = Range.withLength((int)query.getOffset(), (int)query.getLimit());
                DataCommunicatorAsyncTest.this.latch.countDown();
                return DataCommunicatorAsyncTest.this.asParallelIfRequired(IntStream.range(query.getOffset(), query.getLimit() + query.getOffset())).mapToObj(Item::new);
            }
        };
    }

    private IntStream asParallelIfRequired(IntStream stream) {
        if (this.dataProviderWithParallelStream) {
            return stream.parallel();
        }
        return stream;
    }

    private void fakeClientCommunication() {
        this.ui.getInternals().getStateTree().runExecutionsBeforeClientResponse();
        this.ui.getInternals().getStateTree().collectChanges(ignore -> {});
    }

    public static class MockUI
    extends UI {
        public MockUI() {
            this(MockUI.findOrcreateSession());
        }

        public MockUI(VaadinSession session) {
            this.getInternals().setSession(session);
            MockUI.setCurrent((UI)this);
        }

        protected void init(VaadinRequest request) {
        }

        private static VaadinSession findOrcreateSession() {
            VaadinSession session = VaadinSession.getCurrent();
            if (session == null) {
                final RouteRegistry routeRegistry = (RouteRegistry)Mockito.mock(RouteRegistry.class);
                VaadinServletService service = new VaadinServletService(){

                    protected RouteRegistry getRouteRegistry() {
                        return routeRegistry;
                    }
                };
                session = new AlwaysLockedVaadinSession((VaadinService)service);
                VaadinSession.setCurrent((VaadinSession)session);
            }
            return session;
        }
    }

    public static class MockVaadinSession
    extends VaadinSession {
        private static final ThreadLocal<MockVaadinSession> referenceKeeper = new ThreadLocal();
        private int closeCount;
        private ReentrantLock lock = new ReentrantLock();

        public MockVaadinSession(VaadinService service) {
            super(service);
        }

        public void close() {
            super.close();
            ++this.closeCount;
        }

        public int getCloseCount() {
            return this.closeCount;
        }

        public Lock getLockInstance() {
            return this.lock;
        }

        public void lock() {
            super.lock();
            referenceKeeper.set(this);
        }

        public void unlock() {
            super.unlock();
            referenceKeeper.remove();
        }
    }

    public static class AlwaysLockedVaadinSession
    extends MockVaadinSession {
        public AlwaysLockedVaadinSession(VaadinService service) {
            super(service);
            this.lock();
        }
    }

    private static class Item {
        private final int id;
        private String value;

        public Item(int id) {
            this(id, "Item " + id);
        }

        public Item(int id, String value) {
            this.id = id;
            this.value = value;
        }

        public String toString() {
            return this.id + ": " + this.value;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Item) {
                Item that = (Item)obj;
                return that.id == this.id;
            }
            return false;
        }

        public int hashCode() {
            return this.id;
        }
    }
}

