/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider.hierarchy;

import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.FilterUtils;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalConfigurableFilterDataProvider;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalFilterUtils;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalQuery;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.function.SerializableFunction;
import java.util.stream.Stream;

public interface HierarchicalDataProvider<T, F>
extends DataProvider<T, F> {
    default public HierarchyFormat getHierarchyFormat() {
        return HierarchyFormat.NESTED;
    }

    @Override
    default public int size(Query<T, F> query) {
        if (query instanceof HierarchicalQuery) {
            return this.getChildCount((HierarchicalQuery)query);
        }
        throw new IllegalArgumentException("Hierarchical data provider doesn't support non-hierarchical queries");
    }

    @Override
    default public Stream<T> fetch(Query<T, F> query) {
        if (query instanceof HierarchicalQuery) {
            return this.fetchChildren((HierarchicalQuery)query);
        }
        throw new IllegalArgumentException("Hierarchical data provider doesn't support non-hierarchical queries");
    }

    public int getChildCount(HierarchicalQuery<T, F> var1);

    public Stream<T> fetchChildren(HierarchicalQuery<T, F> var1);

    public boolean hasChildren(T var1);

    default public int getDepth(T item) {
        if (HierarchyFormat.FLATTENED.equals((Object)this.getHierarchyFormat())) {
            throw new UnsupportedOperationException("The getDepth method must be implemented when getHierarchyFormat() is configured as HierarchyFormat#FLATTENED\n");
        }
        throw new UnsupportedOperationException("The getDepth method is not implemented for this data provider");
    }

    @Override
    default public <Q, C> HierarchicalConfigurableFilterDataProvider<T, Q, C> withConfigurableFilter(final SerializableBiFunction<Q, C, F> filterCombiner) {
        return new HierarchicalFilterUtils.HierarchialConfigurableFilterDataProviderWrapper<T, Q, C, F>(this){

            @Override
            protected F combineFilters(Q queryFilter, C configuredFilter) {
                return FilterUtils.combineFilters(filterCombiner, queryFilter, configuredFilter);
            }
        };
    }

    @Override
    default public <C> HierarchicalDataProvider<T, C> withConvertedFilter(final SerializableFunction<C, F> filterConverter) {
        return new HierarchicalFilterUtils.HierarchicalFilterDataProviderWrapper<T, C, F>(this){

            @Override
            protected F getFilter(Query<T, C> query) {
                return FilterUtils.convertFilter(filterConverter, query);
            }
        };
    }

    @Override
    default public HierarchicalConfigurableFilterDataProvider<T, Void, F> withConfigurableFilter() {
        return (HierarchicalConfigurableFilterDataProvider)DataProvider.super.withConfigurableFilter();
    }

    public static enum HierarchyFormat {
        NESTED,
        FLATTENED;

    }
}

