/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider.hierarchy;

import com.vaadin.flow.data.provider.CompositeDataGenerator;
import com.vaadin.flow.data.provider.DataKeyMapper;
import com.vaadin.flow.data.provider.hierarchy.AbstractHierarchicalDataCommunicatorTest;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalDataCommunicator;
import com.vaadin.flow.data.provider.hierarchy.TreeData;
import com.vaadin.flow.data.provider.hierarchy.TreeDataProvider;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class HierarchicalDataCommunicatorKeyGenerationTest
extends AbstractHierarchicalDataCommunicatorTest {
    private TreeData<AbstractHierarchicalDataCommunicatorTest.Item> treeData = new TreeData();
    private TreeDataProvider<AbstractHierarchicalDataCommunicatorTest.Item> treeDataProvider = new TreeDataProvider(this.treeData);
    private ValueProvider<AbstractHierarchicalDataCommunicatorTest.Item, String> uniqueKeyProvider = null;
    private CompositeDataGenerator<AbstractHierarchicalDataCommunicatorTest.Item> dataGenerator = new CompositeDataGenerator();
    private HierarchicalDataCommunicator<AbstractHierarchicalDataCommunicatorTest.Item> dataCommunicator;
    private DataKeyMapper<AbstractHierarchicalDataCommunicatorTest.Item> keyMapper;

    @Override
    @Before
    public void init() {
        super.init();
        this.dataCommunicator = new HierarchicalDataCommunicator(this.dataGenerator, this.arrayUpdater, this.ui.getElement().getNode(), (SerializableSupplier & Serializable)() -> this.uniqueKeyProvider);
        this.dataCommunicator.setDataProvider(this.treeDataProvider, null);
        this.keyMapper = this.dataCommunicator.getKeyMapper();
    }

    @Test
    public void changeViewportRangeBackAndForth_generatedKeysMatchItems() {
        this.populateTreeData(this.treeData, 100, 2, 2);
        this.dataCommunicator.expand((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"));
        this.dataCommunicator.setViewportRange(0, 4);
        this.fakeClientCommunication();
        this.assertArrayUpdateItems("key", this.keyMapper.key((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0")), this.keyMapper.key((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0")), this.keyMapper.key((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-1")), this.keyMapper.key((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 1")));
        Mockito.clearInvocations((Object[])new Serializable[]{this.arrayUpdater, this.arrayUpdate});
        this.dataCommunicator.setViewportRange(98, 4);
        this.fakeClientCommunication();
        this.assertArrayUpdateItems("key", this.keyMapper.key((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 96")), this.keyMapper.key((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 97")), this.keyMapper.key((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 98")), this.keyMapper.key((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 99")));
        Mockito.clearInvocations((Object[])new Serializable[]{this.arrayUpdater, this.arrayUpdate});
        this.dataCommunicator.setViewportRange(0, 6);
        this.fakeClientCommunication();
        this.assertArrayUpdateItems("key", this.keyMapper.key((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0")), this.keyMapper.key((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0")), this.keyMapper.key((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-1")), this.keyMapper.key((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 1")), this.keyMapper.key((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 2")), this.keyMapper.key((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 3")));
    }

    @Test
    public void changeViewportRangeBackAndForth_reset_generatedKeysMatchItems() {
        this.populateTreeData(this.treeData, 100, 2, 2);
        this.dataCommunicator.expand((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"));
        this.dataCommunicator.setViewportRange(0, 4);
        this.fakeClientCommunication();
        this.dataCommunicator.setViewportRange(98, 4);
        this.fakeClientCommunication();
        this.dataCommunicator.setViewportRange(0, 6);
        this.fakeClientCommunication();
        Mockito.clearInvocations((Object[])new Serializable[]{this.arrayUpdater, this.arrayUpdate});
        this.dataCommunicator.reset();
        this.fakeClientCommunication();
        this.assertArrayUpdateItems("key", this.keyMapper.key((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0")), this.keyMapper.key((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0")), this.keyMapper.key((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-1")), this.keyMapper.key((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 1")), this.keyMapper.key((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 2")), this.keyMapper.key((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 3")));
    }

    @Test
    public void setUniqueKeyProvider_keysGeneratedByProvider() {
        this.populateTreeData(this.treeData, 100, 2, 2);
        this.dataCommunicator.expand((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0"));
        this.dataCommunicator.setViewportRange(0, 4);
        this.uniqueKeyProvider = (ValueProvider & Serializable)item -> "key-" + item.getName().toLowerCase().replace("item ", "");
        this.fakeClientCommunication();
        this.assertArrayUpdateItems("key", "key-0", "key-0-0", "key-0-1", "key-1");
        this.assertArrayUpdateItems("key", this.keyMapper.key((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0")), this.keyMapper.key((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-0")), this.keyMapper.key((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 0-1")), this.keyMapper.key((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 1")));
    }

    @Test
    public void generateKeyManually_resetBeforeInitFlush_keyPreserved() {
        this.populateTreeData(this.treeData, 100, 2, 2);
        String key = this.keyMapper.key((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 4"));
        this.dataCommunicator.reset();
        Assert.assertEquals((Object)new AbstractHierarchicalDataCommunicatorTest.Item("Item 4"), (Object)this.keyMapper.get(key));
    }
}

