/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.converter;

import com.vaadin.flow.data.binder.ErrorMessageProvider;
import com.vaadin.flow.data.binder.Result;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.data.converter.AbstractStringToNumberConverter;
import com.vaadin.flow.function.SerializableFunction;
import java.io.Serializable;

public class StringToFloatConverter
extends AbstractStringToNumberConverter<Float> {
    public StringToFloatConverter(String errorMessage) {
        this(null, errorMessage);
    }

    public StringToFloatConverter(Float emptyValue, String errorMessage) {
        super(emptyValue, errorMessage);
    }

    public StringToFloatConverter(ErrorMessageProvider errorMessageProvider) {
        this(null, errorMessageProvider);
    }

    public StringToFloatConverter(Float emptyValue, ErrorMessageProvider errorMessageProvider) {
        super(emptyValue, errorMessageProvider);
    }

    @Override
    public Result<Float> convertToModel(String value, ValueContext context) {
        Result<Number> n = this.convertToNumber(value, context);
        return n.map((SerializableFunction & Serializable)number -> {
            if (number == null) {
                return null;
            }
            return Float.valueOf(number.floatValue());
        });
    }
}

