/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider.hierarchy;

import com.vaadin.flow.data.provider.InMemoryDataProvider;
import com.vaadin.flow.data.provider.hierarchy.AbstractHierarchicalDataProvider;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalDataProvider;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalQuery;
import com.vaadin.flow.data.provider.hierarchy.TreeData;
import com.vaadin.flow.function.SerializableComparator;
import com.vaadin.flow.function.SerializablePredicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class TreeDataProvider<T>
extends AbstractHierarchicalDataProvider<T, SerializablePredicate<T>>
implements InMemoryDataProvider<T> {
    private final TreeData<T> treeData;
    private SerializablePredicate<T> filter = null;
    private SerializableComparator<T> sortOrder = null;
    private HierarchicalDataProvider.HierarchyFormat hierarchyFormat = HierarchicalDataProvider.HierarchyFormat.NESTED;

    public TreeDataProvider(TreeData<T> treeData) {
        this.treeData = Objects.requireNonNull(treeData, "treeData cannot be null");
    }

    public TreeDataProvider(TreeData<T> treeData, HierarchicalDataProvider.HierarchyFormat hierarchyFormat) {
        this(treeData);
        this.hierarchyFormat = Objects.requireNonNull(hierarchyFormat, "hierarchyFormat cannot be null");
    }

    @Override
    public HierarchicalDataProvider.HierarchyFormat getHierarchyFormat() {
        return this.hierarchyFormat;
    }

    public TreeData<T> getTreeData() {
        return this.treeData;
    }

    @Override
    public boolean hasChildren(T item) {
        if (!this.treeData.contains(item)) {
            return false;
        }
        return !this.treeData.getChildren(item).isEmpty();
    }

    @Override
    public T getParent(T item) {
        Objects.requireNonNull(item, "Item cannot be null.");
        try {
            return this.getTreeData().getParent(item);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public int getDepth(T item) {
        int depth = 0;
        while ((item = this.treeData.getParent(item)) != null) {
            ++depth;
        }
        return depth;
    }

    @Override
    public int getChildCount(HierarchicalQuery<T, SerializablePredicate<T>> query) {
        Optional<SerializablePredicate<T>> combinedFilter = this.getCombinedFilter(query.getFilter());
        return (int)this.flatten(query.getParent(), query.getExpandedItemIds(), combinedFilter, Optional.empty()).stream().skip(query.getOffset()).limit(query.getLimit()).count();
    }

    @Override
    public Stream<T> fetchChildren(HierarchicalQuery<T, SerializablePredicate<T>> query) {
        if (!this.treeData.contains(query.getParent())) {
            throw new IllegalArgumentException("The queried item " + String.valueOf(query.getParent()) + " could not be found in the backing TreeData. Did you forget to refresh this data provider after item removal?");
        }
        Optional<SerializablePredicate<T>> combinedFilter = this.getCombinedFilter(query.getFilter());
        Optional<Comparator<T>> comparator = Stream.of(query.getInMemorySorting(), this.sortOrder).filter(Objects::nonNull).reduce((c1, c2) -> c1.thenComparing(c2));
        return this.flatten(query.getParent(), query.getExpandedItemIds(), combinedFilter, comparator).stream().skip(query.getOffset()).limit(query.getLimit());
    }

    @Override
    public SerializablePredicate<T> getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(SerializablePredicate<T> filter) {
        this.filter = filter;
        this.refreshAll();
    }

    @Override
    public SerializableComparator<T> getSortComparator() {
        return this.sortOrder;
    }

    @Override
    public void setSortComparator(SerializableComparator<T> comparator) {
        this.sortOrder = comparator;
        this.refreshAll();
    }

    private Optional<SerializablePredicate<T>> getCombinedFilter(Optional<SerializablePredicate<T>> queryFilter) {
        return this.filter != null ? Optional.of(queryFilter.map(arg_0 -> this.filter.and(arg_0)).orElse(this.filter)) : queryFilter;
    }

    private List<T> flatten(T parent, Set<Object> expandedItemIds, Optional<SerializablePredicate<T>> combinedFilter, Optional<Comparator<T>> comparator) {
        ArrayList result = new ArrayList();
        List<Object> children = this.getTreeData().getChildren(parent);
        if (comparator.isPresent()) {
            children = children.stream().sorted(comparator.get()).toList();
        }
        for (Object child : children) {
            boolean matchesFilter;
            boolean isExpanded = expandedItemIds.contains(this.getId(child));
            List descendants = Collections.emptyList();
            if (this.getHierarchyFormat().equals((Object)HierarchicalDataProvider.HierarchyFormat.NESTED) || isExpanded || combinedFilter.isPresent()) {
                descendants = this.flatten(child, expandedItemIds, combinedFilter, comparator);
            }
            boolean bl = matchesFilter = combinedFilter.map(f -> f.test(child)).orElse(true) != false || !descendants.isEmpty();
            if (matchesFilter) {
                result.add(child);
            }
            if (!matchesFilter || !this.getHierarchyFormat().equals((Object)HierarchicalDataProvider.HierarchyFormat.FLATTENED) || !isExpanded) continue;
            result.addAll(descendants);
        }
        return result;
    }
}

