/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider.hierarchy;

import com.vaadin.flow.data.provider.DataProviderListener;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalDataProvider;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalQuery;
import com.vaadin.flow.shared.Registration;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;

public class HierarchicalDataProviderTest {
    @Test
    public void getParent_throwsUnsupportedOperationException() {
        TestDataProvider dataProvider = new TestDataProvider();
        TestBean rootItem = new TestBean(null, 0, 3);
        Assert.assertThrows(UnsupportedOperationException.class, () -> dataProvider.getParent(rootItem));
    }

    @Test
    public void inMemoryDataProvider_getNullItemIndex_throwsNullPointerException() {
        TestDataProvider dataProvider = new TestDataProvider();
        dataProvider.setInMemory(true);
        HierarchicalQuery query = new HierarchicalQuery(null, null);
        Assert.assertThrows(NullPointerException.class, () -> dataProvider.getItemIndex(null, query));
    }

    @Test
    public void inMemoryDataProvider_getItemIndexWithNullQuery_throwsNullPointerException() {
        TestDataProvider dataProvider = new TestDataProvider();
        dataProvider.setInMemory(true);
        TestBean rootItem = new TestBean(null, 0, 3);
        Assert.assertThrows(NullPointerException.class, () -> dataProvider.getItemIndex(rootItem, null));
    }

    @Test
    public void defaultDataProvider_getItemIndex_throwsUnsupportedOperationException() {
        TestDataProvider dataProvider = new TestDataProvider();
        TestBean rootItem = new TestBean(null, 0, 3);
        Assert.assertThrows(UnsupportedOperationException.class, () -> dataProvider.getItemIndex(rootItem, null));
    }

    @Test
    public void inMemoryDataProvider_getItemIndex_returnsCorrectIndex() {
        TestDataProvider dataProvider = new TestDataProvider();
        dataProvider.setInMemory(true);
        TestBean rootItem = new TestBean(null, 0, 3);
        HierarchicalQuery query = new HierarchicalQuery(null, null);
        int itemIndex = dataProvider.getItemIndex(rootItem, query);
        Assert.assertEquals((long)3L, (long)itemIndex);
    }

    @Test
    public void inMemoryDataProvider_getChildItemIndex_returnsCorrectIndex() {
        TestDataProvider dataProvider = new TestDataProvider();
        dataProvider.setInMemory(true);
        TestBean rootItem = new TestBean(null, 0, 3);
        TestBean childItem = new TestBean(rootItem.getId(), 1, 3);
        HierarchicalQuery query = new HierarchicalQuery(null, (Object)rootItem);
        int itemIndex = dataProvider.getItemIndex(childItem, query);
        Assert.assertEquals((long)3L, (long)itemIndex);
    }

    @Test
    public void inMemoryDataProvider_getItemIndexInIncorrectParent_returnsMinusOne() {
        TestDataProvider dataProvider = new TestDataProvider();
        dataProvider.setInMemory(true);
        TestBean rootItem = new TestBean(null, 0, 3);
        TestBean anotherRootItem = new TestBean(null, 0, 4);
        HierarchicalQuery query = new HierarchicalQuery(null, (Object)anotherRootItem);
        int itemIndex = dataProvider.getItemIndex(rootItem, query);
        Assert.assertEquals((long)-1L, (long)itemIndex);
    }

    @Test
    public void inMemoryDataProvider_getItemIndexForAnIncorrectItem_returnsMinusOne() {
        TestDataProvider dataProvider = new TestDataProvider();
        dataProvider.setInMemory(true);
        TestBean notPresentItem = new TestBean(null, 0, 20000);
        HierarchicalQuery query = new HierarchicalQuery(null, null);
        int itemIndex = dataProvider.getItemIndex(notPresentItem, query);
        Assert.assertEquals((long)-1L, (long)itemIndex);
    }

    private static class TestDataProvider
    implements HierarchicalDataProvider<TestBean, Object> {
        private static final int DEPTH = 3;
        private static final int ROOT_ITEM_COUNT = 50;
        private static final int CHILD_PER_LEVEL = 10;
        private boolean inMemory;

        private TestDataProvider() {
        }

        public int getChildCount(HierarchicalQuery<TestBean, Object> query) {
            return this.hasChildren((TestBean)query.getParent()) ? 50 : 0;
        }

        public Stream<TestBean> fetchChildren(HierarchicalQuery<TestBean, Object> query) {
            if (query.getParent() == null) {
                return IntStream.range(0, 50).mapToObj(i -> new TestBean(null, 0, i));
            }
            return IntStream.range(0, 10).mapToObj(i -> new TestBean(((TestBean)query.getParent()).getId(), ((TestBean)query.getParent()).getDepth() + 1, i));
        }

        public boolean hasChildren(TestBean o) {
            if (o == null) {
                return true;
            }
            return o.getDepth() < 2;
        }

        public void setInMemory(boolean inMemory) {
            this.inMemory = inMemory;
        }

        public boolean isInMemory() {
            return this.inMemory;
        }

        public void refreshItem(TestBean o) {
        }

        public void refreshAll() {
        }

        public Registration addDataProviderListener(DataProviderListener<TestBean> listener) {
            return null;
        }
    }

    private static class TestBean {
        private final String id;
        private final int depth;
        private final int index;

        public TestBean(String parentId, int depth, int index) {
            this.id = (parentId == null ? "" : parentId) + "/" + depth + "/" + index;
            this.depth = depth;
            this.index = index;
        }

        public int getDepth() {
            return this.depth;
        }

        public int getIndex() {
            return this.index;
        }

        public String getId() {
            return this.id;
        }

        public String toString() {
            return this.depth + " | " + this.index;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof TestBean) {
                TestBean other = (TestBean)obj;
                return this.id.equals(other.id);
            }
            return false;
        }
    }
}

