/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.converter;

import com.vaadin.flow.data.binder.Result;
import com.vaadin.flow.data.converter.DoubleToBigDecimalConverter;
import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Test;

public class DoubleToBigDecimalConverterTest {
    DoubleToBigDecimalConverter converter = new DoubleToBigDecimalConverter();

    @Test
    public void testNullConversionToModel() {
        Assert.assertEquals((Object)Result.ok(null), (Object)this.converter.convertToModel(null, null));
    }

    @Test
    public void testNullConversionToPresentation() {
        Assert.assertNull((Object)this.converter.convertToPresentation(null, null));
    }

    @Test
    public void testConvertToModel() {
        Result result = this.converter.convertToModel(Double.valueOf(42.42), null);
        Assert.assertEquals((Object)Result.ok((Object)BigDecimal.valueOf(42.42)), (Object)result);
    }

    @Test
    public void testConvertToPresentation() {
        Double value = this.converter.convertToPresentation(new BigDecimal("42.42"), null);
        Assert.assertEquals((Object)42.42, (Object)value);
    }

    @Test
    public void testConvertToModelWithDifferentScales() {
        Result result = this.converter.convertToModel(Double.valueOf(42.42), null);
        Assert.assertEquals((Object)Result.ok((Object)new BigDecimal("42.42")), (Object)result);
    }

    @Test
    public void testConvertToPresentationWithDifferentScales() {
        Double value = this.converter.convertToPresentation(new BigDecimal("42.420"), null);
        Assert.assertEquals((Object)42.42, (Object)value);
    }
}

