/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.binder;

import com.vaadin.flow.data.binder.ErrorLevel;
import com.vaadin.flow.data.binder.ValidationResult;
import org.junit.Assert;
import org.junit.Test;

public class ValidationResultTest {
    @Test
    public void toStringValidation() {
        String toString = ValidationResult.ok().toString();
        Assert.assertEquals((Object)"ValidationResult{ok}", (Object)toString);
        toString = ValidationResult.error((String)"My Error Message").toString();
        Assert.assertEquals((Object)"ValidationResult{error='My Error Message', errorLevel=ERROR}", (Object)toString);
        toString = ValidationResult.create((String)"My Critical Message", (ErrorLevel)ErrorLevel.CRITICAL).toString();
        Assert.assertEquals((Object)"ValidationResult{error='My Critical Message', errorLevel=CRITICAL}", (Object)toString);
        toString = ValidationResult.create((String)"My Info Message", (ErrorLevel)ErrorLevel.INFO).toString();
        Assert.assertEquals((Object)"ValidationResult{error='My Info Message', errorLevel=INFO}", (Object)toString);
    }

    @Test
    public void equalsAndHashCode() {
        ValidationResult ok1 = ValidationResult.ok();
        ValidationResult ok2 = ValidationResult.ok();
        ValidationResult error1 = ValidationResult.error((String)"Msg1");
        ValidationResult error2 = ValidationResult.error((String)"Msg2");
        ValidationResult info1 = ValidationResult.create((String)"Info", (ErrorLevel)ErrorLevel.INFO);
        ValidationResult info2 = ValidationResult.create((String)"Info", (ErrorLevel)ErrorLevel.ERROR);
        ValidationResult info3 = ValidationResult.create((String)"Info", (ErrorLevel)ErrorLevel.INFO);
        Assert.assertEquals((Object)ok1, (Object)ok2);
        Assert.assertNotEquals((Object)ok1, (Object)error1);
        Assert.assertNotEquals((Object)error1, (Object)error2);
        Assert.assertNotEquals((Object)error1, (Object)info1);
        Assert.assertNotEquals((Object)info1, (Object)info2);
        Assert.assertEquals((Object)info1, (Object)info3);
        Assert.assertEquals((long)ok1.hashCode(), (long)ok2.hashCode());
        Assert.assertEquals((long)info1.hashCode(), (long)info3.hashCode());
    }
}

