/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.vaadin.flow.data.provider.AbstractBackEndDataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.util.Objects;
import java.util.stream.Stream;

public class CallbackDataProvider<T, F>
extends AbstractBackEndDataProvider<T, F> {
    private final FetchCallback<T, F> fetchCallback;
    private final CountCallback<T, F> countCallback;
    private final ValueProvider<T, Object> idGetter;

    public CallbackDataProvider(FetchCallback<T, F> fetchCallback, CountCallback<T, F> countCallback) {
        this(fetchCallback, countCallback, (ValueProvider & Serializable)t -> t);
    }

    public CallbackDataProvider(FetchCallback<T, F> fetchCallBack, CountCallback<T, F> countCallback, ValueProvider<T, Object> identifierGetter) {
        Objects.requireNonNull(fetchCallBack, "Request function can't be null");
        Objects.requireNonNull(countCallback, "Count callback can't be null");
        Objects.requireNonNull(identifierGetter, "Identifier getter function can't be null");
        this.fetchCallback = fetchCallBack;
        this.countCallback = countCallback;
        this.idGetter = identifierGetter;
    }

    @Override
    public Stream<T> fetchFromBackEnd(Query<T, F> query) {
        return this.fetchCallback.fetch(query);
    }

    @Override
    protected int sizeInBackEnd(Query<T, F> query) {
        return this.countCallback.count(query);
    }

    @Override
    public Object getId(T item) {
        Object itemId = this.idGetter.apply(item);
        assert (itemId != null) : "CallbackDataProvider got null as an id for item: " + String.valueOf(item);
        return itemId;
    }

    public String toString() {
        return "CallbackDataProvider(fetchCallback=" + String.valueOf(this.fetchCallback) + ", countCallback=" + String.valueOf(this.countCallback) + ", idGetter=" + String.valueOf(this.idGetter) + ")";
    }

    @FunctionalInterface
    public static interface FetchCallback<T, F>
    extends Serializable {
        public Stream<T> fetch(Query<T, F> var1);
    }

    @FunctionalInterface
    public static interface CountCallback<T, F>
    extends Serializable {
        public int count(Query<T, F> var1);
    }
}

