/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider.hierarchy;

import com.vaadin.flow.data.provider.ArrayUpdater;
import com.vaadin.flow.data.provider.CompositeDataGenerator;
import com.vaadin.flow.data.provider.DataChangeEvent;
import com.vaadin.flow.data.provider.DataCommunicator;
import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.KeyMapper;
import com.vaadin.flow.data.provider.hierarchy.Cache;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalDataProvider;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalQuery;
import com.vaadin.flow.data.provider.hierarchy.RootCache;
import com.vaadin.flow.data.provider.hierarchy.TreeData;
import com.vaadin.flow.data.provider.hierarchy.TreeDataProvider;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.internal.ExecutionContext;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.Range;
import com.vaadin.flow.internal.StateNode;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

public class HierarchicalDataCommunicator<T>
extends DataCommunicator<T> {
    private final Set<Object> expandedItemIds = new HashSet<Object>();
    private final StateNode stateNode;
    private final ArrayUpdater arrayUpdater;
    private final DataGenerator<T> dataGenerator;
    private final SerializableSupplier<ValueProvider<T, String>> uniqueKeyProviderSupplier;
    private FlushRequest<T> flushRequest = null;
    private Range viewportRange = Range.withLength((int)0, (int)0);
    private int lastUpdateId = -1;
    RootCache<T> rootCache;

    public HierarchicalDataCommunicator(CompositeDataGenerator<T> dataGenerator, ArrayUpdater arrayUpdater, StateNode stateNode, SerializableSupplier<ValueProvider<T, String>> uniqueKeyProviderSupplier) {
        super(dataGenerator, arrayUpdater, null, stateNode, false);
        this.stateNode = stateNode;
        this.arrayUpdater = arrayUpdater;
        this.dataGenerator = dataGenerator;
        this.uniqueKeyProviderSupplier = uniqueKeyProviderSupplier;
        KeyMapperWrapper keyMapperWrapper = new KeyMapperWrapper();
        this.setKeyMapper(keyMapperWrapper);
        this.setDataProvider(new TreeDataProvider(new TreeData()), (Object)null);
        stateNode.addAttachListener(this::requestFlush);
    }

    private FlushRequest<T> requestFlush() {
        if (this.flushRequest != null) {
            return this.flushRequest;
        }
        this.flushRequest = new FlushRequest();
        this.stateNode.runWhenAttached((SerializableConsumer & Serializable)ui -> ui.getInternals().getStateTree().beforeClientResponse(this.stateNode, (SerializableConsumer & Serializable)context -> {
            this.flush((ExecutionContext)context);
            this.flushRequest = null;
        }));
        return this.flushRequest;
    }

    @Override
    public void reset() {
        if (this.rootCache != null) {
            this.rootCache = null;
            this.getKeyMapper().removeAll();
            this.dataGenerator.destroyAllData();
        }
        this.requestFlush().invalidateViewport();
    }

    @Override
    protected void handleDataRefreshEvent(DataChangeEvent.DataRefreshEvent<T> event) {
        this.refresh(event.getItem(), event.isRefreshChildren());
    }

    @Override
    public void refresh(T item) {
        this.refresh(item, false);
    }

    public void refresh(T item, boolean refreshChildren) {
        Objects.requireNonNull(item, "Item cannot be null");
        if (!this.getHierarchyFormat().equals((Object)HierarchicalDataProvider.HierarchyFormat.NESTED) && refreshChildren) {
            throw new UnsupportedOperationException("Refreshing children of an item is only supported when the data provider uses HierarchyFormat#NESTED. For other formats, use reset() instead.\n");
        }
        this.getKeyMapper().refresh(item);
        this.dataGenerator.refreshData(item);
        if (this.rootCache == null) {
            return;
        }
        RootCache.ItemContext<T> itemContext = this.rootCache.getContextByItem(item);
        if (itemContext == null) {
            return;
        }
        Cache<T> cache = itemContext.cache();
        int index = itemContext.index();
        cache.refreshItem(item);
        Cache<T> subCache = cache.getSubCache(index);
        if (refreshChildren && subCache != null) {
            subCache.clear();
            subCache.setSize(this.getDataProviderChildCount(item));
            this.requestFlush().invalidateViewport();
        }
        this.requestFlush().invalidateItem(item);
    }

    @Override
    public Stream<T> fetchFromProvider(int offset, int limit) {
        return this.fetchDataProviderChildren(null, Range.withLength((int)offset, (int)limit));
    }

    @Override
    public HierarchicalDataProvider<T, ?> getDataProvider() {
        return (HierarchicalDataProvider)super.getDataProvider();
    }

    @Override
    public <F> SerializableConsumer<F> setDataProvider(HierarchicalDataProvider<T, F> dataProvider, F initialFilter) {
        this.expandedItemIds.clear();
        return super.setDataProvider(dataProvider, initialFilter);
    }

    @Override
    public <F> SerializableConsumer<F> setDataProvider(DataProvider<T, F> dataProvider, F initialFilter) {
        if (dataProvider instanceof HierarchicalDataProvider) {
            HierarchicalDataProvider hierarchicalDataProvider = (HierarchicalDataProvider)dataProvider;
            return this.setDataProvider(hierarchicalDataProvider, initialFilter);
        }
        throw new IllegalArgumentException("Only HierarchicalDataProvider and its subtypes are supported");
    }

    public void collapse(T item) {
        this.collapse((Collection<T>)Arrays.asList(item));
    }

    public Collection<T> collapse(Collection<T> items) {
        List<Object> collapsedItems = items.stream().filter(item -> this.expandedItemIds.remove(this.getDataProvider().getId(item))).toList();
        if (this.rootCache != null) {
            for (Object item2 : collapsedItems) {
                RootCache.ItemContext<Object> itemContext = this.rootCache.getContextByItem(item2);
                if (itemContext == null) continue;
                Cache<Object> cache = itemContext.cache();
                int index = itemContext.index();
                cache.removeSubCache(index);
            }
        }
        if (this.getHierarchyFormat().equals((Object)HierarchicalDataProvider.HierarchyFormat.FLATTENED)) {
            this.reset();
        } else {
            this.requestFlush().invalidateViewport();
        }
        return collapsedItems;
    }

    public void expand(T item) {
        this.expand((Collection<T>)Arrays.asList(item));
    }

    public Collection<T> expand(Collection<T> items) {
        List<Object> expandedItems = items.stream().filter(item -> this.hasChildren(item)).filter(item -> this.expandedItemIds.add(this.getDataProvider().getId(item))).toList();
        if (this.getHierarchyFormat().equals((Object)HierarchicalDataProvider.HierarchyFormat.FLATTENED)) {
            this.reset();
        } else {
            this.requestFlush().invalidateViewport();
        }
        return expandedItems;
    }

    public boolean hasChildren(T item) {
        return this.getDataProvider().hasChildren(item);
    }

    public boolean isExpanded(T item) {
        Objects.requireNonNull(item, "Item cannot be null");
        return this.expandedItemIds.contains(this.getDataProvider().getId(item));
    }

    public int getDepth(T item) {
        Objects.requireNonNull(item, "Item cannot be null");
        if (this.getHierarchyFormat().equals((Object)HierarchicalDataProvider.HierarchyFormat.FLATTENED)) {
            return this.getDataProvider().getDepth(item);
        }
        if (this.rootCache == null) {
            return -1;
        }
        RootCache.ItemContext<T> itemContext = this.rootCache.getContextByItem(item);
        if (itemContext == null) {
            return -1;
        }
        return itemContext.cache().getDepth();
    }

    @Override
    public int getDataProviderSize() {
        return this.getDataProviderChildCount(null);
    }

    public boolean hasExpandedItems() {
        return !this.expandedItemIds.isEmpty();
    }

    private JsonNode generateItemJson(T item) {
        ObjectNode json = JacksonUtils.createObjectNode();
        json.put("key", this.getKeyMapper().key(item));
        this.dataGenerator.generateData(item, json);
        return json;
    }

    protected int resolveIndexPath(int ... path) {
        this.ensureRootCache();
        this.resolveIndexPath(this.rootCache, path);
        return this.rootCache.getFlatIndexByPath(path);
    }

    private void resolveIndexPath(Cache<T> cache, int ... path) {
        int[] restPath = Arrays.copyOfRange(path, 1, path.length);
        int index = Math.min(path[0], cache.getSize() - 1);
        if (index < 0) {
            index = Math.max(cache.getSize() + index, 0);
        }
        if (!cache.hasItem(index)) {
            this.preloadRange(cache, index, 1);
        }
        if (restPath.length == 0) {
            return;
        }
        T item = cache.getItem(index);
        if (this.getHierarchyFormat().equals((Object)HierarchicalDataProvider.HierarchyFormat.NESTED) && this.isExpanded(item)) {
            Cache<T> subCache = cache.ensureSubCache(index, item, (SerializableSupplier<Integer>)(SerializableSupplier & Serializable)() -> {
                this.requestFlush().invalidateViewport();
                return this.getDataProviderChildCount(item);
            });
            this.resolveIndexPath(subCache, restPath);
        }
    }

    private void preloadRange(Cache<T> cache, int start, int length) {
        Range range = Range.withLength((int)start, (int)length).restrictTo(Range.withLength((int)0, (int)cache.getSize()));
        List<T> items = this.fetchDataProviderChildren(cache.getParentItem(), range).toList();
        cache.setItems(range.getStart(), items);
    }

    protected List<T> preloadFlatRangeBackward(int start, int length) {
        RootCache.ItemContext<T> context;
        this.ensureRootCache();
        LinkedList<T> result = new LinkedList<T>();
        while (result.size() < length && (context = this.rootCache.getContextByFlatIndex(start)) != null) {
            int index;
            Cache<T> cache = context.cache();
            if (!cache.hasItem(index = context.index())) {
                int remainingLength = length - result.size();
                this.preloadRange(cache, index - (remainingLength - 1), remainingLength);
            }
            T item = cache.getItem(index);
            if (this.getHierarchyFormat().equals((Object)HierarchicalDataProvider.HierarchyFormat.NESTED) && this.isExpanded(item) && !cache.hasSubCache(index) && result.size() > 0) {
                Cache<T> subCache = cache.ensureSubCache(index, item, (SerializableSupplier<Integer>)(SerializableSupplier & Serializable)() -> {
                    this.requestFlush().invalidateViewport();
                    return this.getDataProviderChildCount(item);
                });
                start += subCache.getSize();
                continue;
            }
            --start;
            result.addFirst(item);
        }
        return result;
    }

    protected List<T> preloadFlatRangeForward(int start, int length) {
        RootCache.ItemContext<T> context;
        this.ensureRootCache();
        LinkedList<T> result = new LinkedList<T>();
        while (result.size() < length && (context = this.rootCache.getContextByFlatIndex(start)) != null) {
            int index;
            Cache<T> cache = context.cache();
            if (!cache.hasItem(index = context.index())) {
                this.preloadRange(cache, index, length - result.size());
            }
            T item = cache.getItem(index);
            if (this.getHierarchyFormat().equals((Object)HierarchicalDataProvider.HierarchyFormat.NESTED) && this.isExpanded(item)) {
                cache.ensureSubCache(index, item, (SerializableSupplier<Integer>)(SerializableSupplier & Serializable)() -> {
                    this.requestFlush().invalidateViewport();
                    return this.getDataProviderChildCount(item);
                });
            }
            ++start;
            result.addLast(item);
        }
        return result;
    }

    @Override
    public void setViewportRange(int start, int length) {
        Range previousViewportRange = this.viewportRange;
        this.viewportRange = this.computeViewportRange(start, length);
        Range[] partition = this.viewportRange.partitionWith(previousViewportRange);
        if (!partition[0].isEmpty()) {
            this.requestFlush().invalidateRange(partition[0]);
        }
        if (partition[1].isEmpty()) {
            this.requestFlush().invalidateViewport();
        }
        if (!partition[2].isEmpty()) {
            this.requestFlush().invalidateRange(partition[2]);
        }
    }

    private void flush(ExecutionContext context) {
        if (!context.isClientSideInitialized()) {
            this.reset();
            this.arrayUpdater.initialize();
        }
        this.ensureRootCache();
        if (this.viewportRange.getStart() >= this.rootCache.getFlatSize()) {
            this.setViewportRange(0, this.viewportRange.length());
        }
        int length = this.viewportRange.length();
        int start = this.viewportRange.getStart();
        int end = this.viewportRange.getEnd();
        List<T> viewportItems = this.preloadFlatRangeForward(start, length);
        int flatSize = this.rootCache.getFlatSize();
        ArrayUpdater.Update update = this.arrayUpdater.startUpdate(flatSize);
        if (start > 0) {
            update.clear(0, start);
        }
        if (end < flatSize) {
            update.clear(end, flatSize - end);
        }
        for (int i = 0; i < viewportItems.size(); ++i) {
            T item = viewportItems.get(i);
            int index = start + i;
            if (!this.flushRequest.isViewportInvalidated() && !this.flushRequest.isItemInvalidated(item) && !this.flushRequest.isIndexInvalidated(index)) continue;
            update.set(index, List.of(this.generateItemJson(item)));
        }
        update.commit(++this.lastUpdateId);
    }

    @Override
    public void confirmUpdate(int updateId) {
        if (updateId != this.lastUpdateId) {
            return;
        }
        if (this.rootCache == null) {
            return;
        }
        HashSet<Object> viewportItemIds = new HashSet<Object>();
        for (int i = this.viewportRange.getStart(); i < this.viewportRange.getEnd(); ++i) {
            int index;
            Cache<T> cache;
            RootCache.ItemContext<T> context = this.rootCache.getContextByFlatIndex(i);
            if (context == null || !(cache = context.cache()).hasItem(index = context.index())) continue;
            T item2 = cache.getItem(index);
            viewportItemIds.add(this.getDataProvider().getId(item2));
        }
        this.rootCache.removeDescendantItemIf((SerializablePredicate & Serializable)item -> !viewportItemIds.contains(this.getDataProvider().getId(item)));
    }

    private HierarchicalDataProvider.HierarchyFormat getHierarchyFormat() {
        return this.getDataProvider().getHierarchyFormat();
    }

    private Set<Object> getExpandedItemIds() {
        return this.getHierarchyFormat().equals((Object)HierarchicalDataProvider.HierarchyFormat.FLATTENED) ? Collections.unmodifiableSet(this.expandedItemIds) : Collections.emptySet();
    }

    @Override
    public HierarchicalQuery<T, Object> buildQuery(int offset, int limit) {
        return this.buildQuery(null, offset, limit);
    }

    public HierarchicalQuery<T, Object> buildQuery(T parent, int offset, int limit) {
        return new HierarchicalQuery(offset, limit, this.getBackEndSorting(), this.getInMemorySorting(), this.getFilter(), this.getExpandedItemIds(), parent);
    }

    private Stream<T> fetchDataProviderChildren(T parent, Range range) {
        HierarchicalQuery<T, Object> query = this.buildQuery(parent, range.getStart(), range.length());
        return this.getDataProvider().fetchChildren(query).peek(item -> {
            if (item == null) {
                throw new IllegalStateException("Data provider returned a null item. Null values are not supported");
            }
        });
    }

    private int getDataProviderChildCount(T parent) {
        HierarchicalQuery<T, Object> query = new HierarchicalQuery<T, Object>(this.getFilter(), this.getExpandedItemIds(), parent);
        int count = this.getDataProvider().getChildCount(query);
        if (count < 0) {
            throw new IllegalStateException("Data provider returned a negative child count. Negative values are not supported");
        }
        return count;
    }

    private RootCache<T> ensureRootCache() {
        if (this.rootCache == null) {
            this.rootCache = new RootCache<T>(this.getDataProviderChildCount(null), ((HierarchicalDataProvider)this.getDataProvider())::getId){

                @Override
                void onItemRemoved(T item) {
                    super.onItemRemoved(item);
                    if (HierarchicalDataCommunicator.this.getKeyMapper().has(item)) {
                        HierarchicalDataCommunicator.this.dataGenerator.destroyData(item);
                        HierarchicalDataCommunicator.this.getKeyMapper().remove(item);
                    }
                }
            };
        }
        return this.rootCache;
    }

    @Override
    public void setItemCountEstimate(int itemCountEstimate) {
        throw new UnsupportedOperationException("Not supported in HierarchicalDataCommunicator");
    }

    @Override
    public int getItemCountEstimate() {
        throw new UnsupportedOperationException("Not supported in HierarchicalDataCommunicator");
    }

    @Override
    public void setItemCountEstimateIncrease(int itemCountEstimateIncrease) {
        throw new UnsupportedOperationException("Not supported in HierarchicalDataCommunicator");
    }

    @Override
    public int getItemCountEstimateIncrease() {
        throw new UnsupportedOperationException("Not supported in HierarchicalDataCommunicator");
    }

    @Override
    public void setDefinedSize(boolean definedSize) {
        throw new UnsupportedOperationException("Not supported in HierarchicalDataCommunicator");
    }

    @Override
    public boolean isDefinedSize() {
        return true;
    }

    private static class FlushRequest<T>
    implements Serializable {
        private boolean viewportInvalidated = false;
        private Set<T> invalidatedItems = new HashSet<T>();
        private Set<Range> invalidatedRanges = new HashSet<Range>();

        private FlushRequest() {
        }

        public void invalidateItem(T item) {
            this.invalidatedItems.add(item);
        }

        public boolean isItemInvalidated(T item) {
            return this.invalidatedItems.contains(item);
        }

        public void invalidateRange(Range range) {
            this.invalidatedRanges.add(range);
        }

        public boolean isIndexInvalidated(int index) {
            return this.invalidatedRanges.stream().anyMatch(range -> range.contains(index));
        }

        public void invalidateViewport() {
            this.viewportInvalidated = true;
        }

        public boolean isViewportInvalidated() {
            return this.viewportInvalidated;
        }
    }

    private class KeyMapperWrapper<V>
    extends KeyMapper<T> {
        private T object;

        private KeyMapperWrapper() {
        }

        @Override
        public String key(T o) {
            this.object = o;
            try {
                String string = super.key(o);
                return string;
            }
            finally {
                this.object = null;
            }
        }

        @Override
        protected String createKey() {
            return Optional.ofNullable((ValueProvider)HierarchicalDataCommunicator.this.uniqueKeyProviderSupplier.get()).map(provider -> (String)provider.apply(this.object)).orElse(super.createKey());
        }
    }
}

