/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.converter;

import com.vaadin.flow.data.binder.ErrorMessageProvider;
import com.vaadin.flow.data.binder.Result;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.data.converter.AbstractStringToNumberConverter;
import com.vaadin.flow.function.SerializableFunction;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

public class StringToBigIntegerConverter
extends AbstractStringToNumberConverter<BigInteger> {
    public StringToBigIntegerConverter(String errorMessage) {
        this(null, errorMessage);
    }

    public StringToBigIntegerConverter(BigInteger emptyValue, String errorMessage) {
        super(emptyValue, errorMessage);
    }

    public StringToBigIntegerConverter(ErrorMessageProvider errorMessageProvider) {
        this(null, errorMessageProvider);
    }

    public StringToBigIntegerConverter(BigInteger emptyValue, ErrorMessageProvider errorMessageProvider) {
        super(emptyValue, errorMessageProvider);
    }

    @Override
    protected NumberFormat getFormat(Locale locale) {
        NumberFormat numberFormat = super.getFormat(locale);
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).setParseBigDecimal(true);
        }
        return numberFormat;
    }

    @Override
    public Result<BigInteger> convertToModel(String value, ValueContext context) {
        return this.convertToNumber(value, context).map((SerializableFunction & Serializable)number -> {
            if (number == null) {
                return null;
            }
            if (number instanceof BigInteger) {
                return (BigInteger)number;
            }
            return ((BigDecimal)number).toBigInteger();
        });
    }
}

